/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.extensions.soap.SoapBinding;
import org.apache.cxf.tools.common.extensions.soap.SoapBody;
import org.apache.cxf.tools.common.extensions.soap.SoapHeader;
import org.apache.cxf.tools.common.extensions.soap.SoapOperation;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaPort;
import org.apache.cxf.tools.common.model.JavaReturn;
import org.apache.cxf.tools.common.model.JavaServiceClass;
import org.apache.cxf.tools.common.model.JavaType;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.NameUtil;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.AbstractProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.OperationProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ParameterProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;
import org.w3c.dom.Element;

public class ServiceProcessor
extends AbstractProcessor {
    private String soapOPAction = "SOAPACTION";
    private String soapOPStyle = "STYLE";
    private BindingType bindingType;
    private final int inHEADER = 1;
    private final int outHEADER = 2;
    private final int resultHeader = 3;
    private final int noHEADER = 0;
    private Object bindingObj;
    private ServiceInfo service;
    private final JAXWSBinding jaxwsBinding = new JAXWSBinding();

    public ServiceProcessor(ToolContext penv) {
        super(penv);
    }

    public void process(ServiceInfo si) throws ToolException {
        this.service = si;
        if (si.getName() == null) {
            this.processBindings((JavaModel)this.context.get(JavaModel.class));
        } else {
            this.processService((JavaModel)this.context.get(JavaModel.class));
        }
    }

    private boolean isNameCollision(String packageName, String className) {
        if (this.context.optionSet("overwrite")) {
            return false;
        }
        ClassCollector collector = (ClassCollector)this.context.get(ClassCollector.class);
        return collector.containTypesClass(packageName, className) || collector.containSeiClass(packageName, className) || collector.containExceptionClass(packageName, className);
    }

    private void processService(JavaModel model) throws ToolException {
        JavaServiceClass sclz = new JavaServiceClass(model);
        String name = NameUtil.mangleNameToClassName((String)this.service.getName().getLocalPart());
        String namespace = this.service.getName().getNamespaceURI();
        String packageName = ProcessorUtil.parsePackageName(namespace, this.context.mapPackageName(namespace));
        JAXWSBinding serviceBinding = null;
        if (this.service.getDescription() != null) {
            serviceBinding = (JAXWSBinding)this.service.getDescription().getExtensor(JAXWSBinding.class);
        }
        JAXWSBinding serviceBinding2 = (JAXWSBinding)this.service.getExtensor(JAXWSBinding.class);
        if (serviceBinding != null) {
            if (serviceBinding.getPackage() != null) {
                this.jaxwsBinding.setPackage(serviceBinding.getPackage());
            }
            if (serviceBinding.isEnableAsyncMapping()) {
                this.jaxwsBinding.setEnableAsyncMapping(true);
            }
            if (serviceBinding.isEnableMime()) {
                this.jaxwsBinding.setEnableMime(true);
            }
            this.jaxwsBinding.setEnableWrapperStyle(serviceBinding.isEnableWrapperStyle());
            if (serviceBinding.getJaxwsClass() != null && serviceBinding.getJaxwsClass().getClassName() != null) {
                name = serviceBinding.getJaxwsClass().getClassName();
                sclz.setClassJavaDoc(serviceBinding.getJaxwsClass().getComments());
            }
            sclz.setPackageJavaDoc(serviceBinding.getPackageJavaDoc());
        }
        if (serviceBinding2 != null) {
            if (serviceBinding2.getPackage() != null) {
                this.jaxwsBinding.setPackage(serviceBinding2.getPackage());
            }
            if (serviceBinding2.isEnableAsyncMapping()) {
                this.jaxwsBinding.setEnableAsyncMapping(true);
            }
            if (serviceBinding2.isEnableMime()) {
                this.jaxwsBinding.setEnableMime(true);
            }
            if (serviceBinding2.isEnableWrapperStyle()) {
                this.jaxwsBinding.setEnableWrapperStyle(true);
            }
            if (serviceBinding2.getJaxwsClass() != null && serviceBinding2.getJaxwsClass().getClassName() != null) {
                name = serviceBinding2.getJaxwsClass().getClassName();
                sclz.setClassJavaDoc(serviceBinding2.getJaxwsClass().getComments());
            }
            if (!serviceBinding2.getPackageJavaDoc().equals("")) {
                sclz.setPackageJavaDoc(serviceBinding2.getPackageJavaDoc());
            }
        }
        sclz.setServiceName(this.service.getName().getLocalPart());
        sclz.setNamespace(namespace);
        if (this.jaxwsBinding.getPackage() != null) {
            packageName = this.jaxwsBinding.getPackage();
        }
        sclz.setPackageName(packageName);
        while (this.isNameCollision(packageName, name)) {
            name = name + "_Service";
        }
        sclz.setName(name);
        if (model.getServiceClasses().containsKey(name)) {
            sclz = (JavaServiceClass)model.getServiceClasses().get(name);
        }
        Element handler = (Element)this.context.get("handler-chain");
        sclz.setHandlerChains(handler);
        Collection ports = this.service.getEndpoints();
        for (EndpointInfo port : ports) {
            JavaPort javaport = this.processPort(model, port);
            sclz.addPort(javaport);
        }
        sclz.setClassJavaDoc(this.jaxwsBinding.getClassJavaDoc());
        model.addServiceClass(name, sclz);
    }

    private JavaPort processPort(JavaModel model, EndpointInfo port) throws ToolException {
        JavaPort jport = new JavaPort(NameUtil.mangleNameToClassName((String)port.getName().getLocalPart()));
        jport.setPortName(port.getName().getLocalPart());
        BindingInfo binding = port.getBinding();
        jport.setBindingAdress(port.getAddress());
        jport.setBindingName(binding.getName().getLocalPart());
        String namespace = binding.getInterface().getName().getNamespaceURI();
        String packageName = ProcessorUtil.parsePackageName(namespace, this.context.mapPackageName(namespace));
        jport.setPackageName(packageName);
        InterfaceInfo infInfo = binding.getInterface();
        String portType = binding.getInterface().getName().getLocalPart();
        jport.setPortType(portType);
        JAXWSBinding infBinding = (JAXWSBinding)infInfo.getExtensor(JAXWSBinding.class);
        if (infBinding != null) {
            if (infBinding.getJaxwsClass() != null && !StringUtils.isEmpty((String)infBinding.getJaxwsClass().getClassName())) {
                jport.setPortType(infBinding.getJaxwsClass().getClassName());
                this.jaxwsBinding.setClassJavaDoc(infBinding.getJaxwsClass().getComments());
            }
            if (!infBinding.isEnableAsyncMapping()) {
                this.jaxwsBinding.setEnableAsyncMapping(false);
            }
            if (!infBinding.isEnableWrapperStyle()) {
                this.jaxwsBinding.setEnableWrapperStyle(false);
            }
            if (infBinding.getPackage() != null) {
                this.jaxwsBinding.setPackage(infBinding.getPackage());
            }
            if (!infBinding.getPackageJavaDoc().equals("")) {
                this.jaxwsBinding.setPackageJavaDoc(infBinding.getPackageJavaDoc());
            }
        }
        if (this.jaxwsBinding.getPackage() != null) {
            jport.setPackageName(this.jaxwsBinding.getPackage());
        }
        if (infBinding != null && infBinding.getJaxwsClass() != null && infBinding.getJaxwsClass().getClassName() != null) {
            String className = NameUtil.mangleNameToClassName((String)infBinding.getJaxwsClass().getClassName());
            jport.setInterfaceClass(className);
        } else {
            jport.setInterfaceClass(NameUtil.mangleNameToClassName((String)portType));
        }
        this.bindingType = this.getBindingType(binding);
        if (this.bindingType == null) {
            Message msg = new Message("BINDING_SPECIFY_ONE_PROTOCOL", LOG, new Object[]{binding.getName()});
            throw new ToolException(msg);
        }
        if (this.isSoapBinding()) {
            SoapBinding spbd = (SoapBinding)SOAPBindingUtil.getProxy(SoapBinding.class, (Object)this.bindingObj);
            jport.setStyle(SOAPBindingUtil.getSoapStyle((String)spbd.getStyle()));
            jport.setTransURI(spbd.getTransportURI());
        }
        Collection operations = binding.getOperations();
        for (BindingOperationInfo bop : operations) {
            this.processOperation(model, bop, binding);
        }
        return jport;
    }

    private void processBindings(JavaModel model) {
        for (BindingInfo binding : this.service.getBindings()) {
            this.bindingType = this.getBindingType(binding);
            if (this.bindingType == null) {
                Message msg = new Message("BINDING_SPECIFY_ONE_PROTOCOL", LOG, new Object[]{binding.getName()});
                throw new ToolException(msg);
            }
            Collection operations = binding.getOperations();
            for (BindingOperationInfo bop : operations) {
                this.processOperation(model, bop, binding);
            }
        }
    }

    private void processOperation(JavaModel model, BindingOperationInfo bop, BindingInfo binding) throws ToolException {
        JAXWSBinding bopBinding;
        boolean enableOpMime = false;
        JAXWSBinding bind = (JAXWSBinding)binding.getExtensor(JAXWSBinding.class);
        if (bind != null && bind.isEnableMime()) {
            enableOpMime = true;
        }
        if ((bopBinding = (JAXWSBinding)bop.getExtensor(JAXWSBinding.class)) != null && bopBinding.isEnableMime()) {
            enableOpMime = true;
            if (bopBinding.getJaxwsParas() != null) {
                this.jaxwsBinding.setJaxwsParas(bopBinding.getJaxwsParas());
            }
        }
        JavaInterface jf = null;
        for (JavaInterface jf2 : model.getInterfaces().values()) {
            if (!binding.getInterface().getName().getLocalPart().equals(jf2.getWebServiceName())) continue;
            jf = jf2;
        }
        if (this.isSoapBinding()) {
            SoapBinding soapBinding = (SoapBinding)this.bindingObj;
            if (SOAPBindingUtil.getSoapStyle((String)soapBinding.getStyle()) == null) {
                jf.setSOAPStyle(SOAPBinding.Style.DOCUMENT);
            } else {
                jf.setSOAPStyle(SOAPBindingUtil.getSoapStyle((String)soapBinding.getStyle()));
            }
        } else {
            jf.setSOAPStyle(SOAPBinding.Style.DOCUMENT);
        }
        Object[] methods = jf.getMethods().toArray();
        for (int i = 0; i < methods.length; ++i) {
            JAnnotation resultAnno;
            JavaMethod jm = (JavaMethod)methods[i];
            if (jm.getOperationName() == null || !jm.getOperationName().equals(bop.getName().getLocalPart())) continue;
            if (this.isSoapBinding()) {
                Map prop = this.getSoapOperationProp(bop);
                String soapAction = prop.get(this.soapOPAction) == null ? "" : (String)prop.get(this.soapOPAction);
                String soapStyle = prop.get(this.soapOPStyle) == null ? "" : (String)prop.get(this.soapOPStyle);
                jm.setSoapAction(soapAction);
                if (SOAPBindingUtil.getSoapStyle((String)soapStyle) == null && this.bindingObj == null) {
                    Message msg = new Message("BINDING_STYLE_NOT_DEFINED", LOG, new Object[0]);
                    throw new ToolException(msg);
                }
                if (SOAPBindingUtil.getSoapStyle((String)soapStyle) == null) {
                    jm.setSoapStyle(jf.getSOAPStyle());
                } else {
                    jm.setSoapStyle(SOAPBindingUtil.getSoapStyle((String)soapStyle));
                }
            } else {
                jm.setSoapStyle(jf.getSOAPStyle());
            }
            if (jm.getSoapStyle().equals((Object)SOAPBinding.Style.RPC)) {
                jm.getAnnotationMap().remove("SOAPBinding");
            }
            OperationProcessor processor = new OperationProcessor(this.context);
            int headerType = this.isNonWrappable(bop);
            OperationInfo opinfo = bop.getOperationInfo();
            JAXWSBinding opBinding = (JAXWSBinding)opinfo.getExtensor(JAXWSBinding.class);
            if (opBinding != null) {
                if (opBinding.isEnableWrapperStyle()) {
                    this.jaxwsBinding.setEnableWrapperStyle(true);
                } else {
                    this.jaxwsBinding.setEnableWrapperStyle(false);
                    if (!opBinding.isEnableAsyncMapping()) {
                        this.jaxwsBinding.setEnableAsyncMapping(false);
                    }
                }
                if (opBinding.isEnableMime()) {
                    enableOpMime = true;
                }
            }
            if (this.jaxwsBinding.isEnableMime() || enableOpMime) {
                jm.setMimeEnable(true);
            }
            if (jm.isWrapperStyle() && headerType > this.noHEADER || !this.jaxwsBinding.isEnableWrapperStyle() || jm.enableMime() && jm.isWrapperStyle()) {
                jm.setWrapperStyle(false);
                processor.processMethod(jm, bop.getOperationInfo());
                jm.getAnnotationMap().remove("ResponseWrapper");
                jm.getAnnotationMap().remove("RequestWrapper");
            } else {
                processor.processMethod(jm, bop.getOperationInfo());
            }
            if (headerType == this.resultHeader && (resultAnno = (JAnnotation)jm.getAnnotationMap().get("WebResult")) != null) {
                resultAnno.addElement(new JAnnotationElement("header", (Object)true, true));
            }
            this.processParameter(jm, bop);
        }
    }

    private void setParameterAsHeader(JavaParameter parameter) {
        parameter.setHeader(true);
        JAnnotation parameterAnnotation = parameter.getAnnotation("WebParam");
        parameterAnnotation.addElement(new JAnnotationElement("header", (Object)true, true));
        parameterAnnotation.addElement(new JAnnotationElement("name", (Object)parameter.getQName().getLocalPart()));
        parameterAnnotation.addElement(new JAnnotationElement("targetNamespace", (Object)parameter.getTargetNamespace()));
    }

    private void processParameter(JavaMethod jm, BindingOperationInfo operation) throws ToolException {
        ArrayList inbindings = null;
        if (operation.getInput() != null && (inbindings = operation.getInput().getExtensors(ExtensibilityElement.class)) == null) {
            inbindings = new ArrayList();
        }
        String use = null;
        for (ExtensibilityElement ext : inbindings) {
            if (SOAPBindingUtil.isSOAPBody((Object)ext)) {
                SoapBody soapBody = SOAPBindingUtil.getSoapBody((Object)ext);
                use = soapBody.getUse();
            } else if (SOAPBindingUtil.isSOAPHeader((Object)ext)) {
                this.processSoapHeader(jm, operation, ext);
            }
            if (!(ext instanceof MIMEMultipartRelated) || !jm.enableMime()) continue;
            this.processMultipart(jm, operation, (MIMEMultipartRelated)ext, JavaType.Style.IN);
        }
        if (operation.getOutput() != null) {
            ArrayList outbindings = operation.getOutput().getExtensors(ExtensibilityElement.class);
            if (outbindings == null) {
                outbindings = new ArrayList();
            }
            for (ExtensibilityElement ext : outbindings) {
                if (SOAPBindingUtil.isSOAPHeader((Object)ext)) {
                    SoapHeader soapHeader = SOAPBindingUtil.getSoapHeader((Object)ext);
                    boolean found = false;
                    for (JavaParameter parameter : jm.getParameters()) {
                        if (!soapHeader.getPart().equals(parameter.getPartName())) continue;
                        this.setParameterAsHeader(parameter);
                        found = true;
                    }
                    if (jm.getReturn().getName() != null && jm.getReturn().getName().equals(soapHeader.getPart())) {
                        found = true;
                    }
                    if (Boolean.valueOf((String)this.context.get("exsoapheader")).booleanValue() && !found) {
                        ParameterProcessor processor = new ParameterProcessor(this.context);
                        MessagePartInfo exPart = this.service.getMessage(soapHeader.getMessage()).getMessagePart(new QName(soapHeader.getMessage().getNamespaceURI(), soapHeader.getPart()));
                        JavaParameter jp = processor.addParameterFromBinding(jm, exPart, JavaType.Style.OUT);
                        this.setParameterAsHeader(jp);
                    }
                }
                if (!(ext instanceof MIMEMultipartRelated) || !jm.enableMime()) continue;
                this.processMultipart(jm, operation, (MIMEMultipartRelated)ext, JavaType.Style.OUT);
            }
        }
        jm.setSoapUse(SOAPBindingUtil.getSoapUse(use));
        if (SOAPBinding.Style.RPC == jm.getSoapStyle() && SOAPBinding.Use.ENCODED == jm.getSoapUse()) {
            System.err.println("** Unsupported RPC-Encoded Style Use **");
        }
        if (SOAPBinding.Style.RPC == jm.getSoapStyle() && SOAPBinding.Use.LITERAL == jm.getSoapUse()) {
            return;
        }
        if (SOAPBinding.Style.DOCUMENT == jm.getSoapStyle() && SOAPBinding.Use.LITERAL == jm.getSoapUse()) {
            return;
        }
    }

    private void processSoapHeader(JavaMethod jm, BindingOperationInfo operation, ExtensibilityElement ext) {
        SoapHeader soapHeader = SOAPBindingUtil.getSoapHeader((Object)ext);
        for (JavaParameter parameter : jm.getParameters()) {
            if (!soapHeader.getPart().equals(parameter.getPartName())) continue;
            this.setParameterAsHeader(parameter);
            break;
        }
    }

    private static String getJavaTypeForMimeType(MIMEPart mPart) {
        if (mPart.getExtensibilityElements().size() > 1) {
            return "javax.activation.DataHandler";
        }
        ExtensibilityElement extElement = (ExtensibilityElement)mPart.getExtensibilityElements().get(0);
        if (extElement instanceof MIMEContent) {
            MIMEContent mimeContent = (MIMEContent)extElement;
            if ("image/jpeg".equals(mimeContent.getType()) || "image/gif".equals(mimeContent.getType())) {
                return "java.awt.Image";
            }
            if ("text/xml".equals(mimeContent.getType()) || "application/xml".equals(mimeContent.getType())) {
                return "javax.xml.transform.Source";
            }
            return "javax.activation.DataHandler";
        }
        return "javax.activation.DataHandler";
    }

    public void processMultipart(JavaMethod jm, BindingOperationInfo operation, MIMEMultipartRelated ext, JavaType.Style style) throws ToolException {
        List mimeParts = ext.getMIMEParts();
        for (MIMEPart mPart : mimeParts) {
            for (ExtensibilityElement extElement : mPart.getExtensibilityElements()) {
                if (extElement instanceof MIMEContent) {
                    MIMEContent mimeContent = (MIMEContent)extElement;
                    String mimeJavaType = ServiceProcessor.getJavaTypeForMimeType(mPart);
                    if (JavaType.Style.IN.equals((Object)style)) {
                        String paramName = ProcessorUtil.mangleNameToVariableName(mimeContent.getPart());
                        JavaParameter jp = jm.getParameter(paramName);
                        if (jp == null) {
                            Message message = new Message("MIMEPART_CANNOT_MAP", LOG, new Object[]{mimeContent.getPart()});
                            throw new ToolException(message);
                        }
                        if (jp.getClassName().equals(mimeJavaType)) continue;
                        jp.setClassName(mimeJavaType);
                        continue;
                    }
                    if (!JavaType.Style.OUT.equals((Object)style)) continue;
                    JavaReturn jp = null;
                    if (!"void".equals(jm.getReturn().getType()) && mimeContent.getPart().equals(jm.getReturn().getName())) {
                        jp = jm.getReturn();
                        jp.setClassName(mimeJavaType);
                    }
                    if (jp == null) {
                        for (JavaParameter para : jm.getParameters()) {
                            if (!mimeContent.getPart().equals(para.getPartName())) continue;
                            jp = para;
                        }
                        if (jp != null) {
                            ((JavaParameter)jp).setClassName(mimeJavaType);
                        }
                    }
                    if (jp != null) continue;
                    Message message = new Message("MIMEPART_CANNOT_MAP", LOG, new Object[]{mimeContent.getPart()});
                    throw new ToolException(message);
                }
                if (!(extElement instanceof SOAPHeader)) continue;
                this.processSoapHeader(jm, operation, extElement);
            }
        }
    }

    private Map getSoapOperationProp(BindingOperationInfo bop) {
        HashMap<String, String> soapOPProp = new HashMap<String, String>();
        if (bop.getExtensor(ExtensibilityElement.class) != null) {
            for (ExtensibilityElement ext : bop.getExtensors(ExtensibilityElement.class)) {
                if (!SOAPBindingUtil.isSOAPOperation((Object)ext)) continue;
                SoapOperation soapOP = SOAPBindingUtil.getSoapOperation((Object)ext);
                soapOPProp.put(this.soapOPAction, soapOP.getSoapActionURI());
                soapOPProp.put(this.soapOPStyle, soapOP.getStyle());
            }
        } else {
            for (ExtensibilityElement ext : bop.getBinding().getExtensors(ExtensibilityElement.class)) {
                if (!SOAPBindingUtil.isSOAPOperation((Object)ext)) continue;
                SoapOperation soapOP = SOAPBindingUtil.getSoapOperation((Object)ext);
                soapOPProp.put(this.soapOPAction, soapOP.getSoapActionURI());
                soapOPProp.put(this.soapOPStyle, soapOP.getStyle());
            }
        }
        return soapOPProp;
    }

    private BindingType getBindingType(BindingInfo binding) {
        for (ExtensibilityElement ext : binding.getExtensors(ExtensibilityElement.class)) {
            if (SOAPBindingUtil.isSOAPBinding((Object)ext)) {
                this.bindingObj = SOAPBindingUtil.getSoapBinding((Object)ext);
                return BindingType.SOAPBinding;
            }
            if (!(ext instanceof HTTPBinding)) continue;
            this.bindingObj = (HTTPBinding)ext;
            return BindingType.HTTPBinding;
        }
        return BindingType.XMLBinding;
    }

    private int isNonWrappable(BindingOperationInfo bop) {
        List extensors;
        QName operationName = bop.getName();
        MessageInfo bodyMessage = null;
        QName headerMessage = null;
        SoapHeader header = null;
        boolean containParts = false;
        boolean isSameMessage = false;
        boolean isNonWrappable = false;
        boolean allPartsHeader = false;
        int result = this.noHEADER;
        if (bop.getInput() != null && bop.getInput().getExtensors(ExtensibilityElement.class) != null) {
            extensors = bop.getInput().getExtensors(ExtensibilityElement.class);
            if (extensors != null) {
                for (ExtensibilityElement ext : extensors) {
                    if (SOAPBindingUtil.isSOAPBody((Object)ext)) {
                        bodyMessage = this.getMessage(operationName, true);
                    }
                    if (!SOAPBindingUtil.isSOAPHeader((Object)ext)) continue;
                    header = SOAPBindingUtil.getSoapHeader((Object)ext);
                    headerMessage = header.getMessage();
                    if (header.getPart().length() <= 0) continue;
                    containParts = true;
                }
            }
            if (headerMessage != null && bodyMessage != null && headerMessage.getNamespaceURI().equalsIgnoreCase(bodyMessage.getName().getNamespaceURI()) && headerMessage.getLocalPart().equalsIgnoreCase(bodyMessage.getName().getLocalPart())) {
                isSameMessage = true;
            }
            boolean bl = isNonWrappable = isSameMessage && containParts;
            if (isNonWrappable) {
                result = this.inHEADER;
            }
        }
        isSameMessage = false;
        containParts = false;
        if (bop.getOutput() != null && bop.getOutput().getExtensors(ExtensibilityElement.class) != null) {
            extensors = bop.getOutput().getExtensors(ExtensibilityElement.class);
            if (extensors != null) {
                for (ExtensibilityElement ext : extensors) {
                    if (SOAPBindingUtil.isSOAPBody((Object)ext)) {
                        bodyMessage = this.getMessage(operationName, false);
                    }
                    if (!SOAPBindingUtil.isSOAPHeader((Object)ext)) continue;
                    header = SOAPBindingUtil.getSoapHeader((Object)ext);
                    headerMessage = header.getMessage();
                    if (header.getPart().length() <= 0) continue;
                    containParts = true;
                }
            }
            if (headerMessage != null && bodyMessage != null && headerMessage.getNamespaceURI().equalsIgnoreCase(bodyMessage.getName().getNamespaceURI()) && headerMessage.getLocalPart().equalsIgnoreCase(bodyMessage.getName().getLocalPart())) {
                isSameMessage = true;
                if (bodyMessage.getMessageParts().size() == 1) {
                    allPartsHeader = true;
                }
            }
            boolean bl = isNonWrappable = isSameMessage && containParts;
            if (isNonWrappable && allPartsHeader) {
                result = this.resultHeader;
            }
            if (isNonWrappable && !allPartsHeader) {
                result = this.outHEADER;
            }
        }
        return result;
    }

    private MessageInfo getMessage(QName operationName, boolean isIn) {
        Iterator i$ = this.service.getInterface().getOperations().iterator();
        if (i$.hasNext()) {
            OperationInfo operation = (OperationInfo)i$.next();
            if (operationName.equals(operation.getName()) && isIn) {
                return operation.getInput();
            }
            return operation.getOutput();
        }
        return null;
    }

    private boolean isSoapBinding() {
        return this.bindingType != null && "SOAPBinding".equals(this.bindingType.name());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BindingType {
        HTTPBinding,
        SOAPBinding,
        XMLBinding;

    }
}

