/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xsdvalidation;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.xml.transform.TransformerException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.XmlSchemaValidationManager;
import org.apache.cxf.xsdvalidation.XercesSchemaValidationUtils;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaSerializer;
import org.w3c.dom.DOMErrorHandler;

public class XercesXsdValidationImpl
implements XmlSchemaValidationManager {
    private static final Logger LOG = LogUtils.getL7dLogger(XercesXsdValidationImpl.class);
    private Bus bus;
    private XercesSchemaValidationUtils utils;

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    @PostConstruct
    public void register() {
        try {
            this.utils = new XercesSchemaValidationUtils();
        }
        catch (Exception e) {
            return;
        }
        if (null != this.bus) {
            this.bus.setExtension((Object)this, XmlSchemaValidationManager.class);
        }
    }

    public void validateSchemas(XmlSchemaCollection schemas, DOMErrorHandler errorHandler) {
        try {
            this.utils.tryToParseSchemas(schemas, errorHandler);
        }
        catch (XmlSchemaSerializer.XmlSchemaSerializerException e) {
            LOG.log(Level.WARNING, "XML Schema serialization error", e);
        }
        catch (TransformerException e) {
            LOG.log(Level.SEVERE, "TraX failure converting DOM to string", e);
        }
    }
}

