/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import com.sun.tools.xjc.Driver;
import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cxf.maven_plugin.XsdOption;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.downloader.Downloader;

public abstract class AbstractXSDToJavaMojo
extends AbstractMojo {
    MavenProject project;
    XsdOption[] xsdOptions;
    File markerDirectory;
    private List<String> extensions;
    private Downloader downloader;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteArtifactRepositories;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactFactory artifactFactory;

    abstract String getOutputDir();

    private URI mapLocation(String s) throws MojoExecutionException {
        try {
            File file = new File(s);
            URI uri = file.exists() ? file.toURI() : ((file = new File(this.project.getBasedir(), s)).exists() ? file.toURI() : new URI(s));
            if ("classpath".equals(uri.getScheme())) {
                URL url = Thread.currentThread().getContextClassLoader().getResource(s.substring(10));
                if (url == null) {
                    url = Thread.currentThread().getContextClassLoader().getResource(s.substring(11));
                }
                if (url != null) {
                    uri = url.toURI();
                }
            }
            return uri;
        }
        catch (URISyntaxException e1) {
            throw new MojoExecutionException("Could not map " + s, (Exception)e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        String outputDir = this.getOutputDir();
        File outputDirFile = new File(outputDir);
        outputDirFile.mkdirs();
        this.markerDirectory.mkdirs();
        boolean result = true;
        if (this.xsdOptions == null) {
            throw new MojoExecutionException("Must specify xsdOptions");
        }
        for (int x = 0; x < this.xsdOptions.length; ++x) {
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                String[] args = this.getArguments(this.xsdOptions[x], outputDir);
                URI xsdURI = this.mapLocation(this.xsdOptions[x].getXsd());
                URI basedir = this.project.getBasedir().toURI();
                String doneFileName = xsdURI.toString();
                if (doneFileName.startsWith(basedir.toString())) {
                    doneFileName = doneFileName.substring(basedir.toString().length());
                }
                doneFileName = doneFileName.replace('?', '_').replace('&', '_').replace('/', '_').replace('\\', '_').replace(':', '_').replace('!', '_');
                File doneFile = new File(this.markerDirectory, "." + doneFileName + ".DONE");
                long srctimestamp = 0L;
                if ("file".equals(xsdURI.getScheme())) {
                    srctimestamp = new File(xsdURI).lastModified();
                } else {
                    try {
                        srctimestamp = xsdURI.toURL().openConnection().getDate();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                boolean doWork = false;
                if (!doneFile.exists()) {
                    doWork = true;
                } else if (srctimestamp > doneFile.lastModified()) {
                    doWork = true;
                } else {
                    File[] files = this.xsdOptions[x].getDependencies();
                    if (files != null) {
                        for (int z = 0; z < files.length; ++z) {
                            if (files[z].lastModified() <= doneFile.lastModified()) continue;
                            doWork = true;
                        }
                    }
                }
                if (doWork) {
                    try {
                        File[] dirs;
                        int i = Driver.run((String[])args, (PrintStream)System.out, (PrintStream)System.err);
                        if (i == 0) {
                            doneFile.delete();
                            doneFile.createNewFile();
                        }
                        if ((dirs = this.xsdOptions[x].getDeleteDirs()) != null) {
                            for (int idx = 0; idx < dirs.length; ++idx) {
                                result = result && this.deleteDir(dirs[idx]);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException(e.getMessage(), e);
                    }
                }
                if (result) continue;
                throw new MojoExecutionException("Could not delete redundant dirs");
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
    }

    private String[] getArguments(XsdOption option, String outputDir) throws MojoExecutionException {
        ArrayList<URL> newCp = new ArrayList<URL>();
        ArrayList<String> list = new ArrayList<String>();
        if (this.extensions != null && this.extensions.size() > 0) {
            HashSet<Artifact> artifacts = new HashSet<Artifact>();
            try {
                for (String ext : this.extensions) {
                    String[] s = ext.split(":");
                    Artifact artifact = this.artifactFactory.createBuildArtifact(s[0], s[1], s[2], "jar");
                    artifacts.add(artifact);
                    MavenProject p = this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteArtifactRepositories, this.localRepository);
                    Set a2 = p.createArtifacts(this.artifactFactory, "runtime", (ArtifactFilter)new ScopeArtifactFilter("runtime"));
                    for (Artifact a : a2) {
                        artifacts.add(a);
                    }
                }
                for (Artifact art : artifacts) {
                    File f = this.downloader.download(art.getGroupId(), art.getArtifactId(), art.getVersion(), this.localRepository, this.remoteArtifactRepositories);
                    list.add("-classpath");
                    list.add(f.getAbsolutePath());
                    newCp.add(f.toURI().toURL());
                }
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Could not download extension artifact", ex);
            }
        }
        if (!newCp.isEmpty()) {
            Thread.currentThread().setContextClassLoader(new URLClassLoader(newCp.toArray(new URL[newCp.size()]), Thread.currentThread().getContextClassLoader()));
        }
        if (option.getPackagename() != null) {
            list.add("-p");
            list.add(option.getPackagename());
        }
        if (option.getBindingFile() != null) {
            list.add("-b");
            list.add(this.mapLocation(option.getBindingFile()).toString());
        }
        if (option.getCatalog() != null) {
            list.add("-catalog");
            list.add(option.getCatalog());
        }
        if (option.isExtension()) {
            list.add("-extension");
        }
        if (option.getExtensionArgs() != null) {
            Iterator it = option.getExtensionArgs().iterator();
            while (it.hasNext()) {
                list.add(it.next().toString());
            }
        }
        if (this.getLog().isDebugEnabled()) {
            list.add("-verbose");
        } else {
            list.add("-quiet");
        }
        list.add("-d");
        list.add(outputDir);
        list.add(this.mapLocation(option.getXsd()).toString());
        return list.toArray(new String[list.size()]);
    }

    private boolean deleteDir(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int idx = 0; idx < files.length; ++idx) {
                this.deleteDir(files[idx]);
            }
        }
        if (f.exists()) {
            return f.delete();
        }
        return true;
    }
}

