/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import com.sun.tools.xjc.Driver;
import com.sun.tools.xjc.XJCListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cxf.maven_plugin.XsdOption;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.downloader.Downloader;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.xml.sax.SAXParseException;

public abstract class AbstractXSDToJavaMojo
extends AbstractMojo {
    MavenProject project;
    XsdOption[] xsdOptions;
    File markerDirectory;
    private List<String> extensions;
    private Downloader downloader;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteArtifactRepositories;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactFactory artifactFactory;
    private BuildContext buildContext;

    abstract String getOutputDir();

    private URI mapLocation(String s) throws MojoExecutionException {
        try {
            File file = new File(s);
            URI uri = file.exists() ? file.toURI() : ((file = new File(this.project.getBasedir(), s)).exists() ? file.toURI() : new URI(s));
            if ("classpath".equals(uri.getScheme())) {
                URL url = Thread.currentThread().getContextClassLoader().getResource(s.substring(10));
                if (url == null) {
                    url = Thread.currentThread().getContextClassLoader().getResource(s.substring(11));
                }
                if (url != null) {
                    uri = url.toURI();
                }
            }
            return uri;
        }
        catch (URISyntaxException e1) {
            throw new MojoExecutionException("Could not map " + s, (Exception)e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        String outputDir = this.getOutputDir();
        File outputDirFile = new File(outputDir);
        outputDirFile.mkdirs();
        this.markerDirectory.mkdirs();
        boolean result = true;
        if (this.xsdOptions == null) {
            throw new MojoExecutionException("Must specify xsdOptions");
        }
        ArrayList<File> errorFiles = new ArrayList<File>();
        for (int x = 0; x < this.xsdOptions.length; ++x) {
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                int z;
                long bts;
                URI bindingURI;
                String[] args = this.getArguments(this.xsdOptions[x], outputDir);
                URI xsdURI = this.mapLocation(this.xsdOptions[x].getXsd());
                URI basedir = this.project.getBasedir().toURI();
                String doneFileName = xsdURI.toString();
                if (doneFileName.startsWith(basedir.toString())) {
                    doneFileName = doneFileName.substring(basedir.toString().length());
                }
                doneFileName = doneFileName.replace('?', '_').replace('&', '_').replace('/', '_').replace('\\', '_').replace(':', '_').replace('!', '_');
                File doneFile = new File(this.markerDirectory, "." + doneFileName + ".DONE");
                long srctimestamp = 0L;
                if ("file".equals(xsdURI.getScheme())) {
                    srctimestamp = new File(xsdURI).lastModified();
                } else {
                    try {
                        srctimestamp = xsdURI.toURL().openConnection().getDate();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (this.xsdOptions[x].getBindingFile() != null && "file".equals((bindingURI = this.mapLocation(this.xsdOptions[x].getBindingFile())).getScheme()) && (bts = new File(bindingURI).lastModified()) > srctimestamp) {
                    srctimestamp = bts;
                }
                boolean doWork = false;
                if (!doneFile.exists()) {
                    doWork = true;
                } else if (srctimestamp > doneFile.lastModified()) {
                    doWork = true;
                } else {
                    File[] files = this.xsdOptions[x].getDependencies();
                    if (files != null) {
                        for (z = 0; z < files.length; ++z) {
                            if (files[z].lastModified() <= doneFile.lastModified()) continue;
                            doWork = true;
                        }
                    }
                }
                if (doWork) {
                    try {
                        File[] dirs;
                        File[] files = this.xsdOptions[x].getDependencies();
                        if (files != null) {
                            for (z = 0; z < files.length; ++z) {
                                if (files[z].lastModified() <= doneFile.lastModified()) continue;
                                this.buildContext.removeMessages(files[z]);
                            }
                        }
                        this.removeMessages(this.xsdOptions[x].getXsd());
                        this.removeMessages(this.xsdOptions[x].getBindingFile());
                        int i = Driver.run((String[])args, (XJCListener)new Listener(errorFiles));
                        if (i == 0) {
                            doneFile.delete();
                            doneFile.createNewFile();
                        }
                        if ((dirs = this.xsdOptions[x].getDeleteDirs()) != null) {
                            for (int idx = 0; idx < dirs.length; ++idx) {
                                result = result && this.deleteDir(dirs[idx]);
                            }
                        }
                        this.buildContext.refresh(outputDirFile);
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException(e.getMessage(), e);
                    }
                }
                if (result) continue;
                throw new MojoExecutionException("Could not delete redundant dirs");
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
    }

    private void removeMessages(String file) throws MojoExecutionException {
        File f;
        if (file == null) {
            return;
        }
        URI location = this.mapLocation(file);
        if ("file".equals(location.getScheme()) && (f = new File(location)).exists()) {
            this.buildContext.removeMessages(f);
        }
    }

    private String[] getArguments(XsdOption option, String outputDir) throws MojoExecutionException {
        ArrayList<URL> newCp = new ArrayList<URL>();
        ArrayList<String> list = new ArrayList<String>();
        if (this.extensions != null && this.extensions.size() > 0) {
            HashSet<Artifact> artifacts = new HashSet<Artifact>();
            try {
                for (String ext : this.extensions) {
                    String[] s = ext.split(":");
                    if (s.length != 3) {
                        throw new MojoExecutionException("Extension should be defined as groupId:artifactId:version. " + ext + " does not meet that pattern.");
                    }
                    Artifact artifact = this.artifactFactory.createBuildArtifact(s[0], s[1], s[2], "jar");
                    artifacts.add(artifact);
                    MavenProject p = this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteArtifactRepositories, this.localRepository);
                    Set a2 = p.createArtifacts(this.artifactFactory, "runtime", (ArtifactFilter)new ScopeArtifactFilter("runtime"));
                    for (Artifact a : a2) {
                        artifacts.add(a);
                    }
                }
                for (Artifact art : artifacts) {
                    File f = this.downloader.download(art.getGroupId(), art.getArtifactId(), art.getVersion(), this.localRepository, this.remoteArtifactRepositories);
                    list.add("-classpath");
                    list.add(f.getAbsolutePath());
                    newCp.add(f.toURI().toURL());
                }
            }
            catch (MojoExecutionException mojo) {
                throw mojo;
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Could not download extension artifact", ex);
            }
        }
        if (!newCp.isEmpty()) {
            Thread.currentThread().setContextClassLoader(new URLClassLoader(newCp.toArray(new URL[newCp.size()]), Thread.currentThread().getContextClassLoader()));
        }
        if (option.getPackagename() != null) {
            list.add("-p");
            list.add(option.getPackagename());
        }
        if (option.getBindingFile() != null) {
            list.add("-b");
            list.add(this.mapLocation(option.getBindingFile()).toString());
        }
        if (option.getCatalog() != null) {
            list.add("-catalog");
            list.add(option.getCatalog());
        }
        if (option.isExtension()) {
            list.add("-extension");
        }
        if (option.getExtensionArgs() != null) {
            Iterator it = option.getExtensionArgs().iterator();
            while (it.hasNext()) {
                list.add(it.next().toString());
            }
        }
        if (this.getLog().isDebugEnabled()) {
            list.add("-verbose");
        } else {
            list.add("-quiet");
        }
        list.add("-d");
        list.add(outputDir);
        list.add(this.mapLocation(option.getXsd()).toString());
        return list.toArray(new String[list.size()]);
    }

    private boolean deleteDir(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int idx = 0; idx < files.length; ++idx) {
                this.deleteDir(files[idx]);
            }
        }
        if (f.exists()) {
            return f.delete();
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Listener
    extends XJCListener {
        private final List<File> errorfiles;

        Listener(List<File> errorfiles) {
            this.errorfiles = errorfiles;
        }

        public void error(SAXParseException exception) {
            File file = this.mapFile(exception.getSystemId());
            if (file != null && !this.errorfiles.contains(file)) {
                AbstractXSDToJavaMojo.this.buildContext.removeMessages(file);
                this.errorfiles.add(file);
            }
            AbstractXSDToJavaMojo.this.buildContext.addMessage(file, exception.getLineNumber(), exception.getColumnNumber(), this.mapMessage(exception.getLocalizedMessage()), 2, (Throwable)exception);
        }

        private String mapMessage(String localizedMessage) {
            return localizedMessage;
        }

        private File mapFile(String s) {
            File file = null;
            if (s != null && s.startsWith("file:")) {
                if (s.contains("#")) {
                    s = s.substring(0, s.indexOf(35));
                }
                try {
                    URI uri = new URI(s);
                    file = new File(uri);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return file;
        }

        public void fatalError(SAXParseException exception) {
            this.error(exception);
        }

        public void warning(SAXParseException exception) {
            File file = this.mapFile(exception.getSystemId());
            if (file != null && !this.errorfiles.contains(file)) {
                AbstractXSDToJavaMojo.this.buildContext.removeMessages(file);
                this.errorfiles.add(file);
            }
            AbstractXSDToJavaMojo.this.buildContext.addMessage(file, exception.getLineNumber(), exception.getColumnNumber(), this.mapMessage(exception.getLocalizedMessage()), 1, (Throwable)exception);
        }

        public void info(SAXParseException exception) {
        }
    }
}

