/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.maven_plugin.XJCErrorListener;
import org.apache.cxf.maven_plugin.XSDToJavaRunner;
import org.apache.cxf.maven_plugin.XsdOption;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractXSDToJavaMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Parameter
    XsdOption[] xsdOptions;
    @Parameter(defaultValue="${project.build.directory}/cxf-xsd-plugin-markers", property="cxf.markerDirectory")
    File markerDirectory;
    @Parameter
    private List<String> extensions;
    @Component
    private BuildContext buildContext;
    @Component
    private RepositorySystem repository;
    @Component
    private MavenSession session;
    @Parameter(defaultValue="false")
    private boolean fork;
    @Parameter(defaultValue="${java.home}/bin/java")
    private String javaExecutable;
    @Parameter(property="cxf.xjc.jvmArgs")
    private String additionalJvmArgs;
    @Parameter(property="plugin.artifacts", readonly=true, required=true)
    private List<Artifact> pluginArtifacts;

    abstract String getOutputDir();

    private URI mapLocation(String s) throws MojoExecutionException {
        try {
            File file = new File(s);
            URI uri = file.exists() ? file.toURI() : ((file = new File(this.project.getBasedir(), s)).exists() ? file.toURI() : new URI(s));
            if ("classpath".equals(uri.getScheme())) {
                URL url = Thread.currentThread().getContextClassLoader().getResource(s.substring(10));
                if (url == null) {
                    url = Thread.currentThread().getContextClassLoader().getResource(s.substring(11));
                }
                if (url != null) {
                    uri = url.toURI();
                }
            }
            return uri;
        }
        catch (URISyntaxException e1) {
            throw new MojoExecutionException("Could not map " + s, (Exception)e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        String outputDir = this.getOutputDir();
        File outputDirFile = new File(outputDir);
        outputDirFile.mkdirs();
        this.markerDirectory.mkdirs();
        boolean result = true;
        if (this.xsdOptions == null) {
            throw new MojoExecutionException("Must specify xsdOptions");
        }
        for (int x = 0; x < this.xsdOptions.length; ++x) {
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                int z;
                long bts;
                URI bindingURI;
                URI xsdURI = this.mapLocation(this.xsdOptions[x].getXsd());
                URI basedir = this.project.getBasedir().toURI();
                String doneFileName = xsdURI.toString();
                if (doneFileName.startsWith(basedir.toString())) {
                    doneFileName = doneFileName.substring(basedir.toString().length());
                }
                doneFileName = doneFileName.replace('?', '_').replace('&', '_').replace('/', '_').replace('\\', '_').replace(':', '_').replace('!', '_');
                File doneFile = new File(this.markerDirectory, "." + doneFileName + ".DONE");
                long srctimestamp = 0L;
                if ("file".equals(xsdURI.getScheme())) {
                    srctimestamp = new File(xsdURI).lastModified();
                } else {
                    try {
                        srctimestamp = xsdURI.toURL().openConnection().getDate();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (this.xsdOptions[x].getBindingFile() != null && "file".equals((bindingURI = this.mapLocation(this.xsdOptions[x].getBindingFile())).getScheme()) && (bts = new File(bindingURI).lastModified()) > srctimestamp) {
                    srctimestamp = bts;
                }
                boolean doWork = false;
                if (!doneFile.exists()) {
                    doWork = true;
                } else if (srctimestamp > doneFile.lastModified()) {
                    doWork = true;
                } else {
                    File[] files = this.xsdOptions[x].getDependencies();
                    if (files != null) {
                        for (z = 0; z < files.length; ++z) {
                            if (files[z].lastModified() <= doneFile.lastModified()) continue;
                            doWork = true;
                        }
                    }
                }
                if (doWork) {
                    try {
                        File[] dirs;
                        File[] files = this.xsdOptions[x].getDependencies();
                        if (files != null) {
                            for (z = 0; z < files.length; ++z) {
                                if (files[z].lastModified() <= doneFile.lastModified()) continue;
                                this.buildContext.removeMessages(files[z]);
                            }
                        }
                        this.removeMessages(this.xsdOptions[x].getXsd());
                        this.removeMessages(this.xsdOptions[x].getBindingFile());
                        int i = this.run(this.xsdOptions[x], outputDir);
                        if (i == 0) {
                            doneFile.delete();
                            doneFile.createNewFile();
                        }
                        if ((dirs = this.xsdOptions[x].getDeleteDirs()) != null) {
                            for (int idx = 0; idx < dirs.length; ++idx) {
                                result = result && this.deleteDir(dirs[idx]);
                            }
                        }
                        this.buildContext.refresh(outputDirFile);
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException(e.getMessage(), e);
                    }
                }
                if (result) continue;
                throw new MojoExecutionException("Could not delete redundant dirs");
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
    }

    private List<File> resolve(String artifactDescriptor) {
        String[] s = artifactDescriptor.split(":");
        String type = s.length >= 4 ? s[3] : "jar";
        Artifact artifact = this.repository.createArtifact(s[0], s[1], s[2], type);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setResolveRoot(true).setResolveTransitively(true);
        request.setServers(this.session.getRequest().getServers());
        request.setMirrors(this.session.getRequest().getMirrors());
        request.setProxies(this.session.getRequest().getProxies());
        request.setLocalRepository(this.session.getLocalRepository());
        request.setRemoteRepositories(this.session.getRequest().getRemoteRepositories());
        ArtifactResolutionResult result = this.repository.resolve(request);
        ArrayList<File> files = new ArrayList<File>();
        for (Artifact a : result.getArtifacts()) {
            files.add(a.getFile());
        }
        if (!files.contains(artifact.getFile())) {
            files.add(artifact.getFile());
        }
        return files;
    }

    protected List<String> getClasspathElements() throws DependencyResolutionRequiredException {
        return this.project.getCompileClasspathElements();
    }

    private int run(XsdOption option, String outputDir) throws Exception {
        if (!this.fork) {
            XJCErrorListener listener;
            String[] args = this.getArguments(option, outputDir);
            int i = new XSDToJavaRunner(args, listener = new XJCErrorListener(this.buildContext), new File(option.getXsd()), this.getClasspathElements()).run();
            if (i != 0 && listener.getFirstError() != null) {
                throw listener.getFirstError();
            }
            return i;
        }
        return this.runForked(option, outputDir);
    }

    private void removeMessages(String file) throws MojoExecutionException {
        File f;
        if (file == null) {
            return;
        }
        URI location = this.mapLocation(file);
        if ("file".equals(location.getScheme()) && (f = new File(location)).exists()) {
            this.buildContext.removeMessages(f);
        }
    }

    private String[] getArguments(XsdOption option, String outputDir) throws MojoExecutionException {
        ArrayList<URL> newCp = new ArrayList<URL>();
        ArrayList<String> list = new ArrayList<String>();
        if (this.extensions != null && this.extensions.size() > 0) {
            try {
                for (String ext : this.extensions) {
                    for (File file : this.resolve(ext)) {
                        list.add("-classpath");
                        list.add(file.getAbsolutePath());
                        newCp.add(file.toURI().toURL());
                    }
                }
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Could not download extension artifact", ex);
            }
        }
        if (!newCp.isEmpty()) {
            Thread.currentThread().setContextClassLoader(new URLClassLoader(newCp.toArray(new URL[newCp.size()]), Thread.currentThread().getContextClassLoader()));
        }
        if (option.getPackagename() != null) {
            list.add("-p");
            list.add(option.getPackagename());
        }
        if (option.getBindingFile() != null) {
            list.add("-b");
            list.add(this.mapLocation(option.getBindingFile()).toString());
        }
        if (option.getCatalog() != null) {
            list.add("-catalog");
            list.add(option.getCatalog());
        }
        if (option.isExtension()) {
            list.add("-extension");
        }
        if (option.getExtensionArgs() != null) {
            list.addAll(option.getExtensionArgs());
        }
        if (this.getLog().isDebugEnabled()) {
            list.add("-verbose");
        }
        list.add("-d");
        list.add(outputDir);
        list.add(this.mapLocation(option.getXsd()).toString());
        return list.toArray(new String[list.size()]);
    }

    private boolean deleteDir(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int idx = 0; idx < files.length; ++idx) {
                this.deleteDir(files[idx]);
            }
        }
        if (f.exists()) {
            return f.delete();
        }
        return true;
    }

    private File getJavaExecutable() throws IOException {
        String exe = this.isWindows() && !this.javaExecutable.endsWith(".exe") ? ".exe" : "";
        File javaExe = new File(this.javaExecutable + exe);
        if (!javaExe.isFile()) {
            throw new IOException("The java executable '" + javaExe + "' doesn't exist or is not a file." + "Verify the <javaExecutable/> parameter.");
        }
        return javaExe;
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return false;
        }
        return osName.startsWith("Windows");
    }

    private int runForked(XsdOption option, String outputDir) throws Exception {
        int exitCode;
        String[] args = this.getArguments(option, outputDir);
        Commandline cmd = new Commandline();
        cmd.getShell().setQuotedArgumentsEnabled(true);
        cmd.setWorkingDirectory(this.project.getBuild().getDirectory());
        try {
            cmd.setExecutable(this.getJavaExecutable().getAbsolutePath());
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        cmd.createArg().setLine(this.additionalJvmArgs);
        File file = null;
        try {
            file = File.createTempFile("cxf-xjc-plugin", ".jar");
            file.deleteOnExit();
            JarArchiver jar = new JarArchiver();
            jar.setDestFile(file.getAbsoluteFile());
            Manifest manifest = new Manifest();
            Manifest.Attribute attr = new Manifest.Attribute();
            attr.setName("Class-Path");
            StringBuilder b = new StringBuilder(8000);
            for (String cp : this.getClasspathElements()) {
                b.append(cp).append(' ');
            }
            for (Artifact a : this.pluginArtifacts) {
                b.append(a.getFile().getAbsolutePath()).append(' ');
            }
            attr.setValue(b.toString());
            manifest.getMainSection().addConfiguredAttribute(attr);
            attr = new Manifest.Attribute();
            attr.setName("Main-Class");
            attr.setValue(XSDToJavaRunner.class.getName());
            manifest.getMainSection().addConfiguredAttribute(attr);
            jar.addConfiguredManifest(manifest);
            jar.createArchive();
            cmd.createArg().setValue("-jar");
            String tmpFilePath = file.getAbsolutePath();
            if (tmpFilePath.contains(" ")) {
                tmpFilePath = "\"" + tmpFilePath + "\"";
            }
            cmd.createArg().setValue(tmpFilePath);
        }
        catch (Exception e1) {
            throw new MojoExecutionException("Could not create runtime jar", e1);
        }
        cmd.addArguments(args);
        StreamConsumer out = new StreamConsumer(){
            File file;
            int severity;
            int linenum;
            int column;
            StringBuilder message = new StringBuilder();

            public void consumeLine(String line) {
                if (line.startsWith("DONE")) {
                    AbstractXSDToJavaMojo.this.buildContext.addMessage(this.file, this.linenum, this.column, this.message.toString(), this.severity, null);
                } else if (line.startsWith("MSG: ") || line.startsWith("ERROR: ") || line.startsWith("WARNING: ")) {
                    this.file = new File(line.substring(line.indexOf(32)).trim());
                    String type = line.substring(0, line.indexOf(58));
                    this.severity = type.contains("ERROR") ? 2 : (type.contains("WARNING") ? 1 : 0);
                    this.linenum = 0;
                    this.column = 0;
                    this.message.setLength(0);
                } else if (line.startsWith("Col: ")) {
                    this.column = Integer.parseInt(line.substring(line.indexOf(32)).trim());
                } else if (line.startsWith("Line: ")) {
                    this.linenum = Integer.parseInt(line.substring(line.indexOf(32)).trim());
                } else if (line.startsWith("Severity: ")) {
                    this.severity = Integer.parseInt(line.substring(line.indexOf(32)).trim());
                } else {
                    this.message.append(line).append('\n');
                }
            }
        };
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)out);
        }
        catch (CommandLineException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        String cmdLine = CommandLineUtils.toString((String[])cmd.getCommandline());
        if (exitCode != 0) {
            StringBuffer msg = new StringBuffer("\nExit code: ");
            msg.append(exitCode);
            msg.append('\n');
            msg.append("Command line was: ").append(cmdLine).append('\n').append('\n');
            throw new MojoExecutionException(msg.toString());
        }
        file.delete();
        return 0;
    }
}

