/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.ModelLoader;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.api.SpecVersion;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElementRef;
import org.apache.cxf.maven_plugin.XJCBuildContext;
import org.apache.cxf.maven_plugin.XJCErrorListener;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.xml.sax.InputSource;

public class XSDToJavaRunner {
    final String[] args;
    final List<String> cpList;
    final XJCErrorListener listener;
    final File xsdFile;

    public XSDToJavaRunner(String[] args, XJCErrorListener listener, File file, List<String> cp) {
        this.args = args;
        this.listener = listener;
        this.xsdFile = file;
        this.cpList = cp;
    }

    public int run() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String s : this.cpList) {
            urls.add(new File(s).toURI().toURL());
        }
        final URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
        CatalogManager cm = new CatalogManager();
        cm.setUseStaticCatalog(false);
        cm.setIgnoreMissingProperties(true);
        final CatalogResolver catResolver = new CatalogResolver(cm){

            public InputSource resolveEntity(String publicId, String systemId) {
                String resolved = this.getResolvedEntity(publicId, systemId);
                if (resolved == null) {
                    return null;
                }
                InputSource iSource = new InputSource(resolved);
                iSource.setPublicId(publicId);
                try {
                    URL url;
                    if (resolved.startsWith("classpath:")) {
                        resolved = resolved.substring("classpath:".length());
                        url = loader.getResource(resolved);
                        iSource.setSystemId(url.toExternalForm());
                    } else {
                        url = new URL(resolved);
                    }
                    InputStream iStream = url.openStream();
                    iSource.setByteStream(iStream);
                    return iSource;
                }
                catch (Exception e) {
                    XSDToJavaRunner.this.listener.warning(XSDToJavaRunner.this.xsdFile, e);
                    return null;
                }
            }
        };
        Options opt = new Options(){

            public void addCatalog(File catalogFile) throws IOException {
                if (this.entityResolver == null) {
                    this.entityResolver = catResolver;
                }
                catResolver.getCatalog().parseCatalog(catalogFile.getPath());
            }
        };
        if (this.checkXmlElementRef()) {
            opt.target = SpecVersion.V2_1;
        }
        opt.setSchemaLanguage(Language.XMLSCHEMA);
        opt.parseArguments(this.args);
        Model model = ModelLoader.load((Options)opt, (JCodeModel)new JCodeModel(), (ErrorReceiver)this.listener);
        if (model == null) {
            this.listener.message(this.xsdFile, "Failed to create model");
            return -1;
        }
        Outline outline = model.generateCode(opt, (ErrorReceiver)this.listener);
        if (outline == null) {
            this.listener.message(this.xsdFile, "Failed to generate code");
            return -1;
        }
        try {
            CodeWriter cw = opt.createCodeWriter();
            model.codeModel.build(cw);
        }
        catch (IOException e) {
            this.listener.error(e);
            return -1;
        }
        return 0;
    }

    private boolean checkXmlElementRef() {
        try {
            XmlElementRef.class.getMethod("required", new Class[0]);
        }
        catch (Throwable t) {
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        XJCBuildContext context = new XJCBuildContext();
        XJCErrorListener listener = new XJCErrorListener(context);
        File outputFile = new File(args[args.length - 1]);
        int i = new XSDToJavaRunner(args, listener, outputFile, new ArrayList<String>()).run();
        System.exit(i);
    }
}

