/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.istack.SAXParseException2;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.api.SpecVersion;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.reader.internalizer.AbstractReferenceFinderImpl;
import com.sun.tools.xjc.reader.internalizer.DOMForest;
import com.sun.tools.xjc.reader.xmlschema.parser.XMLSchemaInternalizationLogic;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javax.xml.bind.annotation.XmlElementRef;
import org.apache.cxf.maven_plugin.XJCBuildContext;
import org.apache.cxf.maven_plugin.XJCErrorListener;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.XMLFilterImpl;

public class XSDToJavaRunner {
    static Class<?> modelLoaderClass;
    final String[] args;
    final List<String> cpList;
    final XJCErrorListener listener;
    final File xsdFile;

    public XSDToJavaRunner(String[] args, XJCErrorListener listener, File file, List<String> cp) {
        this.args = args;
        this.listener = listener;
        this.xsdFile = file;
        this.cpList = cp;
    }

    private static File getFile(String s, XJCErrorListener l) throws Exception {
        File f = new File(s);
        if (f.exists()) {
            return f;
        }
        try {
            URI uri = new URI(s);
            f = new File(uri);
            return f;
        }
        catch (Throwable t) {
            if (l != null) {
                l.debug("Could not find a file for " + s);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String s : this.cpList) {
            File file = XSDToJavaRunner.getFile(s, this.listener);
            if (file == null) continue;
            urls.add(file.toURI().toURL());
        }
        for (int x = 0; x < this.args.length - 1; ++x) {
            if (!"-classpath".equals(this.args[x])) continue;
            File file = XSDToJavaRunner.getFile(this.args[x + 1], this.listener);
            if (file != null && file.exists()) {
                this.cpList.add(file.getAbsolutePath());
                urls.add(file.getAbsoluteFile().toURI().toURL());
            }
            ++x;
        }
        try (final URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[0]), this.getClass().getClassLoader());){
            CatalogManager cm = new CatalogManager();
            cm.setUseStaticCatalog(false);
            cm.setIgnoreMissingProperties(true);
            final CatalogResolver catResolver = new CatalogResolver(cm){

                public InputSource resolveEntity(String publicId, String systemId) {
                    String resolved = this.getResolvedEntity(publicId, systemId);
                    if (resolved == null) {
                        return null;
                    }
                    InputSource iSource = new InputSource(resolved);
                    iSource.setPublicId(publicId);
                    try {
                        URL url;
                        if (resolved.startsWith("classpath:")) {
                            url = loader.getResource(resolved.substring("classpath:".length()));
                            iSource.setSystemId(url.toExternalForm());
                        } else {
                            url = new URL(resolved);
                        }
                        InputStream iStream = url.openStream();
                        iSource.setByteStream(iStream);
                        return iSource;
                    }
                    catch (Exception e) {
                        XSDToJavaRunner.this.listener.warning(XSDToJavaRunner.this.xsdFile, e);
                        return null;
                    }
                }
            };
            Options opt = new Options(){

                public void addCatalog(File catalogFile) throws IOException {
                    if (this.entityResolver == null) {
                        this.entityResolver = catResolver;
                    }
                    catResolver.getCatalog().parseCatalog(catalogFile.getPath());
                }
            };
            for (URL url : urls) {
                opt.classpaths.add(url);
            }
            if (this.checkXmlElementRef()) {
                opt.target = SpecVersion.V2_1;
            }
            opt.setSchemaLanguage(Language.XMLSCHEMA);
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(opt.getUserClassLoader(origLoader));
                opt.parseArguments(this.args);
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
            Model model = this.loadModel(opt);
            if (model == null) {
                this.listener.message(this.xsdFile, "Failed to create model");
                int n = -1;
                return n;
            }
            Outline outline = model.generateCode(opt, (ErrorReceiver)this.listener);
            if (outline == null) {
                this.listener.message(this.xsdFile, "Failed to generate code");
                int n = -1;
                return n;
            }
            try {
                CodeWriter cw = opt.createCodeWriter();
                model.codeModel.build(cw);
            }
            catch (IOException e) {
                this.listener.error(e);
                int n = -1;
                if (loader != null) {
                    if (var3_5 != null) {
                        try {
                            loader.close();
                        }
                        catch (Throwable throwable) {
                            var3_5.addSuppressed(throwable);
                        }
                    } else {
                        loader.close();
                    }
                }
                return n;
            }
        }
        return 0;
    }

    private synchronized Class<?> getModelLoaderClass() {
        if (modelLoaderClass == null) {
            try {
                ClassPool pool = ClassPool.getDefault();
                CtClass cc = pool.get("com.sun.tools.xjc.ModelLoader");
                cc.setName("com.sun.tools.xjc.ModelLoader");
                for (CtMethod m : cc.getMethods()) {
                    if (!m.getName().equals("buildDOMForest")) continue;
                    m.insertBefore("$1 = new " + CustomizedLogic.class.getName() + "();");
                }
                modelLoaderClass = cc.toClass();
            }
            catch (Throwable t) {
                try {
                    modelLoaderClass = Class.forName("com.sun.tools.xjc.ModelLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return modelLoaderClass;
    }

    private Model loadModel(Options opt) {
        try {
            return (Model)this.getModelLoaderClass().getMethod("load", Options.class, JCodeModel.class, ErrorReceiver.class).invoke(null, new Object[]{opt, new JCodeModel(), this.listener});
        }
        catch (Exception e) {
            this.listener.error("Failed to create model", e);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean checkXmlElementRef() {
        try {
            XmlElementRef.class.getMethod("required", new Class[0]);
        }
        catch (Throwable t) {
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        XJCBuildContext context = new XJCBuildContext();
        XJCErrorListener listener = new XJCErrorListener(context);
        ArrayList<String> cplist = new ArrayList<String>();
        File outputFile = XSDToJavaRunner.getFile(args[args.length - 1], listener);
        if (outputFile == null) {
            outputFile = new File(args[args.length - 1]);
        }
        int i = new XSDToJavaRunner(args, listener, outputFile, cplist).run();
        System.exit(i);
    }

    public static class CustomizedLogic
    extends XMLSchemaInternalizationLogic {
        public XMLFilterImpl createExternalReferenceFinder(DOMForest parent) {
            return new ReferenceFinder(parent);
        }

        private static final class ReferenceFinder
        extends AbstractReferenceFinderImpl {
            private Locator locator;

            ReferenceFinder(DOMForest parent) {
                super(parent);
            }

            public void setDocumentLocator(Locator l) {
                super.setDocumentLocator(l);
                this.locator = l;
            }

            public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                String relativeRef;
                if (this.getContentHandler() != null) {
                    this.getContentHandler().startElement(namespaceURI, localName, qName, atts);
                }
                if ((relativeRef = this.findExternalResource(namespaceURI, localName, atts)) == null) {
                    return;
                }
                try {
                    int bangIdx;
                    String lsi = this.locator.getSystemId();
                    URI relRefURI = new URI(relativeRef);
                    String ref = relRefURI.isAbsolute() ? relativeRef : (lsi.startsWith("jar:") ? ((bangIdx = lsi.indexOf(33)) > 0 ? lsi.substring(0, bangIdx + 1) + new URI(lsi.substring(bangIdx + 1)).resolve(new URI(relativeRef)).toString() : relativeRef) : new URI(lsi).resolve(new URI(relativeRef)).toString());
                    if (this.parent != null) {
                        if (this.parent.get(ref = Options.normalizeSystemId((String)ref)) != null) {
                            return;
                        }
                        InputSource is = null;
                        if (this.parent.getEntityResolver() != null) {
                            is = this.parent.getEntityResolver().resolveEntity(null, ref);
                        }
                        if (is == null) {
                            is = new InputSource(ref);
                        } else {
                            ref = is.getSystemId();
                        }
                        if (this.parent.get(ref) != null) {
                            is.getByteStream().close();
                            return;
                        }
                        this.parent.parse(ref, is, false);
                    }
                }
                catch (URISyntaxException e) {
                    String msg = e.getMessage();
                    if (new File(relativeRef).exists()) {
                        msg = "Filename is not a URI  " + msg;
                    }
                    SAXParseException2 spe = new SAXParseException2("Unable to parse " + relativeRef + ": " + msg, this.locator, (Exception)e);
                    this.fatalError((SAXParseException)spe);
                    throw spe;
                }
                catch (IOException e) {
                    SAXParseException2 spe = new SAXParseException2("Unable to parse " + relativeRef + ": " + e.getMessage(), this.locator, (Exception)e);
                    this.fatalError((SAXParseException)spe);
                    throw spe;
                }
            }

            protected String findExternalResource(String nsURI, String localName, Attributes atts) {
                if ("http://www.w3.org/2001/XMLSchema".equals(nsURI) && ("import".equals(localName) || "include".equals(localName))) {
                    return atts.getValue("schemaLocation");
                }
                return null;
            }
        }
    }
}

