/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.decorator;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.dosgi.dsw.decorator.Rule;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceRule
implements Rule {
    private static final Logger LOG = LogUtils.getL7dLogger(InterfaceRule.class);
    private final Bundle bundle;
    private final Pattern matchPattern;
    private final Map<String, String> propMatches = new HashMap<String, String>();
    private final Map<String, Object> addProps = new HashMap<String, Object>();

    public InterfaceRule(Bundle b, String im) {
        this.bundle = b;
        this.matchPattern = Pattern.compile(im);
    }

    public synchronized void addPropMatch(String name, String value) {
        this.propMatches.put(name, value);
    }

    public synchronized void addProperty(String name, String value, String type) {
        String obj = value;
        if (!String.class.getName().equals(type)) {
            try {
                Class<?> cls = this.getClass().getClassLoader().loadClass(type);
                Constructor<?> ctor = cls.getConstructor(String.class);
                obj = ctor.newInstance(value);
            }
            catch (Throwable th) {
                LOG.log(Level.WARNING, "Could not handle property '" + name + "' with value '" + value + "' of type: " + type, th);
                return;
            }
        }
        this.addProps.put(name, obj);
    }

    @Override
    public synchronized void apply(ServiceReference sref, Map<String, Object> target) {
        String[] objectClass = (String[])sref.getProperty("objectClass");
        boolean matches = false;
        for (String cls : objectClass) {
            Matcher m = this.matchPattern.matcher(cls);
            if (!m.matches()) continue;
            for (Map.Entry<String, String> pm : this.propMatches.entrySet()) {
                Object value = sref.getProperty(pm.getKey());
                if (value == null) {
                    return;
                }
                if (Pattern.matches(pm.getValue(), value.toString())) continue;
                return;
            }
            matches = true;
            break;
        }
        if (!matches) {
            return;
        }
        LOG.info("Adding the following properties to " + sref + ": " + this.addProps);
        target.putAll(this.addProps);
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }
}

