/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.dosgi.dsw.handlers.ConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.apache.cxf.dosgi.dsw.service.ImportRegistrationImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientServiceFactory
implements ServiceFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(ClientServiceFactory.class);
    private BundleContext dswContext;
    private Class<?> iClass;
    private EndpointDescription sd;
    private ConfigurationTypeHandler handler;
    private ImportRegistrationImpl importRegistartion;
    private boolean closeable = false;
    private int serviceCounter = 0;

    public ClientServiceFactory(BundleContext dswContext, Class<?> iClass, EndpointDescription sd, ConfigurationTypeHandler handler, ImportRegistrationImpl ir) {
        this.dswContext = dswContext;
        this.iClass = iClass;
        this.sd = sd;
        this.handler = handler;
        this.importRegistartion = ir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(final Bundle requestingBundle, final ServiceRegistration sreg) {
        String interfaceName = this.sd.getInterfaces() != null && this.sd.getInterfaces().size() > 0 ? (String)this.sd.getInterfaces().toArray()[0] : null;
        LOG.info("************ getService() from serviceFactory for " + interfaceName);
        try {
            Object proxy = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return ClientServiceFactory.this.handler.createProxy(sreg.getReference(), ClientServiceFactory.this.dswContext, requestingBundle.getBundleContext(), ClientServiceFactory.this.iClass, ClientServiceFactory.this.sd);
                }
            });
            ClientServiceFactory clientServiceFactory = this;
            synchronized (clientServiceFactory) {
                ++this.serviceCounter;
            }
            return proxy;
        }
        catch (IntentUnsatifiedException iue) {
            LOG.info("Did not create proxy for " + interfaceName + " because intent " + iue.getIntent() + " could not be satisfied");
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Problem creating a remote proxy for " + interfaceName + " from CXF FindHook: ", ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetService(Bundle requestingBundle, ServiceRegistration sreg, Object serviceObject) {
        StringBuilder sb = new StringBuilder();
        sb.append("Releasing a client object");
        Object objectClass = sreg.getReference().getProperty("objectClass");
        if (objectClass != null) {
            sb.append(", interfaces : ");
            for (String s : (String[])objectClass) {
                sb.append(" " + s);
            }
        }
        LOG.info(sb.toString());
        ClientServiceFactory clientServiceFactory = this;
        synchronized (clientServiceFactory) {
            --this.serviceCounter;
            LOG.fine("Services still provided by this ServiceFactory: " + this.serviceCounter);
            if (this.serviceCounter <= 0 && this.closeable) {
                this.remove();
            }
        }
    }

    private void remove() {
        this.importRegistartion.closeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCloseable(boolean closeable) {
        ClientServiceFactory clientServiceFactory = this;
        synchronized (clientServiceFactory) {
            this.closeable = closeable;
            if (this.serviceCounter <= 0 && closeable) {
                this.remove();
            }
        }
    }

    public boolean isCloseable() {
        return this.closeable;
    }
}

