/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.apache.cxf.dosgi.dsw.handlers.JaxRSUtils;
import org.apache.cxf.dosgi.dsw.handlers.PojoConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.service.ExportRegistrationImpl;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.UserResource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxRSPojoConfigurationTypeHandler
extends PojoConfigurationTypeHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(JaxRSPojoConfigurationTypeHandler.class);
    Set<ServiceReference> httpServiceReferences = new CopyOnWriteArraySet<ServiceReference>();

    protected JaxRSPojoConfigurationTypeHandler(BundleContext dswBC, Map<String, Object> handlerProps) {
        super(dswBC, handlerProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createProxy(ServiceReference serviceReference, BundleContext dswContext, BundleContext callingContext, Class<?> iClass, EndpointDescription sd) throws IntentUnsatifiedException {
        String address = this.getPojoAddress(sd, iClass);
        if (address == null) {
            LOG.warning("Remote address is unavailable");
            return null;
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object proxy;
            JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
            bean.setAddress(address);
            this.addRsInterceptorsFeaturesProps((AbstractEndpointFactory)bean, callingContext, sd.getProperties());
            List<UserResource> resources = JaxRSUtils.getModel(callingContext, iClass);
            if (resources != null) {
                bean.setModelBeansWithServiceClass(resources, new Class[]{iClass});
            } else {
                bean.setServiceClass(iClass);
            }
            List<Object> providers = JaxRSUtils.getProviders(callingContext, dswContext, sd.getProperties());
            if (providers != null && providers.size() > 0) {
                bean.setProviders(providers);
            }
            Thread.currentThread().setContextClassLoader(JAXRSClientFactoryBean.class.getClassLoader());
            Object object = proxy = this.getProxy(bean.create(), iClass);
            return object;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "proxy creation failed", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createServer(ExportRegistrationImpl exportRegistration, BundleContext dswContext, BundleContext callingContext, Map sd, Class<?> iClass, Object serviceBean) throws IntentUnsatifiedException {
        String address = this.getPojoAddress(sd, iClass);
        if (address == null) {
            LOG.warning("Remote address is unavailable");
            exportRegistration.setException(new Throwable("Remote address is unavailable"));
            return;
        }
        LOG.info("Creating a " + iClass.getName() + " endpoint via JaxRSPojoConfigurationTypeHandler, address is " + address);
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean();
        List<UserResource> resources = JaxRSUtils.getModel(callingContext, iClass);
        if (resources != null) {
            factory.setModelBeansWithServiceClass(resources, new Class[]{iClass});
            factory.setServiceBeanObjects(new Object[]{serviceBean});
        } else {
            factory.setServiceClass(iClass);
            factory.setResourceProvider(iClass, (ResourceProvider)new SingletonResourceProvider(serviceBean));
        }
        factory.setAddress(address);
        List<Object> providers = JaxRSUtils.getProviders(callingContext, dswContext, sd);
        if (providers != null && providers.size() > 0) {
            factory.setProviders(providers);
        }
        this.addRsInterceptorsFeaturesProps((AbstractEndpointFactory)factory, callingContext, sd);
        String location = OsgiUtils.getProperty(sd, "org.apache.cxf.rs.wadl.location");
        if (location != null) {
            factory.setDocLocation(location);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String[] intents = new String[]{"HTTP"};
            Map<String, Object> endpointProps = this.createEndpointProps(sd, iClass, new String[]{"org.apache.cxf.rs"}, address, intents);
            EndpointDescription endpdDesc = null;
            Thread.currentThread().setContextClassLoader(JAXRSServerFactoryBean.class.getClassLoader());
            Server server = factory.create();
            exportRegistration.setServer(server);
            endpdDesc = new EndpointDescription(endpointProps);
            exportRegistration.setEndpointdescription(endpdDesc);
        }
        catch (IntentUnsatifiedException iue) {
            exportRegistration.setException(iue);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected String getPojoAddress(EndpointDescription sd, Class<?> iClass) {
        String address = OsgiUtils.getProperty(sd, "org.apache.cxf.rs.address");
        if (address == null && (address = this.getDefaultAddress(iClass)) != null) {
            LOG.info("Using a default address : " + address);
        }
        return address;
    }
}

