/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.HttpServiceConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.apache.cxf.dosgi.dsw.service.ExportRegistrationImpl;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlConfigurationTypeHandler
extends HttpServiceConfigurationTypeHandler {
    private static final String CONFIGURATION_TYPE = "wsdl";
    private static final Logger LOG = LogUtils.getL7dLogger(WsdlConfigurationTypeHandler.class);

    public WsdlConfigurationTypeHandler(BundleContext dswBC, Map<String, Object> handlerProps) {
        super(dswBC, handlerProps);
    }

    @Override
    public String getType() {
        return CONFIGURATION_TYPE;
    }

    @Override
    public Object createProxy(ServiceReference serviceReference, BundleContext dswContext, BundleContext callingContext, Class<?> iClass, EndpointDescription sd) {
        String serviceName;
        String wsdlAddressProp = this.getWsdlAddress(sd, iClass);
        if (wsdlAddressProp == null) {
            LOG.warning("WSDL address is unavailable");
            return null;
        }
        URL wsdlAddress = null;
        try {
            wsdlAddress = new URL(wsdlAddressProp);
        }
        catch (MalformedURLException ex) {
            LOG.warning("WSDL address is malformed");
            return null;
        }
        LOG.info("Creating a " + sd.getInterfaces().toArray()[0] + " client, wsdl address is " + OsgiUtils.getProperty(sd, "osgi.remote.configuration.wsdl"));
        String serviceNs = OsgiUtils.getProperty(sd, "osgi.remote.configuration.wsdl.service.ns");
        if (serviceNs == null) {
            serviceNs = PackageUtils.getNamespace((String)PackageUtils.getPackageName(iClass));
        }
        if ((serviceName = OsgiUtils.getProperty(sd, "osgi.remote.configuration.wsdl.service.name")) == null) {
            serviceName = iClass.getSimpleName();
        }
        QName serviceQname = this.getServiceQName(iClass, sd.getProperties(), "osgi.remote.configuration.wsdl.service.ns", "osgi.remote.configuration.wsdl.service.name");
        QName portQname = this.getPortQName(serviceQname.getNamespaceURI(), sd.getProperties(), "osgi.remote.configuration.wsdl.port.name");
        Service service = this.createWebService(wsdlAddress, serviceQname);
        Object proxy = this.getProxy(portQname == null ? service.getPort(iClass) : service.getPort(portQname, iClass), iClass);
        return proxy;
    }

    Service createWebService(URL wsdlAddress, QName serviceQname) {
        return Service.create((URL)wsdlAddress, (QName)serviceQname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createServer(ExportRegistrationImpl exportRegistration, BundleContext dswContext, BundleContext callingContext, Map sd, Class<?> iClass, Object serviceBean) {
        String location = OsgiUtils.getProperty(sd, "osgi.remote.configuration.wsdl.location");
        if (location == null) {
            LOG.warning("WSDL location is unavailable");
            exportRegistration.setException(new Throwable("WSDL location is unavailable"));
            return;
        }
        URL wsdlURL = dswContext.getBundle().getResource(location);
        if (wsdlURL == null) {
            LOG.warning("WSDL resource is unavailable");
            exportRegistration.setException(new Throwable("WSDL resource is unavailable"));
            return;
        }
        String address = this.getPojoAddress(sd, iClass);
        String contextRoot = null;
        if (address == null) {
            contextRoot = this.getServletContextRoot(sd, iClass);
            if (contextRoot == null) {
                LOG.warning("Remote address is unavailable");
            }
            exportRegistration.setException(new Throwable("Remote address is unavailable"));
            return;
        }
        LOG.info("Creating a " + iClass.getName() + " endpoint from CXF PublishHook, address is " + address);
        Bus bus = null;
        if (contextRoot != null) {
            bus = this.registerServletAndGetBus(contextRoot, dswContext, exportRegistration);
        }
        JAXBDataBinding databinding = new JAXBDataBinding();
        JaxWsServerFactoryBean factory = new JaxWsServerFactoryBean();
        factory.setServiceClass(iClass);
        factory.setAddress(address != null ? address : "/");
        factory.getServiceFactory().setDataBinding((DataBinding)databinding);
        factory.setServiceBean(serviceBean);
        this.addWsInterceptorsFeaturesProps((AbstractEndpointFactory)factory, callingContext, sd);
        this.setWsdlProperties((ServerFactoryBean)factory, dswContext, sd, true);
        if (bus != null) {
            factory.setBus(bus);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String[] intents = this.applyIntents(dswContext, callingContext, factory.getFeatures(), (AbstractEndpointFactory)factory, sd);
            Map<String, Object> endpointProps = this.createEndpointProps(sd, iClass, new String[]{"org.apache.cxf.ws"}, address, intents);
            Thread.currentThread().setContextClassLoader(ServerFactoryBean.class.getClassLoader());
            Server server = factory.create();
            exportRegistration.setServer(server);
            EndpointDescription ed = new EndpointDescription(endpointProps);
            exportRegistration.setEndpointdescription(ed);
        }
        catch (IntentUnsatifiedException iue) {
            exportRegistration.setException(iue);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private String getWsdlAddress(EndpointDescription sd, Class<?> iClass) {
        String address = OsgiUtils.getProperty(sd, "osgi.remote.configuration.wsdl");
        if (address == null && (address = this.getDefaultAddress(iClass)) != null) {
            address = address + "?wsdl";
        }
        return address;
    }
}

