/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.service;

import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.dosgi.dsw.service.EventAdminHelper;
import org.apache.cxf.dosgi.dsw.service.ExportRegistrationImpl;
import org.apache.cxf.dosgi.dsw.service.ImportRegistrationImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.ExportReference;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventProducer {
    private static final Logger LOG = LogUtils.getL7dLogger(EventProducer.class);
    private BundleContext bctx;
    private EventAdminHelper eaHelper;

    public EventProducer(BundleContext bc) {
        this.bctx = bc;
        this.eaHelper = new EventAdminHelper(this.bctx);
    }

    protected void publishNotifcation(List<ExportRegistrationImpl> erl) {
        for (ExportRegistrationImpl exportRegistration : erl) {
            this.publishNotifcation(exportRegistration);
        }
    }

    protected void publishNotifcation(ExportRegistration er) {
        RemoteServiceAdminEvent rsae = null;
        rsae = er.getException() != null ? new RemoteServiceAdminEvent(6, this.bctx.getBundle(), (ExportReference)null, er.getException()) : new RemoteServiceAdminEvent(2, this.bctx.getBundle(), er.getExportReference(), er.getException());
        this.notifyListeners(rsae);
        this.eaHelper.notifyEventAdmin(rsae);
    }

    private void notifyListeners(RemoteServiceAdminEvent rsae) {
        try {
            ServiceReference[] listenerRefs = this.bctx.getServiceReferences(RemoteServiceAdminListener.class.getName(), null);
            if (listenerRefs != null) {
                for (ServiceReference sref : listenerRefs) {
                    RemoteServiceAdminListener rsal = (RemoteServiceAdminListener)this.bctx.getService(sref);
                    LOG.fine("notify RemoteServiceAdminListener " + rsal + " of bundle " + sref.getBundle().getSymbolicName());
                    rsal.remoteAdminEvent(rsae);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    protected void publishNotifcation(ImportRegistration ir) {
        RemoteServiceAdminEvent rsae = null;
        rsae = ir.getException() != null ? new RemoteServiceAdminEvent(5, this.bctx.getBundle(), ir.getImportReference(), ir.getException()) : new RemoteServiceAdminEvent(1, this.bctx.getBundle(), ir.getImportReference(), ir.getException());
        this.notifyListeners(rsae);
        this.eaHelper.notifyEventAdmin(rsae);
    }

    public void notifyRemoval(ExportRegistrationImpl eri) {
        RemoteServiceAdminEvent rsae = null;
        rsae = new RemoteServiceAdminEvent(3, this.bctx.getBundle(), eri.getExportReference(), eri.getException());
        this.notifyListeners(rsae);
        this.eaHelper.notifyEventAdmin(rsae);
    }

    public void notifyRemoval(ImportRegistrationImpl eri) {
        RemoteServiceAdminEvent rsae = null;
        rsae = new RemoteServiceAdminEvent(4, this.bctx.getBundle(), eri.getImportReference(), eri.getException());
        this.notifyListeners(rsae);
        this.eaHelper.notifyEventAdmin(rsae);
    }
}

