/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.service;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.dosgi.dsw.handlers.ClientServiceFactory;
import org.apache.cxf.dosgi.dsw.service.ImportReferenceImpl;
import org.apache.cxf.dosgi.dsw.service.RemoteServiceAdminCore;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.ImportRegistration;

public class ImportRegistrationImpl
implements ImportRegistration {
    private static final Logger LOG = LogUtils.getL7dLogger(ImportRegistrationImpl.class);
    private Throwable exception;
    private ServiceRegistration importedService;
    private EndpointDescription importedEndpoint;
    private ClientServiceFactory clientServiceFactory;
    private RemoteServiceAdminCore rsaCore;
    private boolean closed = false;
    private boolean detatched = false;
    private ImportRegistrationImpl parent = null;
    private List<ImportRegistrationImpl> childs = null;
    private ImportReference importReference;

    public ImportRegistrationImpl(Throwable ex) {
        this.exception = ex;
        this.init();
    }

    public ImportRegistrationImpl(EndpointDescription endpoint, RemoteServiceAdminCore rsac) {
        this.importedEndpoint = endpoint;
        this.rsaCore = rsac;
        this.init();
    }

    private void init() {
        this.parent = this;
        this.childs = new ArrayList<ImportRegistrationImpl>(1);
    }

    public ImportRegistrationImpl(ImportRegistrationImpl ir) {
        this.parent = ir = ir.getParent();
        this.exception = ir.getException();
        this.importedEndpoint = ir.getImportedEndpointDescription();
        this.importedService = ir.getImportedServiceRegistration();
        this.clientServiceFactory = ir.getClientServiceFactory();
        this.rsaCore = ir.getRsaCore();
        this.parent.instanceAdded(this);
    }

    private synchronized void instanceAdded(ImportRegistrationImpl i) {
        this.childs.add(i);
    }

    public synchronized void close() {
        LOG.finest("close() called ");
        if (this.isFailure()) {
            return;
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.rsaCore.removeImportRegistration(this);
        this.parent.instanceClosed(this);
    }

    private synchronized void instanceClosed(ImportRegistrationImpl i) {
        this.childs.remove(i);
        if (this.childs.isEmpty() && !this.detatched && this.closed) {
            this.detatched = true;
            LOG.fine("really closing ImportRegistartion now! ");
            if (this.clientServiceFactory != null) {
                this.clientServiceFactory.setCloseable(true);
            }
            if (this.importedService != null) {
                this.importedService.unregister();
            }
        }
    }

    public synchronized void closeAll() {
        if (this == this.parent) {
            LOG.info("closing down all child ImportRegistrations");
            for (ImportRegistrationImpl ir : new ArrayList<ImportRegistrationImpl>(this.childs)) {
                ir.close();
            }
            if (!this.closed) {
                this.close();
            }
        } else {
            this.parent.closeAll();
        }
    }

    private ServiceRegistration getImportedServiceRegistration() {
        return this.importedService;
    }

    public Throwable getException() {
        return this.exception;
    }

    public EndpointDescription getImportedEndpointDescription() {
        if (this.isFailure()) {
            return null;
        }
        if (this.closed) {
            return null;
        }
        return this.importedEndpoint;
    }

    public ServiceReference getImportedService() {
        if (this.isFailure() || this.closed) {
            return null;
        }
        if (this.importedService == null) {
            return null;
        }
        return this.importedService.getReference();
    }

    public void setException(Throwable ex) {
        this.exception = ex;
    }

    private boolean isFailure() {
        return this.exception != null;
    }

    private void _setImportedServiceRegistration(ServiceRegistration proxyRegistration) {
        this.importedService = proxyRegistration;
    }

    public synchronized void setImportedServiceRegistration(ServiceRegistration proxyRegistration) {
        if (this.parent != this) {
            throw new IllegalStateException("this method may only be called on the parent !");
        }
        this._setImportedServiceRegistration(proxyRegistration);
        for (ImportRegistrationImpl ir : this.childs) {
            ir._setImportedServiceRegistration(proxyRegistration);
        }
    }

    public void setClientServiceFactory(ClientServiceFactory csf) {
        this.clientServiceFactory = csf;
    }

    public RemoteServiceAdminCore getRsaCore() {
        return this.rsaCore;
    }

    public void setRsaCore(RemoteServiceAdminCore rsaCore) {
        this.rsaCore = rsaCore;
    }

    public ClientServiceFactory getClientServiceFactory() {
        return this.clientServiceFactory;
    }

    public void setParent(ImportRegistrationImpl parent) {
        this.parent = parent;
    }

    public ImportRegistrationImpl getParent() {
        return this.parent;
    }

    public ImportReference getImportReference() {
        if (this.importReference == null) {
            this.importReference = new ImportReferenceImpl(this);
        }
        return this.importReference;
    }

    public EndpointDescription getImportedEndpointAlways() {
        return this.importedEndpoint;
    }
}

