/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.service;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.service.RemoteServiceAdminCore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointPermission;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;

public class RemoteServiceAdminInstance
implements RemoteServiceAdmin {
    private static final Logger LOG = LogUtils.getL7dLogger(RemoteServiceAdminInstance.class);
    private BundleContext bctx;
    private RemoteServiceAdminCore rsaCore;
    private boolean closed = false;

    public RemoteServiceAdminInstance(BundleContext bc, RemoteServiceAdminCore core) {
        this.bctx = bc;
        this.rsaCore = core;
    }

    public List exportService(ServiceReference ref, Map properties) throws IllegalArgumentException, UnsupportedOperationException {
        SecurityManager sm = System.getSecurityManager();
        EndpointPermission epp = new EndpointPermission("*", "export");
        if (sm != null) {
            sm.checkPermission((Permission)epp);
        }
        final ServiceReference refFinal = ref;
        final Map propertiesFinal = properties;
        return AccessController.doPrivileged(new PrivilegedAction<List>(){

            @Override
            public List run() {
                if (RemoteServiceAdminInstance.this.closed) {
                    return Collections.EMPTY_LIST;
                }
                return RemoteServiceAdminInstance.this.rsaCore.exportService(refFinal, propertiesFinal);
            }
        });
    }

    public Collection getExportedServices() {
        SecurityManager sm = System.getSecurityManager();
        EndpointPermission epp = new EndpointPermission("*", "read");
        if (sm != null) {
            sm.checkPermission((Permission)epp);
        }
        if (this.closed) {
            return null;
        }
        return this.rsaCore.getExportedServices();
    }

    public Collection getImportedEndpoints() {
        SecurityManager sm = System.getSecurityManager();
        EndpointPermission epp = new EndpointPermission("*", "read");
        if (sm != null) {
            sm.checkPermission((Permission)epp);
        }
        if (this.closed) {
            return null;
        }
        return this.rsaCore.getImportedEndpoints();
    }

    public ImportRegistration importService(EndpointDescription endpoint) {
        final EndpointDescription epd = endpoint;
        SecurityManager sm = System.getSecurityManager();
        EndpointPermission epp = new EndpointPermission(epd, OsgiUtils.getUUID(this.bctx), "import");
        if (sm != null) {
            sm.checkPermission((Permission)epp);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ImportRegistration>(){

            @Override
            public ImportRegistration run() {
                if (RemoteServiceAdminInstance.this.closed) {
                    return null;
                }
                return RemoteServiceAdminInstance.this.rsaCore.importService(epd);
            }
        });
    }

    public void close() {
        this.closed = true;
        this.rsaCore.removeExportRegistrations(this.bctx);
    }
}

