/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.topologymanager;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.dosgi.topologymanager.TopologyManagerImport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.ListenerHook;

public class ListenerHookImpl
implements ListenerHook {
    private static final Logger LOG = Logger.getLogger(ListenerHookImpl.class.getName());
    private BundleContext bctx;
    private ServiceRegistration serviceRegistrations;
    private TopologyManagerImport tm;
    private static final String CLASS_NAME_EXPRESSION = ".*\\(objectClass=([a-zA-Z_0-9.]+)\\).*";
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile(".*\\(objectClass=([a-zA-Z_0-9.]+)\\).*");
    private static final Set<String> SYSTEM_PACKAGES = new HashSet<String>();

    public ListenerHookImpl(BundleContext bc, TopologyManagerImport tm) {
        this.bctx = bc;
        this.tm = tm;
    }

    protected void start() {
        this.serviceRegistrations = this.bctx.registerService(ListenerHook.class.getName(), (Object)this, null);
    }

    protected void stop() {
        this.serviceRegistrations.unregister();
    }

    public void added(Collection listeners) {
        LOG.fine("ListenerHookImpl: added() " + listeners);
        for (Object li : listeners) {
            ListenerHook.ListenerInfo listenerInfo = (ListenerHook.ListenerInfo)li;
            LOG.info("*** Filter: " + listenerInfo.getFilter());
            String className = this.getClassNameFromFilter(listenerInfo.getFilter());
            if (listenerInfo.getBundleContext().getBundle().equals(this.bctx.getBundle())) {
                LOG.info("ListenerHookImpl: skipping request from myself");
                continue;
            }
            if (listenerInfo.getFilter() == null) {
                LOG.info("ListenerHookImpl: skipping empty filter");
                continue;
            }
            if (ListenerHookImpl.isClassExcluded(className)) {
                LOG.info("ListenerHookImpl: skipping import request for excluded classs [" + className + "]");
                continue;
            }
            this.tm.addServiceInterest(listenerInfo.getFilter());
        }
    }

    public void removed(Collection listeners) {
        LOG.info("ListenerHookImpl: removed: " + listeners);
        for (Object li : listeners) {
            ListenerHook.ListenerInfo listenerInfo = (ListenerHook.ListenerInfo)li;
            LOG.info(listenerInfo.getFilter());
            this.tm.removeServiceInterest(listenerInfo.getFilter());
        }
    }

    private String getClassNameFromFilter(String filter) {
        Matcher matcher;
        if (filter != null && (matcher = CLASS_NAME_PATTERN.matcher(filter)).matches() && matcher.groupCount() >= 1) {
            return matcher.group(1);
        }
        return null;
    }

    private static boolean isClassExcluded(String className) {
        if (className == null) {
            return true;
        }
        for (String p : SYSTEM_PACKAGES) {
            if (!className.startsWith(p)) continue;
            LOG.fine("Lookup for " + className + " is ignored");
            return true;
        }
        return false;
    }

    static {
        SYSTEM_PACKAGES.add("org.osgi.service");
        SYSTEM_PACKAGES.add("org.apache.felix");
        SYSTEM_PACKAGES.add("org.ops4j.pax.logging");
        SYSTEM_PACKAGES.add("ch.ethz.iks.slp");
        SYSTEM_PACKAGES.add("org.ungoverned.osgi.service");
        SYSTEM_PACKAGES.add("org.springframework.osgi.context.event.OsgiBundleApplicationContextListener");
        SYSTEM_PACKAGES.add("java.net.ContentHandler");
    }
}

