/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.topologymanager;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.topologymanager.TopologyManager;
import org.apache.cxf.dosgi.topologymanager.TopologyManagerImport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServiceAdminList
extends ArrayList<RemoteServiceAdmin> {
    private BundleContext bctx;
    private ServiceTracker stRemoteServiceAdmin;
    private TopologyManager topManager;
    private TopologyManagerImport topManagerImport;
    private static final Logger LOG = Logger.getLogger(RemoteServiceAdminList.class.getName());

    public RemoteServiceAdminList(BundleContext bc) {
        this.bctx = bc;
        final RemoteServiceAdminList rsal = this;
        this.stRemoteServiceAdmin = new ServiceTracker(this.bctx, RemoteServiceAdmin.class.getName(), null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object addingService(ServiceReference reference) {
                LOG.info("Adding RemoteServiceAdmin to list of admins ");
                RemoteServiceAdmin rsa = (RemoteServiceAdmin)RemoteServiceAdminList.this.bctx.getService(reference);
                RemoteServiceAdminList remoteServiceAdminList = rsal;
                synchronized (remoteServiceAdminList) {
                    rsal.add(rsa);
                }
                LOG.info("enlisted RemoteEventAdmins: " + this.size());
                RemoteServiceAdminList.this.triggerExportImportForRemoteServiceAdmin(rsa);
                return super.addingService(reference);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference reference, Object service) {
                LOG.info("TopologyManager: Removing RemoteServiceAdmin from list of admins ");
                RemoteServiceAdminList remoteServiceAdminList = rsal;
                synchronized (remoteServiceAdminList) {
                    rsal.remove(service);
                }
                RemoteServiceAdminList.this.removeRemoteServiceAdmin((RemoteServiceAdmin)service);
                LOG.info("TopologyManager: enlisted RemoteEventAdmins: " + rsal.size());
                super.removedService(reference, service);
            }
        };
    }

    protected void removeRemoteServiceAdmin(RemoteServiceAdmin service) {
        this.topManager.removeRemoteServiceAdmin(service);
    }

    protected void triggerExportImportForRemoteServiceAdmin(RemoteServiceAdmin rsa) {
        this.topManager.triggerExportImportForRemoteServiceAdmin(rsa);
        this.topManagerImport.triggerExportImportForRemoteServiceAdmin(rsa);
    }

    public void start() {
        this.stRemoteServiceAdmin.open();
    }

    public void stop() {
        this.stRemoteServiceAdmin.close();
    }

    public void setTopologyManager(TopologyManager tm) {
        this.topManager = tm;
    }

    public void setTopologyManagerImport(TopologyManagerImport tmi) {
        this.topManagerImport = tmi;
    }
}

