/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.topologymanager;

import java.util.logging.Logger;
import org.apache.cxf.dosgi.topologymanager.TopologyManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ServiceListenerImpl
implements ServiceListener {
    private Logger LOG = Logger.getLogger(ServiceListenerImpl.class.getName());
    private BundleContext bctx;
    private TopologyManager topManager;

    public ServiceListenerImpl(BundleContext bc, TopologyManager tm) {
        this.bctx = bc;
        this.topManager = tm;
    }

    protected void start() {
        this.bctx.addServiceListener((ServiceListener)this);
    }

    protected void stop() {
        this.bctx.removeServiceListener((ServiceListener)this);
    }

    public void serviceChanged(ServiceEvent event) {
        this.LOG.fine("Received ServiceEvent: " + event);
        ServiceReference sref = event.getServiceReference();
        if (event.getType() == 1) {
            this.LOG.fine("Registered");
            if (this.analyzeService(sref)) {
                this.LOG.info("calling TopologyManager -> registered service");
                this.topManager.exportService(sref);
            }
        } else if (event.getType() == 4) {
            this.topManager.removeService(sref);
        }
    }

    private boolean analyzeService(ServiceReference sref) {
        return sref.getProperty("service.exported.interfaces") != null;
    }
}

