/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring.web;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.metadata.MetadataDocumentHandler;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizProcessorFactory;
import org.apache.cxf.fediz.core.processor.RedirectionResponse;
import org.apache.cxf.fediz.spring.FederationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.Assert;

public class FederationAuthenticationEntryPoint
implements AuthenticationEntryPoint,
InitializingBean,
ApplicationContextAware {
    public static final String SAVED_CONTEXT = "SAVED_CONTEXT";
    private static final Logger LOG = LoggerFactory.getLogger(FederationAuthenticationEntryPoint.class);
    private ApplicationContext appContext;
    private FederationConfig federationConfig;

    public FederationConfig getFederationConfig() {
        return this.federationConfig;
    }

    public void setFederationConfig(FederationConfig federationConfig) {
        this.federationConfig = federationConfig;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.appContext, (String)"ApplicationContext cannot be null.");
        Assert.notNull((Object)this.federationConfig, (String)"FederationConfig cannot be null.");
    }

    public final void commence(HttpServletRequest servletRequest, HttpServletResponse response, AuthenticationException authenticationException) throws IOException, ServletException {
        FedizContext fedContext = this.federationConfig.getFedizContext();
        LOG.debug("Federation context: {}", (Object)fedContext);
        MetadataDocumentHandler mdHandler = new MetadataDocumentHandler(fedContext);
        if (mdHandler.canHandleRequest(servletRequest)) {
            mdHandler.handleRequest(servletRequest, response);
            return;
        }
        String redirectUrl = null;
        try {
            FedizProcessor wfProc = FedizProcessorFactory.newFedizProcessor((Protocol)fedContext.getProtocol());
            RedirectionResponse redirectionResponse = wfProc.createSignInRequest(servletRequest, fedContext);
            redirectUrl = redirectionResponse.getRedirectionURL();
            if (redirectUrl == null) {
                LOG.warn("Failed to create SignInRequest. Redirect URL null");
                throw new ServletException("Failed to create SignInRequest. Redirect URL null");
            }
            Map headers = redirectionResponse.getHeaders();
            if (!headers.isEmpty()) {
                for (Map.Entry entry : headers.entrySet()) {
                    response.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            HttpSession session = servletRequest.getSession(true);
            session.setAttribute(SAVED_CONTEXT, (Object)redirectionResponse.getRequestState().getState());
        }
        catch (ProcessingException ex) {
            LOG.warn("Failed to create SignInRequest", (Throwable)ex);
            throw new ServletException("Failed to create SignInRequest: " + ex.getMessage());
        }
        this.preCommence(servletRequest, response);
        if (LOG.isInfoEnabled()) {
            LOG.info("Redirecting to IDP: " + redirectUrl);
        }
        response.sendRedirect(redirectUrl);
    }

    protected void preCommence(HttpServletRequest request, HttpServletResponse response) {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }
}

