/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring.web;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizProcessorFactory;
import org.apache.cxf.fediz.core.processor.RedirectionResponse;
import org.apache.cxf.fediz.spring.FederationConfig;
import org.apache.cxf.fediz.spring.authentication.ExpiredTokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

public class FederationAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FederationAuthenticationFailureHandler.class);
    private FederationConfig federationConfig;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (exception instanceof ExpiredTokenException) {
            String redirectUrl = null;
            try {
                FedizContext fedContext = this.federationConfig.getFedizContext();
                FedizProcessor wfProc = FedizProcessorFactory.newFedizProcessor((Protocol)fedContext.getProtocol());
                RedirectionResponse redirectionResponse = wfProc.createSignInRequest(request, fedContext);
                redirectUrl = redirectionResponse.getRedirectionURL();
                if (redirectUrl == null) {
                    LOG.warn("Failed to create SignInRequest. Redirect URL null");
                    throw new ServletException("Failed to create SignInRequest. Redirect URL null");
                }
                Map headers = redirectionResponse.getHeaders();
                if (!headers.isEmpty()) {
                    for (Map.Entry entry : headers.entrySet()) {
                        response.addHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
            catch (ProcessingException ex) {
                LOG.warn("Failed to create SignInRequest", (Throwable)ex);
                throw new ServletException("Failed to create SignInRequest: " + ex.getMessage());
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Redirecting to IDP: " + redirectUrl);
            }
            response.sendRedirect(redirectUrl);
        }
        super.onAuthenticationFailure(request, response, exception);
    }

    public FederationConfig getFederationConfig() {
        return this.federationConfig;
    }

    public void setFederationConfig(FederationConfig fedConfig) {
        this.federationConfig = fedConfig;
    }
}

