/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring.web;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.cxf.fediz.core.processor.FedizRequest;
import org.apache.cxf.fediz.spring.FederationConfig;
import org.apache.cxf.fediz.spring.authentication.ExpiredTokenException;
import org.apache.cxf.fediz.spring.authentication.FederationAuthenticationToken;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

public class FederationAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private FederationConfig federationConfig;

    public FederationAuthenticationFilter() {
        super("/j_spring_fediz_security_check");
        this.setAuthenticationFailureHandler((AuthenticationFailureHandler)new SimpleUrlAuthenticationFailureHandler());
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        if (this.isTokenExpired()) {
            throw new ExpiredTokenException("Token is expired");
        }
        this.verifySavedState(request);
        String wa = request.getParameter("wa");
        String responseToken = this.getResponseToken((ServletRequest)request);
        FedizRequest wfReq = new FedizRequest();
        wfReq.setAction(wa);
        wfReq.setResponseToken(responseToken);
        wfReq.setState(this.getState((ServletRequest)request));
        wfReq.setRequest(request);
        Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        wfReq.setCerts(certs);
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken(null, (Object)wfReq);
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    private boolean isTokenExpired() {
        Authentication authentication;
        boolean detectExpiredTokens;
        SecurityContext context = SecurityContextHolder.getContext();
        boolean bl = detectExpiredTokens = this.federationConfig != null && this.federationConfig.getFedizContext().isDetectExpiredTokens();
        if (context != null && detectExpiredTokens && (authentication = context.getAuthentication()) instanceof FederationAuthenticationToken) {
            Date tokenExpires = ((FederationAuthenticationToken)authentication).getResponse().getTokenExpires();
            if (tokenExpires == null) {
                return false;
            }
            Date currentTime = new Date();
            if (currentTime.after(tokenExpires)) {
                return true;
            }
        }
        return false;
    }

    private String getResponseToken(ServletRequest request) {
        if (request.getParameter("wresult") != null) {
            return request.getParameter("wresult");
        }
        if (request.getParameter("SAMLResponse") != null) {
            return request.getParameter("SAMLResponse");
        }
        return null;
    }

    private String getState(ServletRequest request) {
        if (request.getParameter("wctx") != null) {
            return request.getParameter("wctx");
        }
        if (request.getParameter("RelayState") != null) {
            return request.getParameter("RelayState");
        }
        return null;
    }

    private void verifySavedState(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            this.logger.warn((Object)"The received state does not match the state saved in the context");
            throw new BadCredentialsException("The received state does not match the state saved in the context");
        }
        String savedContext = (String)session.getAttribute("SAVED_CONTEXT");
        String state = this.getState((ServletRequest)request);
        if (savedContext == null || !savedContext.equals(state)) {
            this.logger.warn((Object)"The received state does not match the state saved in the context");
            throw new BadCredentialsException("The received state does not match the state saved in the context");
        }
        session.removeAttribute("SAVED_CONTEXT");
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean result;
        boolean bl = result = this.isTokenExpired() || super.requiresAuthentication(request, response);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("requiresAuthentication = " + result));
        }
        return result;
    }

    public FederationConfig getFederationConfig() {
        return this.federationConfig;
    }

    public void setFederationConfig(FederationConfig fedConfig) {
        this.federationConfig = fedConfig;
    }
}

