/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.cache;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.xkms.cache.EHCacheUtil;
import org.apache.cxf.xkms.cache.XKMSCacheToken;
import org.apache.cxf.xkms.cache.XKMSClientCache;

public class EHCacheXKMSClientCache
implements XKMSClientCache,
BusLifeCycleListener {
    public static final String CACHE_KEY = "cxf.xkms.client.cache";
    private static final String DEFAULT_CONFIG_URL = "cxf-xkms-client-ehcache.xml";
    private Ehcache cache;
    private CacheManager cacheManager;
    private Bus bus;

    public EHCacheXKMSClientCache() {
        this(DEFAULT_CONFIG_URL, null);
    }

    public EHCacheXKMSClientCache(Bus cxfBus) {
        this(DEFAULT_CONFIG_URL, cxfBus);
    }

    public EHCacheXKMSClientCache(String configFileURL) {
        this(configFileURL, null);
    }

    public EHCacheXKMSClientCache(String configFileURL, Bus cxfBus) {
        this.createCache(configFileURL, cxfBus);
        this.bus = cxfBus;
        if (this.bus != null) {
            ((BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this);
        }
    }

    private void createCache(String configFile, Bus cxfBus) {
        if (cxfBus == null) {
            cxfBus = BusFactory.getThreadDefaultBus((boolean)true);
        }
        URL configFileURL = null;
        try {
            configFileURL = ClassLoaderUtils.getResource((String)configFile, EHCacheXKMSClientCache.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (configFileURL == null) {
            this.cacheManager = EHCacheUtil.createCacheManager();
        } else {
            Configuration conf = ConfigurationFactory.parseConfiguration((URL)configFileURL);
            if (cxfBus != null) {
                conf.setName(cxfBus.getId());
                DiskStoreConfiguration dsc = conf.getDiskStoreConfiguration();
                if (dsc != null && "java.io.tmpdir".equals(dsc.getOriginalPath())) {
                    String path = conf.getDiskStoreConfiguration().getPath() + File.separator + cxfBus.getId();
                    conf.getDiskStoreConfiguration().setPath(path);
                }
            }
            this.cacheManager = EHCacheUtil.createCacheManager(conf);
        }
        CacheConfiguration cc = EHCacheUtil.getCacheConfiguration(CACHE_KEY, this.cacheManager);
        Cache newCache = new Cache(cc);
        this.cache = this.cacheManager.addCacheIfAbsent((Ehcache)newCache);
    }

    @Override
    public void put(String key, XKMSCacheToken cacheToken) {
        this.cache.put(new Element((Serializable)((Object)key), (Serializable)cacheToken));
    }

    @Override
    public XKMSCacheToken get(String key) {
        Element element = this.cache.get((Serializable)((Object)key));
        if (element != null && !element.isExpired()) {
            return (XKMSCacheToken)element.getObjectValue();
        }
        return null;
    }

    @Override
    public void close() {
        if (this.cacheManager != null) {
            if (this.cache != null) {
                this.cache.removeAll();
            }
            this.cacheManager.shutdown();
            this.cacheManager = null;
            this.cache = null;
            if (this.bus != null) {
                ((BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)).unregisterLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }

    public void initComplete() {
    }

    public void preShutdown() {
        this.close();
    }

    public void postShutdown() {
        this.close();
    }
}

