/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.cache;

import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.xkms.cache.XKMSCacheToken;
import org.apache.cxf.xkms.cache.XKMSClientCache;
import org.apache.cxf.xkms.cache.XKMSClientCacheException;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.CachePersistenceException;
import org.ehcache.PersistentCacheManager;
import org.ehcache.Status;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.expiry.ExpiryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EHCacheXKMSClientCache
implements XKMSClientCache,
BusLifeCycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(EHCacheXKMSClientCache.class);
    private final Cache<String, XKMSCacheToken> cache;
    private final CacheManager cacheManager;
    private final Bus bus;
    private final String cacheKey;
    private final Path diskstorePath;
    private final boolean persistent;

    public EHCacheXKMSClientCache() throws XKMSClientCacheException {
        this(null);
    }

    public EHCacheXKMSClientCache(Bus cxfBus) throws XKMSClientCacheException {
        this(cxfBus, null, 10L, 5000L, false);
    }

    public EHCacheXKMSClientCache(Bus cxfBus, Path diskstorePath, long diskSize, long heapEntries, boolean persistent) throws XKMSClientCacheException {
        if (persistent && diskstorePath == null) {
            throw new NullPointerException();
        }
        if (diskstorePath != null && (diskSize < 5L || diskSize > 10000L)) {
            throw new IllegalArgumentException("The diskSize parameter must be between 5 and 10000 (megabytes)");
        }
        if (heapEntries < 100L) {
            throw new IllegalArgumentException("The heapEntries parameter must be greater than 100 (entries)");
        }
        if (cxfBus == null) {
            cxfBus = BusFactory.getThreadDefaultBus((boolean)true);
        }
        if (cxfBus != null) {
            ((BusLifeCycleManager)cxfBus.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this);
        }
        this.bus = cxfBus;
        this.diskstorePath = diskstorePath;
        this.persistent = persistent;
        this.cacheKey = UUID.randomUUID().toString();
        ResourcePoolsBuilder resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder().heap(heapEntries, (ResourceUnit)EntryUnit.ENTRIES);
        if (diskstorePath != null) {
            resourcePoolsBuilder = resourcePoolsBuilder.disk(diskSize, MemoryUnit.MB, persistent);
        }
        ExpiryPolicy expiryPolicy = ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.of(3600L, ChronoUnit.SECONDS));
        CacheConfigurationBuilder configurationBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, XKMSCacheToken.class, (Builder)resourcePoolsBuilder).withExpiry(expiryPolicy);
        this.cacheManager = diskstorePath != null ? CacheManagerBuilder.newCacheManagerBuilder().with(CacheManagerBuilder.persistence((File)diskstorePath.toFile())).withCache(this.cacheKey, (Builder)configurationBuilder).build() : CacheManagerBuilder.newCacheManagerBuilder().withCache(this.cacheKey, (Builder)configurationBuilder).build();
        this.cacheManager.init();
        this.cache = this.cacheManager.getCache(this.cacheKey, String.class, XKMSCacheToken.class);
    }

    @Override
    public void put(String key, XKMSCacheToken cacheToken) {
        this.cache.put((Object)key, (Object)cacheToken);
    }

    @Override
    public XKMSCacheToken get(String key) {
        return (XKMSCacheToken)this.cache.get((Object)key);
    }

    @Override
    public synchronized void close() {
        if (this.cacheManager.getStatus() == Status.AVAILABLE) {
            this.cacheManager.removeCache(this.cacheKey);
            this.cacheManager.close();
            if (!this.persistent && this.cacheManager instanceof PersistentCacheManager) {
                File file;
                try {
                    ((PersistentCacheManager)this.cacheManager).destroy();
                }
                catch (CachePersistenceException e) {
                    LOG.debug("Error in shutting down persistent cache", (Throwable)e);
                }
                if (this.diskstorePath != null && (file = this.diskstorePath.toFile()).exists() && file.canWrite()) {
                    file.delete();
                }
            }
            if (this.bus != null) {
                ((BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)).unregisterLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }

    public void initComplete() {
    }

    public void preShutdown() {
        this.close();
    }

    public void postShutdown() {
        this.close();
    }
}

