/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.cache.jcache;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Factory;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.spi.CachingProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.ws.security.utils.JCacheUtils;
import org.apache.cxf.xkms.cache.XKMSCacheToken;
import org.apache.cxf.xkms.cache.XKMSClientCache;
import org.apache.cxf.xkms.cache.XKMSClientCacheException;

public class JCacheXKMSClientCache
implements XKMSClientCache,
BusLifeCycleListener {
    private final Cache<String, XKMSCacheToken> cache;
    private final CacheManager cacheManager;
    private final Bus bus;
    private final String cacheKey;

    public JCacheXKMSClientCache() throws XKMSClientCacheException {
        this(null);
    }

    public JCacheXKMSClientCache(Bus cxfBus) throws XKMSClientCacheException {
        if (cxfBus == null) {
            cxfBus = BusFactory.getThreadDefaultBus((boolean)true);
        }
        if (cxfBus != null) {
            ((BusLifeCycleManager)cxfBus.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this);
        }
        this.bus = cxfBus;
        this.cacheKey = UUID.randomUUID().toString();
        CachingProvider cachingProvider = Caching.getCachingProvider();
        this.cacheManager = cachingProvider.getCacheManager();
        this.cache = JCacheUtils.getOrCreate((CacheManager)this.cacheManager, (String)this.cacheKey, String.class, XKMSCacheToken.class, cacheConfiguration -> cacheConfiguration.setExpiryPolicyFactory((Factory & Serializable)() -> new ExpiryPolicy(){

            public Duration getExpiryForCreation() {
                return new Duration(TimeUnit.SECONDS, 3600L);
            }

            public Duration getExpiryForAccess() {
                return null;
            }

            public Duration getExpiryForUpdate() {
                return new Duration(TimeUnit.SECONDS, 3600L);
            }
        }).setStoreByValue(false));
    }

    @Override
    public void put(String key, XKMSCacheToken cacheToken) {
        this.cache.put((Object)key, (Object)cacheToken);
    }

    @Override
    public XKMSCacheToken get(String key) {
        return (XKMSCacheToken)this.cache.get((Object)key);
    }

    @Override
    public synchronized void close() {
        if (!this.cacheManager.isClosed()) {
            this.cacheManager.destroyCache(this.cacheKey);
            this.cacheManager.close();
            if (this.bus != null) {
                ((BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)).unregisterLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }

    public void initComplete() {
    }

    public void preShutdown() {
        this.close();
    }

    public void postShutdown() {
        this.close();
    }
}

