
package org.apache.cxf.xkms.model.xkms;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.cxf.xkms.model.xmldsig.SignatureValueType;


/**
 * <p>Java class for ResultType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ResultType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{http://www.w3.org/2002/03/xkms#}MessageAbstractType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.w3.org/2002/03/xkms#}RequestSignatureValue" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="ResultMajor" use="required" type="{http://www.w3.org/2002/03/xkms#}ResultMajorOpenEnum" /&gt;
 *       &lt;attribute name="ResultMinor" type="{http://www.w3.org/2002/03/xkms#}ResultMinorOpenEnum" /&gt;
 *       &lt;attribute name="RequestId" type="{http://www.w3.org/2001/XMLSchema}NCName" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ResultType", propOrder = {
    "requestSignatureValue"
})
@XmlSeeAlso({
    CompoundResultType.class,
    StatusResultType.class,
    LocateResultType.class,
    ValidateResultType.class,
    RegisterResultType.class,
    ReissueResultType.class,
    RevokeResultType.class,
    RecoverResultType.class
})
public class ResultType
    extends MessageAbstractType
{

    @XmlElement(name = "RequestSignatureValue")
    protected SignatureValueType requestSignatureValue;
    @XmlAttribute(name = "ResultMajor", required = true)
    protected String resultMajor;
    @XmlAttribute(name = "ResultMinor")
    protected String resultMinor;
    @XmlAttribute(name = "RequestId")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "NCName")
    protected String requestId;

    /**
     * Gets the value of the requestSignatureValue property.
     * 
     * @return
     *     possible object is
     *     {@link SignatureValueType }
     *     
     */
    public SignatureValueType getRequestSignatureValue() {
        return requestSignatureValue;
    }

    /**
     * Sets the value of the requestSignatureValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureValueType }
     *     
     */
    public void setRequestSignatureValue(SignatureValueType value) {
        this.requestSignatureValue = value;
    }

    /**
     * Gets the value of the resultMajor property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getResultMajor() {
        return resultMajor;
    }

    /**
     * Sets the value of the resultMajor property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setResultMajor(String value) {
        this.resultMajor = value;
    }

    /**
     * Gets the value of the resultMinor property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getResultMinor() {
        return resultMinor;
    }

    /**
     * Sets the value of the resultMinor property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setResultMinor(String value) {
        this.resultMinor = value;
    }

    /**
     * Gets the value of the requestId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRequestId() {
        return requestId;
    }

    /**
     * Sets the value of the requestId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRequestId(String value) {
        this.requestId = value;
    }

}
