
package org.apache.cxf.xkms.model.xkms;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * 
 * <p>Java class for KeyBindingEnum</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="KeyBindingEnum">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}anyURI">
 *     <enumeration value="http://www.w3.org/2002/03/xkms#Valid"/>
 *     <enumeration value="http://www.w3.org/2002/03/xkms#Invalid"/>
 *     <enumeration value="http://www.w3.org/2002/03/xkms#Indeterminate"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "KeyBindingEnum")
@XmlEnum
public enum KeyBindingEnum {

    @XmlEnumValue("http://www.w3.org/2002/03/xkms#Valid")
    HTTP_WWW_W_3_ORG_2002_03_XKMS_VALID("http://www.w3.org/2002/03/xkms#Valid"),
    @XmlEnumValue("http://www.w3.org/2002/03/xkms#Invalid")
    HTTP_WWW_W_3_ORG_2002_03_XKMS_INVALID("http://www.w3.org/2002/03/xkms#Invalid"),
    @XmlEnumValue("http://www.w3.org/2002/03/xkms#Indeterminate")
    HTTP_WWW_W_3_ORG_2002_03_XKMS_INDETERMINATE("http://www.w3.org/2002/03/xkms#Indeterminate");
    private final String value;

    KeyBindingEnum(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static KeyBindingEnum fromValue(String v) {
        for (KeyBindingEnum c: KeyBindingEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
