
package org.apache.cxf.xkms.model.xkms;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.cxf.xkms.model.xmldsig.SignatureType;


/**
 * <p>Java class for MessageAbstractType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="MessageAbstractType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{http://www.w3.org/2000/09/xmldsig#}Signature" minOccurs="0"/>
 *         <element ref="{http://www.w3.org/2002/03/xkms#}MessageExtension" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{http://www.w3.org/2002/03/xkms#}OpaqueClientData" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="Id" use="required" type="{http://www.w3.org/2001/XMLSchema}ID" />
 *       <attribute name="Service" use="required" type="{http://www.w3.org/2001/XMLSchema}anyURI" />
 *       <attribute name="Nonce" type="{http://www.w3.org/2001/XMLSchema}base64Binary" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MessageAbstractType", propOrder = {
    "signature",
    "messageExtension",
    "opaqueClientData"
})
@XmlSeeAlso({
    ResultType.class,
    RequestAbstractType.class
})
public abstract class MessageAbstractType {

    @XmlElement(name = "Signature", namespace = "http://www.w3.org/2000/09/xmldsig#")
    protected SignatureType signature;
    @XmlElement(name = "MessageExtension")
    protected List<MessageExtensionAbstractType> messageExtension;
    @XmlElement(name = "OpaqueClientData")
    protected OpaqueClientDataType opaqueClientData;
    @XmlAttribute(name = "Id", required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    protected String id;
    @XmlAttribute(name = "Service", required = true)
    @XmlSchemaType(name = "anyURI")
    protected String service;
    @XmlAttribute(name = "Nonce")
    protected byte[] nonce;

    /**
     * Gets the value of the signature property.
     * 
     * @return
     *     possible object is
     *     {@link SignatureType }
     *     
     */
    public SignatureType getSignature() {
        return signature;
    }

    /**
     * Sets the value of the signature property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureType }
     *     
     */
    public void setSignature(SignatureType value) {
        this.signature = value;
    }

    /**
     * Gets the value of the messageExtension property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the messageExtension property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getMessageExtension().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link MessageExtensionAbstractType }
     * </p>
     * 
     * 
     * @return
     *     The value of the messageExtension property.
     */
    public List<MessageExtensionAbstractType> getMessageExtension() {
        if (messageExtension == null) {
            messageExtension = new ArrayList<>();
        }
        return this.messageExtension;
    }

    /**
     * Gets the value of the opaqueClientData property.
     * 
     * @return
     *     possible object is
     *     {@link OpaqueClientDataType }
     *     
     */
    public OpaqueClientDataType getOpaqueClientData() {
        return opaqueClientData;
    }

    /**
     * Sets the value of the opaqueClientData property.
     * 
     * @param value
     *     allowed object is
     *     {@link OpaqueClientDataType }
     *     
     */
    public void setOpaqueClientData(OpaqueClientDataType value) {
        this.opaqueClientData = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the service property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getService() {
        return service;
    }

    /**
     * Sets the value of the service property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setService(String value) {
        this.service = value;
    }

    /**
     * Gets the value of the nonce property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    public byte[] getNonce() {
        return nonce;
    }

    /**
     * Sets the value of the nonce property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setNonce(byte[] value) {
        this.nonce = value;
    }

}
