
package org.apache.cxf.xkms.model.xkms;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * 
 * <p>Java class for RespondWithEnum</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="RespondWithEnum">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}anyURI">
 *     <enumeration value="http://www.w3.org/2002/03/xkms#KeyName"/>
 *     <enumeration value="http://www.w3.org/2002/03/xkms#KeyValue"/>
 *     <enumeration value="http://www.w3.org/2002/03/xkms#X509Cert"/>
 *     <enumeration value="http://www.w3.org/2002/03/xkms#X509Chain"/>
 *     <enumeration value="http://www.w3.org/2002/03/xkms#X509CRL"/>
 *     <enumeration value="http://www.w3.org/2002/03/xkms#RetrievalMethod"/>
 *     <enumeration value="http://www.w3.org/2002/03/xkms#PGP"/>
 *     <enumeration value="http://www.w3.org/2002/03/xkms#PGPWeb"/>
 *     <enumeration value="http://www.w3.org/2002/03/xkms#SPKI"/>
 *     <enumeration value="http://www.w3.org/2002/03/xkms#PrivateKey"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "RespondWithEnum")
@XmlEnum
public enum RespondWithEnum {

    @XmlEnumValue("http://www.w3.org/2002/03/xkms#KeyName")
    HTTP_WWW_W_3_ORG_2002_03_XKMS_KEY_NAME("http://www.w3.org/2002/03/xkms#KeyName"),
    @XmlEnumValue("http://www.w3.org/2002/03/xkms#KeyValue")
    HTTP_WWW_W_3_ORG_2002_03_XKMS_KEY_VALUE("http://www.w3.org/2002/03/xkms#KeyValue"),
    @XmlEnumValue("http://www.w3.org/2002/03/xkms#X509Cert")
    HTTP_WWW_W_3_ORG_2002_03_XKMS_X_509_CERT("http://www.w3.org/2002/03/xkms#X509Cert"),
    @XmlEnumValue("http://www.w3.org/2002/03/xkms#X509Chain")
    HTTP_WWW_W_3_ORG_2002_03_XKMS_X_509_CHAIN("http://www.w3.org/2002/03/xkms#X509Chain"),
    @XmlEnumValue("http://www.w3.org/2002/03/xkms#X509CRL")
    HTTP_WWW_W_3_ORG_2002_03_XKMS_X_509_CRL("http://www.w3.org/2002/03/xkms#X509CRL"),
    @XmlEnumValue("http://www.w3.org/2002/03/xkms#RetrievalMethod")
    HTTP_WWW_W_3_ORG_2002_03_XKMS_RETRIEVAL_METHOD("http://www.w3.org/2002/03/xkms#RetrievalMethod"),
    @XmlEnumValue("http://www.w3.org/2002/03/xkms#PGP")
    HTTP_WWW_W_3_ORG_2002_03_XKMS_PGP("http://www.w3.org/2002/03/xkms#PGP"),
    @XmlEnumValue("http://www.w3.org/2002/03/xkms#PGPWeb")
    HTTP_WWW_W_3_ORG_2002_03_XKMS_PGP_WEB("http://www.w3.org/2002/03/xkms#PGPWeb"),
    @XmlEnumValue("http://www.w3.org/2002/03/xkms#SPKI")
    HTTP_WWW_W_3_ORG_2002_03_XKMS_SPKI("http://www.w3.org/2002/03/xkms#SPKI"),
    @XmlEnumValue("http://www.w3.org/2002/03/xkms#PrivateKey")
    HTTP_WWW_W_3_ORG_2002_03_XKMS_PRIVATE_KEY("http://www.w3.org/2002/03/xkms#PrivateKey");
    private final String value;

    RespondWithEnum(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static RespondWithEnum fromValue(String v) {
        for (RespondWithEnum c: RespondWithEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
