/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.x509.repo;

import org.apache.cxf.xkms.x509.repo.CertificateRepo;
import org.apache.cxf.xkms.x509.repo.file.FileCertificateRepo;
import org.apache.cxf.xkms.x509.repo.ldap.LdapCertificateRepo;
import org.apache.cxf.xkms.x509.repo.ldap.LdapSchemaConfig;
import org.apache.cxf.xkms.x509.repo.ldap.LdapSearch;

public final class CertificateRepoFactory {
    private CertificateRepoFactory() {
    }

    public static CertificateRepo createRepository(String type, LdapSearch ldapSearch, LdapSchemaConfig ldapSchemaConfig, String rootDN, String storageDir) {
        if ("ldap".equals(type)) {
            return new LdapCertificateRepo(ldapSearch, ldapSchemaConfig, rootDN);
        }
        if ("file".equals(type)) {
            return new FileCertificateRepo(storageDir);
        }
        throw new RuntimeException("Invalid repo type " + type + ". Valid types are file, ldap");
    }
}

