/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.x509.repo.ldap;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.xkms.exception.XKMSException;
import org.apache.cxf.xkms.model.xkms.ResultMajorEnum;
import org.apache.cxf.xkms.model.xkms.ResultMinorEnum;

public class LdapSearch {
    private static final String SECURITY_AUTHENTICATION = "simple";
    private static final Logger LOG = LogUtils.getL7dLogger(LdapSearch.class);
    private String ldapuri;
    private String bindDN;
    private String bindPassword;
    private int numRetries;
    private InitialDirContext dirContext;

    public LdapSearch(String ldapuri, String bindDN, String bindPassword, int numRetries) {
        this.ldapuri = ldapuri;
        this.bindDN = bindDN;
        this.bindPassword = bindPassword;
        this.numRetries = numRetries;
    }

    private InitialDirContext createInitialContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>(5);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapuri.toString());
        env.put("java.naming.security.authentication", SECURITY_AUTHENTICATION);
        env.put("java.naming.security.principal", this.bindDN);
        env.put("java.naming.security.credentials", this.bindPassword);
        return new InitialLdapContext(env, null);
    }

    public NamingEnumeration<SearchResult> searchSubTree(String rootEntry, String filter) throws NamingException {
        int retry = 0;
        while (true) {
            try {
                if (this.dirContext == null) {
                    this.dirContext = this.createInitialContext();
                }
                SearchControls ctls = new SearchControls();
                ctls.setSearchScope(2);
                return this.dirContext.search(rootEntry, filter, ctls);
            }
            catch (CommunicationException e) {
                LOG.log(Level.WARNING, "Error in ldap search: " + e.getMessage(), e);
                this.dirContext = null;
                if (++retry < this.numRetries) continue;
                throw new XKMSException(ResultMajorEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_RECEIVER, ResultMinorEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_FAILURE, "Backend failure");
            }
            break;
        }
    }

    public Attributes getAttributes(String dn) throws NamingException {
        int retry = 0;
        while (true) {
            try {
                if (this.dirContext == null) {
                    this.dirContext = this.createInitialContext();
                }
                return this.dirContext.getAttributes(dn);
            }
            catch (CommunicationException e) {
                LOG.log(Level.WARNING, "Error in ldap search: " + e.getMessage(), e);
                this.dirContext = null;
                if (++retry < this.numRetries) continue;
                throw new XKMSException(ResultMajorEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_RECEIVER, ResultMinorEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_FAILURE, "Backend failure");
            }
            break;
        }
    }

    public Attribute getAttribute(String dn, String attrName) throws NamingException {
        Attribute attr = this.getAttributes(dn).get(attrName);
        if (attr != null) {
            return attr;
        }
        throw new RuntimeException("Did not find a matching attribute for dn: " + dn + " attributeName: " + attrName);
    }

    public Attributes findAttributes(String rootDN, String filter) throws NamingException {
        NamingEnumeration<SearchResult> answer = this.searchSubTree(rootDN, filter);
        if (answer.hasMore()) {
            SearchResult sr = answer.next();
            return sr.getAttributes();
        }
        return null;
    }

    public Attribute findAttribute(String rootDN, String filter, String attrName) throws NamingException {
        Attributes attrs = this.findAttributes(rootDN, filter);
        if (attrs != null) {
            Attribute attr = attrs.get(attrName);
            if (attr == null) {
                throw new RuntimeException("Did not find a matching attribute for root: " + rootDN + " filter: " + filter + " attributeName: " + attrName);
            }
            return attr;
        }
        return null;
    }

    public void bind(String dn, Attributes attribs) throws NamingException {
        int retry = 0;
        while (true) {
            try {
                if (this.dirContext == null) {
                    this.dirContext = this.createInitialContext();
                }
                this.dirContext.bind(dn, null, attribs);
                return;
            }
            catch (CommunicationException e) {
                LOG.log(Level.WARNING, "Error in ldap search: " + e.getMessage(), e);
                this.dirContext = null;
                if (++retry < this.numRetries) continue;
                throw new XKMSException(ResultMajorEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_RECEIVER, ResultMinorEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_FAILURE, "Backend failure");
            }
            break;
        }
    }
}

