/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.x509.repo.ldap;

import java.io.ByteArrayInputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.xkms.handlers.Applications;
import org.apache.cxf.xkms.model.xkms.UseKeyWithType;
import org.apache.cxf.xkms.x509.repo.CertificateRepo;
import org.apache.cxf.xkms.x509.repo.ldap.LdapSchemaConfig;
import org.apache.cxf.xkms.x509.repo.ldap.LdapSearch;

public class LdapCertificateRepo
implements CertificateRepo {
    private static final Logger LOG = LogUtils.getL7dLogger(LdapCertificateRepo.class);
    private static final String ATTR_OBJECT_CLASS = "objectClass";
    private LdapSearch ldapSearch;
    private String rootDN;
    private CertificateFactory certificateFactory;
    private final LdapSchemaConfig ldapConfig;
    private final String filterUIDTemplate;
    private final String filterIssuerSerialTemplate;

    public LdapCertificateRepo(LdapSearch ldapSearch, LdapSchemaConfig ldapConfig, String rootDN) {
        this.ldapSearch = ldapSearch;
        this.ldapSearch = ldapSearch;
        this.ldapConfig = ldapConfig;
        this.rootDN = rootDN;
        try {
            this.certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        this.filterUIDTemplate = "(" + ldapConfig.getAttrUID() + "=%s)";
        this.filterIssuerSerialTemplate = "(&(" + ldapConfig.getAttrIssuerID() + "=%s)(" + ldapConfig.getAttrSerialNumber() + "=%s))";
    }

    @Override
    public List<X509Certificate> getTrustedCaCerts() {
        return this.getCertificatesFromLdap(this.rootDN, this.ldapConfig.getTrustedAuthorityFilter(), this.ldapConfig.getAttrCrtBinary());
    }

    @Override
    public List<X509Certificate> getCaCerts() {
        return this.getCertificatesFromLdap(this.rootDN, this.ldapConfig.getIntermediateFilter(), this.ldapConfig.getAttrCrtBinary());
    }

    @Override
    public List<X509CRL> getCRLs() {
        return this.getCRLsFromLdap(this.rootDN, this.ldapConfig.getCrlFilter(), this.ldapConfig.getAttrCrlBinary());
    }

    private List<X509Certificate> getCertificatesFromLdap(String tmpRootDN, String tmpFilter, String tmpAttrName) {
        try {
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            NamingEnumeration<SearchResult> answer = this.ldapSearch.searchSubTree(tmpRootDN, tmpFilter);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                Attribute attribute = attrs.get(tmpAttrName);
                if (attribute == null) continue;
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream((byte[])attribute.get()));
                certificates.add(certificate);
            }
            return certificates;
        }
        catch (CertificateException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private List<X509CRL> getCRLsFromLdap(String tmpRootDN, String tmpFilter, String tmpAttrName) {
        try {
            ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
            NamingEnumeration<SearchResult> answer = this.ldapSearch.searchSubTree(tmpRootDN, tmpFilter);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                Attribute attribute = attrs.get(tmpAttrName);
                if (attribute == null) continue;
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509CRL crl = (X509CRL)cf.generateCRL(new ByteArrayInputStream((byte[])attribute.get()));
                crls.add(crl);
            }
            return crls;
        }
        catch (CertificateException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (CRLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void saveCertificate(X509Certificate cert, String dn) {
        BasicAttributes attribs = new BasicAttributes();
        attribs.put(new BasicAttribute(ATTR_OBJECT_CLASS, this.ldapConfig.getCertObjectClass()));
        attribs.put(new BasicAttribute(this.ldapConfig.getAttrUID(), cert.getSubjectX500Principal().getName()));
        attribs.put(new BasicAttribute(this.ldapConfig.getAttrIssuerID(), cert.getIssuerX500Principal().getName()));
        attribs.put(new BasicAttribute(this.ldapConfig.getAttrSerialNumber(), cert.getSerialNumber().toString(16)));
        this.addConstantAttributes(this.ldapConfig.getConstAttrNamesCSV(), this.ldapConfig.getConstAttrValuesCSV(), attribs);
        try {
            attribs.put(new BasicAttribute(this.ldapConfig.getAttrCrtBinary(), cert.getEncoded()));
            this.ldapSearch.bind(dn, attribs);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void addConstantAttributes(String names, String values, Attributes attribs) {
        String[] arrValues;
        String[] arrNames = names.split(",");
        if (arrNames.length != (arrValues = values.split(",")).length) {
            throw new IllegalArgumentException(String.format("Inconsintent constant attributes: %s; %s", names, values));
        }
        for (int i = 0; i < arrNames.length; ++i) {
            attribs.put(new BasicAttribute(arrNames[i], arrValues[i]));
        }
    }

    @Override
    public X509Certificate findBySubjectDn(String id) {
        X509Certificate cert = null;
        try {
            String dn = id;
            if (this.rootDN != null && !this.rootDN.isEmpty()) {
                dn = dn + "," + this.rootDN;
            }
            cert = this.getCertificateForDn(dn);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        try {
            cert = this.getCertificateForUIDAttr(id);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return cert;
    }

    @Override
    public X509Certificate findByServiceName(String serviceName) {
        X509Certificate cert = null;
        try {
            String dn = this.getDnForServiceName(serviceName);
            cert = this.getCertificateForDn(dn);
        }
        catch (NamingException dn) {
            // empty catch block
        }
        try {
            String uidAttr = String.format(this.ldapConfig.getServiceCertUIDTemplate(), serviceName);
            cert = this.getCertificateForUIDAttr(uidAttr);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return cert;
    }

    private String getDnForServiceName(String serviceName) {
        String escapedIdentifier = serviceName.replaceAll("\\/", Matcher.quoteReplacement("\\/"));
        return String.format(this.ldapConfig.getServiceCertRDNTemplate(), escapedIdentifier) + "," + this.rootDN;
    }

    private X509Certificate getCertificateForDn(String dn) throws NamingException {
        Attribute attr = this.ldapSearch.getAttribute(dn, this.ldapConfig.getAttrCrtBinary());
        return this.getCert(attr);
    }

    private X509Certificate getCertificateForUIDAttr(String uid) throws NamingException {
        String filter = String.format(this.filterUIDTemplate, uid);
        Attribute attr = this.ldapSearch.findAttribute(this.rootDN, filter, this.ldapConfig.getAttrCrtBinary());
        return this.getCert(attr);
    }

    @Override
    public X509Certificate findByIssuerSerial(String issuer, String serial) {
        if (issuer == null || serial == null) {
            throw new IllegalArgumentException("Issuer and serial applications are expected in request");
        }
        String filter = String.format(this.filterIssuerSerialTemplate, issuer, serial);
        try {
            Attribute attr = this.ldapSearch.findAttribute(this.rootDN, filter, this.ldapConfig.getAttrCrtBinary());
            return this.getCert(attr);
        }
        catch (NamingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private X509Certificate getCert(Attribute attr) {
        byte[] data;
        if (attr == null) {
            return null;
        }
        try {
            data = (byte[])attr.get();
        }
        catch (NamingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (data == null) {
            return null;
        }
        try {
            return (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(data));
        }
        catch (CertificateException e) {
            throw new RuntimeException("Error deserializing certificate: " + e.getMessage(), e);
        }
    }

    @Override
    public void saveCertificate(X509Certificate cert, UseKeyWithType key) {
        String dn;
        Applications application = Applications.fromUri((String)key.getApplication());
        if (application == Applications.PKIX) {
            dn = key.getIdentifier() + "," + this.rootDN;
        } else if (application == Applications.SERVICE_SOAP) {
            dn = this.getDnForServiceName(key.getIdentifier());
        } else {
            throw new IllegalArgumentException("Unsupported Application " + application);
        }
        this.saveCertificate(cert, dn);
    }
}

