/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.x509.validator;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.xkms.handlers.Validator;
import org.apache.cxf.xkms.model.xkms.KeyBindingEnum;
import org.apache.cxf.xkms.model.xkms.ReasonEnum;
import org.apache.cxf.xkms.model.xkms.StatusType;
import org.apache.cxf.xkms.model.xkms.ValidateRequestType;
import org.apache.cxf.xkms.x509.repo.CertificateRepo;
import org.apache.cxf.xkms.x509.validator.ValidateRequestParser;

public class TrustedAuthorityValidator
implements Validator {
    private static final Logger LOG = LogUtils.getL7dLogger(TrustedAuthorityValidator.class);
    CertificateRepo certRepo;
    boolean enableRevocation = true;

    public TrustedAuthorityValidator(CertificateRepo certRepo) {
        this.certRepo = certRepo;
    }

    boolean isCertificateChainValid(List<X509Certificate> certificates) {
        X509Certificate targetCert = certificates.get(0);
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(targetCert);
        try {
            List<X509CRL> crls;
            List<X509Certificate> intermediateCerts = this.certRepo.getCaCerts();
            List<X509Certificate> trustedAuthorityCerts = this.certRepo.getTrustedCaCerts();
            Set<TrustAnchor> trustAnchors = this.asTrustAnchors(trustedAuthorityCerts);
            CollectionCertStoreParameters intermediateParams = new CollectionCertStoreParameters(intermediateCerts);
            CollectionCertStoreParameters certificateParams = new CollectionCertStoreParameters(certificates);
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
            pkixParams.addCertStore(CertStore.getInstance("Collection", intermediateParams));
            pkixParams.addCertStore(CertStore.getInstance("Collection", certificateParams));
            pkixParams.setRevocationEnabled(false);
            CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
            CertPath certPath = builder.build(pkixParams).getCertPath();
            if (this.enableRevocation && !(crls = this.certRepo.getCRLs()).isEmpty()) {
                pkixParams.setRevocationEnabled(true);
                CollectionCertStoreParameters crlParams = new CollectionCertStoreParameters(crls);
                pkixParams.addCertStore(CertStore.getInstance("Collection", crlParams));
            }
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            validator.validate(certPath, pkixParams);
        }
        catch (InvalidAlgorithmParameterException e) {
            LOG.log(Level.SEVERE, "Invalid algorithm parameter by certificate chain validation. It is likely that issuer certificates are not found in XKMS trusted storage. " + e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.log(Level.SEVERE, "Unknown algorithm by certificate chain validation: " + e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (CertPathBuilderException e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            return false;
        }
        catch (CertPathValidatorException e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            return false;
        }
        return true;
    }

    private Set<TrustAnchor> asTrustAnchors(List<X509Certificate> trustedAuthorityCerts) {
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate trustedAuthorityCert : trustedAuthorityCerts) {
            trustAnchors.add(new TrustAnchor(trustedAuthorityCert, null));
        }
        return trustAnchors;
    }

    public StatusType validate(ValidateRequestType request) {
        StatusType status = new StatusType();
        List<X509Certificate> certificates = ValidateRequestParser.parse(request);
        if (certificates == null || certificates.isEmpty()) {
            status.setStatusValue(KeyBindingEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_INDETERMINATE);
            status.getIndeterminateReason().add("http://www.cxf.apache.org/2002/03/xkms#RequestNotSupported");
        }
        if (this.isCertificateChainValid(certificates)) {
            status.getValidReason().add(ReasonEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_ISSUER_TRUST.value());
            status.setStatusValue(KeyBindingEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_VALID);
        } else {
            status.getInvalidReason().add(ReasonEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_ISSUER_TRUST.value());
            status.setStatusValue(KeyBindingEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_INVALID);
        }
        return status;
    }

    public boolean isEnableRevocation() {
        return this.enableRevocation;
    }

    public void setEnableRevocation(boolean enableRevocation) {
        this.enableRevocation = enableRevocation;
    }
}

