/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.cxf.customer.book.BookNotFoundDetails;
import org.apache.cxf.customer.book.BookNotFoundFault;
import org.apache.cxf.systest.jaxrs.AtomBook;
import org.apache.cxf.systest.jaxrs.AtomUtils;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.CD;

@Path(value="/")
public class AtomBookStore {
    @Context
    protected UriInfo uField;
    private HttpHeaders headers;
    private Map<Long, Book> books = new HashMap<Long, Book>();
    private Map<Long, CD> cds = new HashMap<Long, CD>();
    private long bookId = 123L;
    private long cdId = 123L;

    public AtomBookStore() {
        this.init();
    }

    @Context
    public void setHttpHeaders(HttpHeaders theHeaders) {
        this.headers = theHeaders;
    }

    @GET
    @Path(value="/books/jsonfeed")
    @Produces(value={"application/xml", "application/json", "text/html", "application/atom+xml"})
    public Feed getBooksAsJsonFeed(@Context UriInfo uParam) {
        return this.getBooksAsFeed(uParam);
    }

    @GET
    @Path(value="/books/feed")
    @Produces(value={"application/atom+xml", "application/json"})
    public Feed getBooksAsFeed(@Context UriInfo uParam) {
        MediaType mt = this.headers.getMediaType();
        if (!(mt.equals((Object)MediaType.valueOf((String)"*")) || mt.equals((Object)MediaType.APPLICATION_JSON_TYPE) || mt.equals((Object)MediaType.APPLICATION_ATOM_XML_TYPE))) {
            throw new WebApplicationException();
        }
        return this.doGetBookAsFeed(uParam);
    }

    private Feed doGetBookAsFeed(@Context UriInfo uParam) {
        Factory factory = Abdera.getNewFactory();
        Feed f = factory.newFeed();
        f.setBaseUri(uParam.getAbsolutePath().toString());
        f.setTitle("Collection of Books");
        f.setId("http://www.books.com");
        f.addAuthor("BookStore Management Company");
        try {
            for (Book b : this.books.values()) {
                Entry e = AtomUtils.createBookEntry(factory, b);
                f.addEntry(e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    @POST
    @Path(value="/books/feed")
    @Consumes(value={"application/atom+xml"})
    public Response addBookAsEntry(Entry e) {
        try {
            String text = e.getContentElement().getValue();
            StringReader reader = new StringReader(text);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Book.class});
            Book b = (Book)jc.createUnmarshaller().unmarshal((Reader)reader);
            this.books.put(b.getId(), b);
            URI uri = this.uField.getBaseUriBuilder().path("books").path("entries").path(Long.toString(b.getId())).build(new Object[0]);
            return Response.created((URI)uri).entity((Object)e).build();
        }
        catch (Exception ex) {
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/books/feed/relative")
    @Consumes(value={"application/atom+xml"})
    public Response addBookAsEntryRelativeURI(Entry e) throws Exception {
        try {
            String text = e.getContentElement().getValue();
            StringReader reader = new StringReader(text);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Book.class});
            Book b = (Book)jc.createUnmarshaller().unmarshal((Reader)reader);
            this.books.put(b.getId(), b);
            URI uri = URI.create("books/entries/" + Long.toString(b.getId()));
            return Response.created((URI)uri).entity((Object)e).build();
        }
        catch (Exception ex) {
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/books/entries/{bookId}/")
    @Produces(value={"application/atom+xml", "application/json"})
    public Entry getBookAsEntry(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        Book book = this.books.get(Long.parseLong(id));
        if (book != null) {
            try {
                return AtomUtils.createBookEntry(book, this.uField.getAbsolutePath().toString());
            }
            catch (Exception exception) {
            }
        } else {
            BookNotFoundDetails details = new BookNotFoundDetails();
            details.setId(Long.parseLong(id));
            throw new BookNotFoundFault(details);
        }
        return null;
    }

    @Path(value="/books/subresources/{bookId}/")
    public AtomBook getBook(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        Book book = this.books.get(Long.parseLong(id));
        if (book != null) {
            try {
                return new AtomBook(book);
            }
            catch (Exception exception) {
            }
        } else {
            BookNotFoundDetails details = new BookNotFoundDetails();
            details.setId(Long.parseLong(id));
            throw new BookNotFoundFault(details);
        }
        return null;
    }

    final void init() {
        Book book = new Book();
        book.setId(this.bookId);
        book.setName("CXF in Action");
        this.books.put(book.getId(), book);
        CD cd = new CD();
        cd.setId(this.cdId);
        cd.setName("BOHEMIAN RHAPSODY");
        this.cds.put(cd.getId(), cd);
        CD cd1 = new CD();
        cd1.setId(++this.cdId);
        cd1.setName("BICYCLE RACE");
        this.cds.put(cd1.getId(), cd1);
    }
}

