/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.TimeoutHandler;

@Path(value="/bookstore")
public class BookContinuationStore {
    private Map<String, String> books = new HashMap<String, String>();
    private Executor executor = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));

    public BookContinuationStore() {
        this.init();
    }

    @GET
    @Path(value="/books/defaulttimeout")
    public void getBookDescriptionWithTimeout(AsyncResponse async) {
        async.register((Object)new CallbackImpl());
        async.setTimeout(2000L, TimeUnit.MILLISECONDS);
    }

    @GET
    @Path(value="/books/resume")
    @Produces(value={"text/plain"})
    public void getBookDescriptionImmediateResume(AsyncResponse async) {
        async.resume((Object)"immediateResume");
    }

    @GET
    @Path(value="/books/cancel")
    public void getBookDescriptionWithCancel(@PathParam(value="id") String id, AsyncResponse async) {
        async.setTimeout(2000L, TimeUnit.MILLISECONDS);
        async.setTimeoutHandler((TimeoutHandler)new CancelTimeoutHandlerImpl());
    }

    @GET
    @Path(value="/books/timeouthandler/{id}")
    public void getBookDescriptionWithHandler(@PathParam(value="id") String id, AsyncResponse async) {
        async.setTimeout(1000L, TimeUnit.MILLISECONDS);
        async.setTimeoutHandler((TimeoutHandler)new TimeoutHandlerImpl(id, false));
    }

    @GET
    @Path(value="/books/timeouthandlerresume/{id}")
    public void getBookDescriptionWithHandlerResumeOnly(@PathParam(value="id") String id, AsyncResponse async) {
        async.setTimeout(1000L, TimeUnit.MILLISECONDS);
        async.setTimeoutHandler((TimeoutHandler)new TimeoutHandlerImpl(id, true));
    }

    @GET
    @Path(value="/books/{id}")
    public void getBookDescription(@PathParam(value="id") String id, AsyncResponse async) {
        this.handleContinuationRequest(id, async);
    }

    @Path(value="/books/subresources/")
    public BookContinuationStore getBookStore() {
        return this;
    }

    @GET
    @Path(value="{id}")
    public void handleContinuationRequest(@PathParam(value="id") String id, AsyncResponse response) {
        this.resumeSuspended(id, response);
    }

    private void resumeSuspended(final String id, final AsyncResponse response) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                response.resume(BookContinuationStore.this.books.get(id));
            }
        });
    }

    private void init() {
        this.books.put("1", "CXF in Action1");
        this.books.put("2", "CXF in Action2");
        this.books.put("3", "CXF in Action3");
        this.books.put("4", "CXF in Action4");
        this.books.put("5", "CXF in Action5");
    }

    private class CallbackImpl
    implements CompletionCallback {
        private CallbackImpl() {
        }

        public void onComplete() {
            System.out.println("CompletionCallback: onComplete");
        }

        public void onError(Throwable throwable) {
            System.out.println("CompletionCallback: onError");
        }
    }

    private class CancelTimeoutHandlerImpl
    implements TimeoutHandler {
        private CancelTimeoutHandlerImpl() {
        }

        public void handleTimeout(AsyncResponse asyncResponse) {
            asyncResponse.cancel(10);
        }
    }

    private class TimeoutHandlerImpl
    implements TimeoutHandler {
        private boolean resumeOnly;
        private String id;
        private AtomicInteger timeoutExtendedCounter = new AtomicInteger();

        public TimeoutHandlerImpl(String id, boolean resumeOnly) {
            this.id = id;
            this.resumeOnly = resumeOnly;
        }

        public void handleTimeout(AsyncResponse asyncResponse) {
            if (!this.resumeOnly && this.timeoutExtendedCounter.addAndGet(1) <= 2) {
                asyncResponse.setTimeout(1L, TimeUnit.SECONDS);
            } else {
                asyncResponse.resume(BookContinuationStore.this.books.get(this.id));
            }
        }
    }
}

