/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.annotations.GZIP;
import org.apache.cxf.common.util.ProxyHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.Nullable;
import org.apache.cxf.jaxrs.ext.Oneway;
import org.apache.cxf.jaxrs.ext.PATCH;
import org.apache.cxf.jaxrs.ext.StreamingResponse;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.cxf.jaxrs.ext.search.QueryContext;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchContext;
import org.apache.cxf.jaxrs.ext.xml.XMLInstruction;
import org.apache.cxf.jaxrs.ext.xml.XSISchemaLocation;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ResourceContextImpl;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.Book2;
import org.apache.cxf.systest.jaxrs.BookNoXmlRootElement;
import org.apache.cxf.systest.jaxrs.BookNotFoundDetails;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;
import org.apache.cxf.systest.jaxrs.BookServer20;
import org.apache.cxf.systest.jaxrs.BookSubresource;
import org.apache.cxf.systest.jaxrs.BookSubresourceImpl;
import org.apache.cxf.systest.jaxrs.BookWrapper;
import org.apache.cxf.systest.jaxrs.BusMapperException;
import org.apache.cxf.systest.jaxrs.CD;
import org.apache.cxf.systest.jaxrs.CDs;
import org.apache.cxf.systest.jaxrs.Chapter;
import org.apache.cxf.systest.jaxrs.CustomResponse;
import org.apache.cxf.systest.jaxrs.GenericHandler;
import org.apache.cxf.systest.jaxrs.RETRIEVE;

@Path(value="/bookstore")
@GZIP(threshold=1)
public class BookStore {
    private Map<Long, Book> books = new HashMap<Long, Book>();
    private Map<Long, CD> cds = new HashMap<Long, CD>();
    private long bookId = 123L;
    private long cdId = 123L;
    private String defaultName;
    private long defaultId;
    private String currentBookId;
    @PathParam(value="CDId")
    private String currentCdId;
    @Context
    private HttpHeaders httpHeaders;
    @Context
    private SecurityContext securityContext;
    @Context
    private UriInfo ui;
    @Context
    private ResourceContext resourceContext;
    @Context
    private MessageContext messageContext;
    @BeanParam
    private BookBean theBookBean;
    private Book2 book2Sub = new Book2();

    public BookStore() {
        this.init();
    }

    @PostConstruct
    public void postConstruct() {
    }

    @PreDestroy
    public void preDestroy() {
    }

    @GET
    @Path(value="faultyResponseHandler")
    public Book testFaultyResponseHandler() {
        return new Book("root", 124L);
    }

    @GET
    @Path(value="/")
    public Book getBookRoot() {
        return new Book("root", 124L);
    }

    @GET
    @Path(value="/bookarray")
    public String[] getBookStringArray() {
        return new String[]{"Good book"};
    }

    @GET
    @Path(value="/bookindexintarray")
    @Produces(value={"text/plain"})
    public int[] getBookIndexAsIntArray() {
        return new int[]{1, 2, 3};
    }

    @GET
    @Path(value="/bookindexdoublearray")
    @Produces(value={"text/plain"})
    public double[] getBookIndexAsDoubleArray() {
        return new double[]{1.0, 2.0, 3.0};
    }

    @GET
    @Path(value="/redirect")
    public Response getBookRedirect(@QueryParam(value="redirect") Boolean done, @QueryParam(value="sameuri") Boolean sameuri, @CookieParam(value="a") String cookie) {
        if (done == null) {
            String uri = sameuri.equals(Boolean.TRUE) ? this.ui.getAbsolutePathBuilder().queryParam("redirect", new Object[]{"true"}).build(new Object[0]).toString() : "http://otherhost/redirect";
            return Response.status((int)303).cookie(new NewCookie[]{NewCookie.valueOf((String)"a=b")}).header("Location", (Object)uri).build();
        }
        return Response.ok((Object)new Book("CXF", 123L), (String)"application/xml").header("RequestURI", (Object)this.ui.getRequestUri().toString()).header("TheCookie", (Object)cookie).build();
    }

    @GET
    @Path(value="/redirect/relative")
    public Response getBookRedirectRel(@QueryParam(value="redirect") Boolean done, @QueryParam(value="loop") boolean loop) {
        if (done == null) {
            if (loop) {
                return Response.status((int)303).header("Location", (Object)"relative?loop=true").build();
            }
            return Response.status((int)303).header("Location", (Object)"relative?redirect=true").build();
        }
        return Response.ok((Object)new Book("CXF", 124L), (String)"application/xml").build();
    }

    @GET
    @Path(value="/booklist")
    public List<String> getBookListArray() {
        return Collections.singletonList("Good book");
    }

    @GET
    @Path(value="/customtext")
    @Produces(value={"text/custom"})
    public String getCustomBookTest() {
        return "Good book";
    }

    @GET
    @Path(value="/dropjsonroot")
    @Produces(value={"application/json"})
    public Book getBookDropJsonRoot(@Context MessageContext mc) throws BookNotFoundFault {
        mc.put((Object)"drop.json.root.element", (Object)"true");
        return this.doGetBook("123");
    }

    @GET
    @Path(value="/httpresponse")
    public void getBookDesciptionHttpResponse(@Context HttpServletResponse response) {
        response.setContentType("text/plain");
        try {
            response.getOutputStream().write("Good Book".getBytes());
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    @RETRIEVE
    @Path(value="/retrieve")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public Book retrieveBook(Book book) {
        return book;
    }

    @PATCH
    @Path(value="/patch")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public Response patchBook(Book book) {
        return Response.ok((Object)book).build();
    }

    @DELETE
    @Path(value="/deletebody")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public Book deleteBodyBook(Book book) {
        return book;
    }

    @POST
    @Path(value="/emptyform")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String postEmptyForm(Form form) {
        if (!form.getData().isEmpty()) {
            throw new WebApplicationException(400);
        }
        return "empty form";
    }

    @GET
    @Path(value="/booknames/123")
    @Produces(value={"application/bar"})
    public byte[] getBookName123() {
        Long l = Long.parseLong("123");
        return this.books.get(l).getName().getBytes();
    }

    @GET
    @Path(value="/beanparam/{id}")
    @Produces(value={"application/xml"})
    public Book getBeanParamBook(@BeanParam BookBean bean) {
        long id = bean.getId() + bean.getId2() + bean.getId3();
        return this.books.get(id);
    }

    @GET
    @Path(value="/twoBeanParams/{id}")
    @Produces(value={"application/xml"})
    public Book getTwoBeanParamsBook(@BeanParam BookBean2 bean1, @BeanParam BookBeanNested bean2) {
        long id = bean1.getId() + bean1.getId2() + bean1.getId3();
        if (bean2.getId4() != id) {
            throw new RuntimeException();
        }
        return this.books.get(id);
    }

    @POST
    @Path(value="/mapperonbus")
    public void mapperOnBus() {
        throw new BusMapperException();
    }

    @GET
    @Path(value="/beanparam2/{id}")
    @Produces(value={"application/xml"})
    public Book getBeanParamBook2() {
        return this.getBeanParamBook(this.theBookBean);
    }

    @GET
    @Path(value="emptybook")
    @Produces(value={"application/xml", "application/json"})
    public Book getEmptyBook() {
        return null;
    }

    @GET
    @Path(value="emptybook/nillable")
    @Produces(value={"application/xml", "application/json"})
    @Nullable
    public Book getEmptyBookNullable() {
        return null;
    }

    @GET
    @Path(value="allCharsButA-B/:@!$&'()*+,;=-._~")
    public Book getWithComplexPath() {
        return new Book("Encoded Path", 125L);
    }

    @GET
    @Path(value="object")
    public Object getBookAsObject() {
        return new Book("Book as Object", 125L);
    }

    @GET
    @Path(value="/default")
    @Produces(value={"application/xml"})
    public Book getDefaultBook() {
        return new Book(this.defaultName, this.defaultId);
    }

    @GET
    @Path(value="/books/colon/{a}:{b}:{c}")
    @Produces(value={"application/xml"})
    public Book getBookWithColonMarks(@PathParam(value="a") String id1, @PathParam(value="b") String id2, @PathParam(value="c") String id3) throws BookNotFoundFault {
        return this.doGetBook(id1 + id2 + id3);
    }

    @POST
    @Path(value="emptypost")
    public void emptypost() {
        String uri = this.ui.getAbsolutePath().toString();
        if (uri.endsWith("/")) {
            throw new WebApplicationException(400);
        }
    }

    @PUT
    @Path(value="emptyput")
    public void emptyput() {
    }

    @POST
    public void emptypostNoPath() {
        this.emptypost();
    }

    @GET
    @Path(value="webappexception")
    public Book throwException() {
        Response response = Response.serverError().entity((Object)"This is a WebApplicationException").build();
        throw new WebApplicationException(response);
    }

    @GET
    @Path(value="webappexceptionXML")
    public Book throwExceptionXML() {
        Response response = Response.status((int)406).type("application/xml").entity((Object)"<Book><name>Exception</name><id>999</id></Book>").build();
        throw new WebApplicationException(response);
    }

    @GET
    @Path(value="tempredirect")
    public Response tempRedirectAndSetCookies() {
        URI uri = UriBuilder.fromPath((String)"whatever/redirection").queryParam("css1", new Object[]{"http://bar"}).build(new Object[0]);
        return Response.temporaryRedirect((URI)uri).header("Set-Cookie", (Object)"a=b").header("Set-Cookie", (Object)"c=d").build();
    }

    @GET
    @Path(value="setcookies")
    public Response setComplexCookies() {
        return Response.ok().header("Set-Cookie", (Object)"bar.com.anoncart=107894933471602436; Domain=.bar.com; Expires=Thu, 01-Oct-2020 23:44:22 GMT; Path=/").build();
    }

    @GET
    @Path(value="setmanycookies")
    public Response setTwoCookies() {
        return Response.ok().header("Set-Cookie", (Object)"JSESSIONID=0475F7F30A26E5B0C15D69; Path=/").header("Set-Cookie", (Object)"COOKIETWO=dummy; Expires=Sat, 20-Nov-2010 19:11:32 GMT; Path=/").header("Set-Cookie", (Object)"COOKIETWO=dummy2; expires=Sat, 20-Nov-2010 19:11:32 GMT; Path=/").build();
    }

    @GET
    @Path(value="propagate-exception")
    public Book propogateException() throws BookNotFoundFault {
        throw new BookNotFoundFault("Book Exception");
    }

    @GET
    @Path(value="multipleexceptions")
    public Response getBookWithExceptions(@QueryParam(value="exception") boolean notReturned) throws BookNotFoundFault, BookNotReturnedException {
        if (notReturned) {
            throw new WebApplicationException(Response.status((int)404).header("Status", (Object)"notReturned").build());
        }
        throw new WebApplicationException(Response.status((int)404).header("Status", (Object)"notFound").build());
    }

    @GET
    @Path(value="multipleexceptions2")
    public Response getBookWithExceptions2(@QueryParam(value="exception") boolean notReturned) throws BookNotReturnedException, BookNotFoundFault {
        return this.getBookWithExceptions(notReturned);
    }

    @GET
    @Path(value="propogateExceptionVar/{i}")
    public Book propogateExceptionWithVar() throws BookNotFoundFault {
        return null;
    }

    @GET
    @Path(value="name-in-query")
    @Produces(value={"application/xml"})
    @XMLInstruction(value="<!DOCTYPE Something SYSTEM 'my.dtd'><?xmlstylesheet href='common.css' ?>")
    @XSISchemaLocation(value="book.xsd")
    public Book getBookFromQuery(@QueryParam(value="name") String name) {
        return new Book(name, 321L);
    }

    @GET
    @Path(value="propagate-exception2")
    public Book propogateException2() throws BookNotFoundFault {
        PhaseInterceptorChain.getCurrentMessage().put((Object)"org.apache.cxf.propagate.exception", (Object)Boolean.FALSE);
        throw new BookNotFoundFault("Book Exception");
    }

    @GET
    @Path(value="propagate-exception3")
    public Book propogateException3() throws BookNotFoundFault {
        PhaseInterceptorChain.getCurrentMessage().getExchange().put((Object)"org.apache.cxf.systest.for-out-fault-interceptor", (Object)Boolean.TRUE);
        throw new BookNotFoundFault("Book Exception");
    }

    @GET
    @Path(value="books/check/{id}")
    @Produces(value={"text/plain"})
    public boolean checkBook(@PathParam(value="id") Long id) {
        return this.books.containsKey(id);
    }

    @GET
    @Path(value="books/check/malformedmt/{id}")
    @Produces(value={"text/plain"})
    public Response checkBookMalformedMT(@PathParam(value="id") Long id, @Context MessageContext mc) {
        mc.put((Object)"org.apache.cxf.jaxrs.mediaTypeCheck.strict", (Object)false);
        return Response.ok((Object)this.books.containsKey(id)).type("text").build();
    }

    @POST
    @Path(value="books/check2")
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public Boolean checkBook2(Long id) {
        return this.books.containsKey(id);
    }

    @GET
    @Path(value="timetable")
    public Calendar getTimetable() {
        return new GregorianCalendar();
    }

    @GET
    @Path(value="wrongparametertype")
    public void wrongParameterType(@QueryParam(value="p") Map<?, ?> p) {
        throw new IllegalStateException("This op is not expected to be invoked");
    }

    @GET
    @Path(value="exceptionduringconstruction")
    public void wrongParameterType(@QueryParam(value="p") BadBook p) {
        throw new IllegalStateException("This op is not expected to be invoked");
    }

    @POST
    @Path(value="/unsupportedcontenttype")
    @Consumes(value={"application/xml"})
    public String unsupportedContentType() {
        throw new IllegalStateException("This op is not expected to be invoked");
    }

    @GET
    @Path(value="/bookurl/{URL}/")
    public Book getBookByURL(@PathParam(value="URL") String urlValue) throws Exception {
        String url2 = new URL(urlValue).toString();
        int index = url2.lastIndexOf(47);
        return this.doGetBook(url2.substring(index + 1));
    }

    @OPTIONS
    @Path(value="/options")
    public Response getOptions() throws Exception {
        return Response.ok().header("Allow", (Object)"POST").header("Allow", (Object)"PUT").header("Allow", (Object)"GET").header("Allow", (Object)"DELETE").build();
    }

    @POST
    @Path(value="post401")
    public Response get401WithText() throws Exception {
        return Response.status((int)401).entity((Object)"This is 401").build();
    }

    @GET
    @Path(value="infault")
    public Response infault() {
        throw new RuntimeException();
    }

    @GET
    @Path(value="infault2")
    public Response infault2() {
        throw new RuntimeException();
    }

    @GET
    @Path(value="outfault")
    public Response outfault() {
        return Response.ok().build();
    }

    @POST
    @Path(value="/collections")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public List<Book> getBookCollection(List<Book> bs) throws Exception {
        if (bs == null || bs.size() != 2) {
            throw new RuntimeException();
        }
        return bs;
    }

    @POST
    @Path(value="/collectionBook")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public List<Book> postBookGetCollection(@Nullable Book book) throws Exception {
        ArrayList<Book> list = new ArrayList<Book>();
        if (book != null) {
            list.add(book);
        }
        return list;
    }

    @POST
    @Path(value="/collections3")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Book postCollectionGetBook(List<Book> bs) throws Exception {
        if (bs == null || bs.size() != 2) {
            throw new RuntimeException();
        }
        return bs.get(0);
    }

    @POST
    @Path(value="/collections2")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public List<BookNoXmlRootElement> getBookCollection2(List<BookNoXmlRootElement> bs) throws Exception {
        if (bs == null || bs.size() != 2) {
            throw new RuntimeException();
        }
        return bs;
    }

    @GET
    @Path(value="/collections")
    @Produces(value={"application/xml", "application/json"})
    public List<Book> getBookCollection() throws Exception {
        return new ArrayList<Book>(this.books.values());
    }

    @POST
    @Path(value="/array")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public Book[] getBookArray(Book[] bs) throws Exception {
        if (bs == null || bs.length != 2) {
            throw new RuntimeException();
        }
        return bs;
    }

    @GET
    @Path(value="/segment/{pathsegment}/")
    public Book getBookBySegment(@PathParam(value="pathsegment") PathSegment segment) throws Exception {
        if (!"matrix2".equals(segment.getPath())) {
            throw new RuntimeException();
        }
        MultivaluedMap map = segment.getMatrixParameters();
        String s1 = ((String)map.getFirst((Object)"first")).toString();
        String s2 = ((String)map.getFirst((Object)"second")).toString();
        return this.doGetBook(s1 + s2);
    }

    @GET
    @Path(value="/segment/list/{pathsegment:.+}/")
    public Book getBookBySegment(@PathParam(value="pathsegment") List<PathSegment> list) throws Exception {
        return this.doGetBook(list.get(0).getPath() + list.get(1).getPath() + list.get(2).getPath());
    }

    @GET
    @Path(value="/segment/matrix")
    public Book getBookByMatrixParams(@MatrixParam(value="first") String s1, @MatrixParam(value="second") String s2) throws Exception {
        return this.doGetBook(s1 + s2);
    }

    @GET
    @Path(value="/segment/matrix-middle")
    public Book getBookByMatrixParamsMiddle(@MatrixParam(value="first") String s1, @MatrixParam(value="second") String s2) throws Exception {
        return this.doGetBook(s1 + s2);
    }

    @GET
    @Path(value="/segment/matrix-list")
    public Book getBookByMatrixListParams(@MatrixParam(value="first") List<String> list) throws Exception {
        if (list.size() != 2) {
            throw new RuntimeException();
        }
        return this.doGetBook(list.get(0) + list.get(1));
    }

    @GET
    @Path(value="/bookheaders/simple/")
    @BookServer20.CustomHeaderAdded
    @BookServer20.PostMatchMode
    public Response getBookByHeaderSimple(@HeaderParam(value="BOOK") String headerBook, @HeaderParam(value="Simple") String headerSimple) throws Exception {
        Response.ResponseBuilder builder = this.getBookByHeaderSimpleBuilder(headerBook, headerSimple);
        return builder.build();
    }

    @POST
    @Path(value="/bookheaders/simple/")
    @BookServer20.CustomHeaderAdded
    @BookServer20.PostMatchMode
    @Consumes(value={"application/xml"})
    public Response echoBookByHeaderSimple(Book book, @HeaderParam(value="Content-type") String ct, @HeaderParam(value="BOOK") String headerBook, @HeaderParam(value="Simple") String headerSimple, @HeaderParam(value="ServerReaderInterceptor") String serverInterceptorHeader, @HeaderParam(value="ClientWriterInterceptor") String clientInterceptorHeader) throws Exception {
        if (!"application/xml".equals(ct)) {
            throw new RuntimeException();
        }
        Response.ResponseBuilder builder = this.getBookByHeaderSimpleBuilder(headerBook, headerSimple);
        if (serverInterceptorHeader != null) {
            builder.header("ServerReaderInterceptor", (Object)serverInterceptorHeader);
        }
        if (clientInterceptorHeader != null) {
            builder.header("ClientWriterInterceptor", (Object)clientInterceptorHeader);
        }
        return builder.build();
    }

    @POST
    @Path(value="/bookheaders/simple/")
    @BookServer20.CustomHeaderAdded
    @BookServer20.PostMatchMode
    @Consumes(value={"application/v1+xml"})
    public Response echoBookByHeaderSimple2(Book book, @HeaderParam(value="Content-type") String ct, @HeaderParam(value="BOOK") String headerBook, @HeaderParam(value="Simple") String headerSimple, @HeaderParam(value="ServerReaderInterceptor") String serverInterceptorHeader, @HeaderParam(value="ClientWriterInterceptor") String clientInterceptorHeader) throws Exception {
        if (!"application/v1+xml".equals(ct)) {
            throw new RuntimeException();
        }
        Response.ResponseBuilder builder = this.getBookByHeaderSimpleBuilder(headerBook, headerSimple);
        if (serverInterceptorHeader != null) {
            builder.header("ServerReaderInterceptor", (Object)serverInterceptorHeader);
        }
        if (clientInterceptorHeader != null) {
            builder.header("ClientWriterInterceptor", (Object)clientInterceptorHeader);
        }
        builder.header("newmediatypeused", (Object)ct);
        return builder.build();
    }

    private Response.ResponseBuilder getBookByHeaderSimpleBuilder(@HeaderParam(value="BOOK") String headerBook, @HeaderParam(value="Simple") String headerSimple) throws Exception {
        Response.ResponseBuilder builder = Response.ok((Object)this.doGetBook(headerBook));
        if (headerSimple != null) {
            builder.header("Simple", (Object)headerSimple);
        }
        return builder;
    }

    @GET
    @Path(value="/bookheaders/")
    public Book getBookByHeader(@HeaderParam(value="BOOK") List<String> ids) throws Exception {
        List types = this.httpHeaders.getAcceptableMediaTypes();
        if (types.size() != 2 || !"text/xml".equals(((MediaType)types.get(0)).toString()) || !MediaType.APPLICATION_XML_TYPE.isCompatible((MediaType)types.get(1))) {
            throw new WebApplicationException();
        }
        List locales = this.httpHeaders.getAcceptableLanguages();
        if (locales.size() != 2 || !"en".equals(((Locale)locales.get(0)).getLanguage()) || !"da".equals(((Locale)locales.get(1)).getLanguage())) {
            throw new WebApplicationException();
        }
        Map cookies = this.httpHeaders.getCookies();
        if (!(cookies.size() == 3 && cookies.containsKey("a") && cookies.containsKey("c") && cookies.containsKey("e"))) {
            throw new WebApplicationException();
        }
        List cookiesList = this.httpHeaders.getRequestHeader("Cookie");
        if (!(cookiesList.size() == 3 && cookiesList.contains("a=b") && cookiesList.contains("c=d") && cookiesList.contains("e=f"))) {
            throw new WebApplicationException();
        }
        return this.doGetBook(ids.get(0) + ids.get(1) + ids.get(2));
    }

    @GET
    @Path(value="/bookheaders2/")
    public Book getBookByHeader(@DefaultValue(value="123") @HeaderParam(value="BOOK2") String id) throws Exception {
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/getheadbook/")
    public Book getBookGetHead() throws Exception {
        return this.doGetBook("123");
    }

    @HEAD
    @Path(value="/getheadbook/")
    public Response getBookGetHead2() throws Exception {
        return Response.ok().header("HEAD_HEADER", (Object)"HEAD_HEADER_VALUE").build();
    }

    @GET
    @Path(value="/bookquery")
    public Book getBookByURLQuery(@QueryParam(value="urlid") String urlValue) throws Exception {
        String url2 = new URL(urlValue).toString();
        int index = url2.lastIndexOf(47);
        return this.doGetBook(url2.substring(index + 1));
    }

    @GET
    @Path(value="/bookidarray")
    public Book getBookByURLQuery(@QueryParam(value="id") String[] ids) throws Exception {
        if (ids == null || ids.length != 3) {
            throw new WebApplicationException();
        }
        return this.doGetBook(ids[0] + ids[1] + ids[2]);
    }

    @GET
    @Path(value="/securebooks/{bookId}/")
    @Produces(value={"application/xml"})
    public Book getSecureBook(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        if (!this.securityContext.isSecure()) {
            throw new WebApplicationException(Response.status((int)403).entity((Object)"Unsecure link").build());
        }
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/genericbooks/{bookId}/")
    @Produces(value={"application/xml"})
    public GenericEntity<GenericHandler<Book>> getGenericBook(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return new GenericEntity<GenericHandler<Book>>(new GenericHandler<Book>(this.doGetBook(id))){};
    }

    @GET
    @Path(value="/genericbooks2/{bookId}/")
    @Produces(value={"application/xml"})
    public Response getGenericBook2(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return Response.ok().entity(this.getGenericBook(id), this.getExtraAnnotations()).build();
    }

    @GET
    @Path(value="/genericresponse/{bookId}/")
    @Produces(value={"application/xml"})
    public Response getGenericResponseBook(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return Response.ok(this.getGenericBook(id)).build();
    }

    @GET
    @Path(value="/books/{bookId}/")
    @Produces(value={"application/xml"})
    public Book getBook(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/books/query/default")
    @Produces(value={"application/xml"})
    public Book getBook(@QueryParam(value="bookId") long id) throws BookNotFoundFault {
        return this.books.get(id + 123L);
    }

    @GET
    @Path(value="/books/response/{bookId}/")
    @Produces(value={"application/xml"})
    public Response getBookAsResponse(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        Book entity = this.doGetBook(id);
        EntityTag etag = new EntityTag(Integer.toString(entity.hashCode()));
        return Response.ok().tag(etag).entity((Object)entity).build();
    }

    @GET
    @Path(value="/books/{bookId}/cglib")
    @Produces(value={"application/xml"})
    public Book getBookCGLIB(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.createCglibProxy(this.doGetBook(id));
    }

    @GET
    @Path(value="/the books/{bookId}/")
    @Produces(value={"application/xml"})
    public Book getBookWithSpace(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/thebooks/{bookId}/")
    @Produces(value={"application/xml"})
    public Book getBookWithSemicolon(@Encoded @PathParam(value="bookId") String id, @HeaderParam(value="customheader") String custom) {
        if (!"custom;:header".equals(custom)) {
            throw new RuntimeException();
        }
        Book b = new Book();
        b.setId(Long.valueOf(id.substring(0, 3)));
        b.setName("CXF in Action" + id.substring(3));
        String absPath = this.ui.getAbsolutePath().toString();
        if (absPath.contains("123;")) {
            b.setName(b.getName() + ";");
        }
        return b;
    }

    @GET
    @Path(value="/books/search")
    @Produces(value={"application/xml"})
    public Book getBook(@Context SearchContext searchContext) throws BookNotFoundFault {
        SearchCondition sc = searchContext.getCondition(Book.class);
        if (sc == null) {
            throw new BookNotFoundFault("Search exception");
        }
        List found = sc.findAll(this.books.values());
        if (found.size() != 1) {
            throw new BookNotFoundFault("Single book is expected");
        }
        return (Book)found.get(0);
    }

    @GET
    @Path(value="/books/querycontext/{expression}")
    @Produces(value={"text/plain"})
    public String getBookQueryContext(@PathParam(value="expression") String expression, @Context QueryContext searchContext) throws BookNotFoundFault {
        return searchContext.getConvertedExpression(expression);
    }

    @GET
    @Path(value="/books/{search}/chapter/{chapter}")
    @Produces(value={"application/xml"})
    public Chapter getChapterFromSelectedBook(@Context SearchContext searchContext, @PathParam(value="search") String expression, @PathParam(value="chapter") int chapter) {
        SearchCondition sc = searchContext.getCondition(expression, Book.class);
        if (sc == null) {
            throw new WebApplicationException(404);
        }
        List found = sc.findAll(this.books.values());
        if (found.size() != 1) {
            throw new WebApplicationException(404);
        }
        Book selectedBook = (Book)found.get(0);
        return selectedBook.getChapter(chapter);
    }

    @GET
    @Path(value="/books({search})/chapter")
    @Produces(value={"application/xml"})
    public Chapter getIntroChapterFromSelectedBook(@Context SearchContext searchContext, @PathParam(value="search") String expression) {
        return this.getChapterFromSelectedBook(searchContext, expression, 1);
    }

    @GET
    @Path(value="/books[{search}]/chapter")
    @Produces(value={"application/xml"})
    public Chapter getIntroChapterFromSelectedBook2(@Context SearchContext searchContext, @PathParam(value="search") String expression) {
        return this.getChapterFromSelectedBook(searchContext, expression, 1);
    }

    @GET
    @Path(value="/books/text/xml/{bookId}")
    @Produces(value={"text/xml"})
    public Book getBookTextXml(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/books/wrapper/{bookId}/")
    @Produces(value={"application/xml"})
    public BookWrapper getWrappedBook(@PathParam(value="bookId") Long id) throws BookNotFoundFault {
        BookWrapper bw = new BookWrapper();
        Book b = new Book("CXF in Action", 99999L);
        bw.setBook(b);
        return bw;
    }

    @GET
    @Path(value="/books/wrapper2/{bookId}/")
    @Produces(value={"application/xml"})
    public Book getWrappedBook2(@PathParam(value="bookId") Long id) throws BookNotFoundFault {
        return new Book("CXF in Action", 99999L);
    }

    @GET
    @Path(value="books/custom/{bookId:\\d\\d\\d}")
    public Book getBookCustom(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/books/query")
    public Book getBookQuery(@QueryParam(value="bookId") long id) throws BookNotFoundFault {
        return this.doGetBook(Long.toString(id));
    }

    @GET
    @Path(value="/books/defaultquery")
    public Book getDefaultBookQuery(@DefaultValue(value="123") @QueryParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @GET
    @Path(value="/books/missingquery")
    public Book getBookMissingQuery(@QueryParam(value="bookId") long id) throws BookNotFoundFault {
        if (id != 0L) {
            throw new RuntimeException();
        }
        return this.doGetBook("123");
    }

    @GET
    @Path(value="/books/element")
    public JAXBElement<Book> getBookElement() throws Exception {
        return new JAXBElement(new QName("", "Book"), Book.class, (Object)this.doGetBook("123"));
    }

    @POST
    @Path(value="/books/element/echo")
    public JAXBElement<Book> echoBookElement(JAXBElement<Book> element) throws Exception {
        return element;
    }

    @POST
    @Path(value="/books/echo")
    public Book echoBookElement(Book element) throws Exception {
        return element;
    }

    @POST
    @Path(value="/books/json/echo")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Book echoBookElementJson(Book element) throws Exception {
        return element;
    }

    @POST
    @Path(value="/books/element/echo/wildcard")
    public JAXBElement<? super Book> echoBookElementWildcard(JAXBElement<? extends Book> element) throws Exception {
        return element;
    }

    @GET
    @Path(value="/books/adapter")
    @XmlJavaTypeAdapter(value=BookInfoAdapter.class)
    public BookInfo getBookAdapter() throws Exception {
        return new BookInfo(this.doGetBook("123"));
    }

    @POST
    @Path(value="/books/adapter-list")
    @XmlJavaTypeAdapter(value=BookInfoAdapter.class)
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml", "application/json"})
    public List<BookInfo> getBookAdapterList(@XmlJavaTypeAdapter(value=BookInfoAdapter.class) List<BookInfo> collection) throws Exception {
        if (collection.size() != 1) {
            throw new WebApplicationException(400);
        }
        return collection;
    }

    @GET
    @Path(value="/books/interface/adapter")
    public BookInfoInterface getBookAdapterInterface() throws Exception {
        return new BookInfo2(this.doGetBook("123"));
    }

    @GET
    @Path(value="/books/interface/adapter-list")
    public List<? extends BookInfoInterface> getBookAdapterInterfaceList() throws Exception {
        ArrayList<BookInfo2> list = new ArrayList<BookInfo2>();
        list.add(new BookInfo2(this.doGetBook("123")));
        return list;
    }

    @GET
    @Path(value="/books/adapter-list")
    @XmlJavaTypeAdapter(value=BookInfoAdapter.class)
    public List<? extends BookInfo> getBookAdapterList() throws Exception {
        ArrayList<BookInfo> list = new ArrayList<BookInfo>();
        list.add(new BookInfo(this.doGetBook("123")));
        return list;
    }

    @PathParam(value="bookId")
    public void setBookId(String id) {
        this.currentBookId = id;
    }

    public void setDefaultNameAndId(String name, long id) {
        this.defaultName = name;
        this.defaultId = id;
    }

    @GET
    @Path(value="/books/{bookId}/")
    @Produces(value={"application/json;qs=0.9"})
    public Book getBookAsJSON() throws BookNotFoundFault {
        return this.doGetBook(this.currentBookId);
    }

    @GET
    @Path(value="/books/buffer")
    @Produces(value={"application/bar"})
    public InputStream getBufferedBook() {
        return this.getClass().getResourceAsStream("resources/expected_get_book123.txt");
    }

    @GET
    @Path(value="/books/fail-early")
    @Produces(value={"application/bar"})
    public StreamingOutput failEarlyInWrite() {
        return new StreamingOutputImpl(true);
    }

    @GET
    @Path(value="/books/statusFromStream")
    @Produces(value={"text/xml"})
    public StreamingOutput statusFromStream() {
        return new ResponseStreamingOutputImpl();
    }

    @GET
    @Path(value="/books/streamingresponse")
    @Produces(value={"text/xml"})
    public Response getBookStreamingResponse() {
        return Response.ok((Object)new StreamingResponse(){

            public void writeTo(StreamingResponse.Writer writer) throws IOException {
                writer.write((Object)new Book("stream", 124L));
            }
        }).build();
    }

    @GET
    @Path(value="/books/fail-late")
    @Produces(value={"application/bar"})
    public StreamingOutput writeToStreamAndFail() {
        return new StreamingOutputImpl(false);
    }

    private Book doGetBook(String id) throws BookNotFoundFault {
        Book book = this.books.get(Long.parseLong(id));
        if (book != null) {
            return book;
        }
        BookNotFoundDetails details = new BookNotFoundDetails();
        details.setId(Long.parseLong(id));
        throw new BookNotFoundFault(details);
    }

    @Path(value="/booksubresource/{bookId}/")
    public Book getBookSubResource(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        Book book = this.books.get(Long.parseLong(id));
        if (book != null) {
            return book;
        }
        BookNotFoundDetails details = new BookNotFoundDetails();
        details.setId(Long.parseLong(id));
        throw new BookNotFoundFault(details);
    }

    @Path(value="/booksubresource/context")
    public Book2 getBookSubResourceRC() {
        return (Book2)this.resourceContext.getResource(Book2.class);
    }

    @Path(value="/booksubresource/instance/context")
    public Book2 getBookSubResourceInstanceRC(@Context ResourceContext rc) {
        return (Book2)((ResourceContextImpl)rc).initResource((Object)this.book2Sub);
    }

    @Path(value="/booksubresourceobject/{bookId}/")
    public Object getBookSubResourceObject(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.getBookSubResource(id);
    }

    @GET
    @Path(value="/booknames/{bookId}/")
    @Produces(value={"text/*"})
    public String getBookName(@PathParam(value="bookId") int id) throws BookNotFoundFault {
        Book book = this.books.get(new Long(id));
        if (book != null) {
            return book.getName();
        }
        BookNotFoundDetails details = new BookNotFoundDetails();
        details.setId(id);
        throw new BookNotFoundFault(details);
    }

    @POST
    @Path(value="/books/null")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public Book handleNullBook(@Nullable Book book) {
        if (book != null) {
            throw new WebApplicationException(400);
        }
        return new Book("Default Book", 222L);
    }

    @POST
    @Path(value="/books")
    @Produces(value={"text/xml"})
    @Consumes(value={"application/xml"})
    public Response addBook(Book book) {
        String ct1 = this.httpHeaders.getMediaType().toString();
        String ct2 = (String)this.httpHeaders.getRequestHeader("Content-Type").get(0);
        String ct3 = (String)this.httpHeaders.getRequestHeaders().getFirst((Object)"Content-Type");
        if (!("application/xml".equals(ct1) && ct1.equals(ct2) && ct1.equals(ct3))) {
            throw new RuntimeException("Unexpected content type");
        }
        book.setId(this.bookId + 1L);
        return Response.ok((Object)book).build();
    }

    @POST
    @Path(value="/books2")
    @Produces(value={"text/xml"})
    @Consumes(value={"application/xml"})
    public Book addBook2(Book book) {
        return new Book("Book echo", book.getId() + 1L);
    }

    @POST
    @Path(value="/oneway")
    @Oneway
    public void onewayRequest() {
        if (!PhaseInterceptorChain.getCurrentMessage().getExchange().isOneWay()) {
            throw new WebApplicationException();
        }
    }

    @POST
    @Path(value="/books/customstatus")
    @Produces(value={"application/xml"})
    @Consumes(value={"text/xml"})
    public Book addBookCustomFailure(Book book, @Context HttpServletResponse response) {
        response.setStatus(233);
        response.addHeader("CustomHeader", "CustomValue");
        book.setId(888L);
        return book;
    }

    @POST
    @Path(value="/booksinfo")
    @Produces(value={"text/xml"})
    @Consumes(value={"application/xml"})
    public Response addBook(@XmlJavaTypeAdapter(value=BookInfoAdapter.class) BookInfo bookInfo) {
        return Response.ok((Object)bookInfo.asBook()).build();
    }

    @POST
    @Path(value="/binarybooks")
    @Produces(value={"text/xml"})
    @Consumes(value={"application/octet-stream"})
    public Response addBinaryBook(long[] book) {
        return Response.ok((Object)book).build();
    }

    @PUT
    @Path(value="/books/")
    public Response updateBook(Book book) {
        Book b = this.books.get(book.getId());
        Response r = b != null ? Response.ok((Object)book).build() : Response.notModified().build();
        return r;
    }

    @PUT
    @Path(value="/books/{id}")
    public Response createBook(@PathParam(value="id") Long id) {
        Response r;
        Book b = this.books.get(id);
        if (b == null) {
            Book newBook = new Book();
            newBook.setId(id);
            r = Response.ok((Object)newBook).build();
        } else {
            r = Response.notModified().build();
        }
        return r;
    }

    @PUT
    @Path(value="/bookswithdom/")
    public DOMSource updateBook(DOMSource ds) {
        return ds;
    }

    @PUT
    @Path(value="/bookswithjson/")
    @Consumes(value={"application/json"})
    public Response updateBookJSON(Book book) {
        Book b = this.books.get(book.getId());
        Response r = b != null ? Response.ok((Object)book).build() : Response.notModified().build();
        return r;
    }

    @DELETE
    @Path(value="/books/{bookId}/")
    public Response deleteBook(@PathParam(value="bookId") String id) {
        Book b = this.books.get(Long.parseLong(id));
        Response r = b != null ? Response.ok().build() : Response.notModified().build();
        return r;
    }

    @DELETE
    @Path(value="/books/id")
    public Response deleteWithQuery(@QueryParam(value="value") @DefaultValue(value="-1") int id) {
        if (id != 123) {
            throw new WebApplicationException();
        }
        Book b = this.books.get(new Long(id));
        Response r = b != null ? Response.ok().build() : Response.notModified().build();
        return r;
    }

    @POST
    @Path(value="/booksplain")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Long echoBookId(long theBookId) {
        return new Long(theBookId);
    }

    @POST
    @Path(value="/booksecho")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response echoBookNameAndHeader(@HeaderParam(value="CustomHeader") String headerValue, String name) {
        return Response.ok().entity((Object)name).header("CustomHeader", (Object)headerValue).build();
    }

    @Path(value="/bookstoresub")
    public BookStore echoThroughBookStoreSub() {
        return this;
    }

    @Path(value="/customresponse")
    @GET
    @Produces(value={"application/xml"})
    public Response getCustomBook() {
        return new CustomResponse(Response.ok().entity((Object)new Book("Book", 222L)).header("customresponse", (Object)"OK").build());
    }

    @POST
    @Path(value="/booksecho2")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response echoBookNameAndHeader2(String name) {
        return this.echoBookNameAndHeader((String)this.httpHeaders.getRequestHeader("CustomHeader").get(0), name);
    }

    @POST
    @Path(value="/booksecho3")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response echoBookNameAndHeader3(String name) {
        return this.echoBookNameAndHeader((String)this.httpHeaders.getRequestHeader("customheader").get(0), name);
    }

    @POST
    @Path(value="/booksecho202")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response echoBookName202(String name) {
        return Response.accepted((Object)name).build();
    }

    @GET
    @Path(value="/cd/{CDId}/")
    public CD getCD() {
        CD cd = this.cds.get(Long.parseLong(this.currentCdId));
        return cd;
    }

    @GET
    @Path(value="/cdwithmultitypes/{CDId}/")
    @Produces(value={"application/xml", "application/bar+xml", "application/json"})
    public CD getCDWithMultiContentTypes(@PathParam(value="CDId") String id) {
        CD cd = this.cds.get(Long.parseLong(id));
        return cd;
    }

    @GET
    @Path(value="/cds/")
    public CDs getCDs() {
        CDs c = new CDs();
        c.setCD(this.cds.values());
        return c;
    }

    @GET
    @Path(value="quotedheaders")
    public Response getQuotedHeader() {
        return Response.ok().header("SomeHeader1", (Object)"\"some text, some more text\"").header("SomeHeader2", (Object)"\"some text\"").header("SomeHeader2", (Object)"\"quoted,text\"").header("SomeHeader2", (Object)"\"even more text\"").header("SomeHeader3", (Object)"\"some text, some more text with inlined \\\"\"").header("SomeHeader4", (Object)"\"\"").build();
    }

    @GET
    @Path(value="badlyquotedheaders")
    public Response getBadlyQuotedHeader(@QueryParam(value="type") int t) {
        Response.ResponseBuilder rb = Response.ok();
        switch (t) {
            case 0: {
                rb.header("SomeHeader0", (Object)"\"some text");
                break;
            }
            case 1: {
                rb.header("SomeHeader1", (Object)"\"some text, some more text with inlined \\\"");
                break;
            }
            case 2: {
                rb.header("SomeHeader2", (Object)"\"some te\\");
                break;
            }
            case 3: {
                rb.header("SomeHeader3", (Object)"some text").header("SomeHeader3", (Object)"\"other quoted\", text").header("SomeHeader3", (Object)"blah");
                break;
            }
            default: {
                throw new RuntimeException("Don't know how to handle type: " + t);
            }
        }
        return rb.build();
    }

    @Path(value="/interface")
    public BookSubresource getBookFromSubresource() {
        return new BookSubresourceImpl();
    }

    public final String init() {
        this.books.clear();
        this.cds.clear();
        this.bookId = 123L;
        this.cdId = 123L;
        Book book = new Book();
        book.setId(this.bookId);
        book.setName("CXF in Action");
        this.books.put(book.getId(), book);
        CD cd = new CD();
        cd.setId(this.cdId);
        cd.setName("BOHEMIAN RHAPSODY");
        this.cds.put(cd.getId(), cd);
        CD cd1 = new CD();
        cd1.setId(++this.cdId);
        cd1.setName("BICYCLE RACE");
        this.cds.put(cd1.getId(), cd1);
        return "OK";
    }

    private Book createCglibProxy(final Book book) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)book, args);
            }
        };
        return (Book)ProxyHelper.getProxy((ClassLoader)this.getClass().getClassLoader(), (Class[])new Class[]{Book.class}, (InvocationHandler)handler);
    }

    private Annotation[] getExtraAnnotations() {
        try {
            Method m = BookBean.class.getMethod("setUriInfo", UriInfo.class);
            return m.getAnnotations();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class PrimitiveDoubleArrayReaderWriter
    implements MessageBodyReader<Object>,
    MessageBodyWriter<Object> {
        public boolean isReadable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
            return double[].class.isAssignableFrom(arg0);
        }

        public Object readFrom(Class<Object> arg0, Type arg1, Annotation[] arg2, MediaType arg3, MultivaluedMap<String, String> arg4, InputStream arg5) throws IOException, WebApplicationException {
            String[] stringArr = IOUtils.readStringFromStream((InputStream)arg5).split(",");
            double[] intArr = new double[stringArr.length];
            for (int i = 0; i < stringArr.length; ++i) {
                intArr[i] = Double.valueOf(stringArr[i]);
            }
            return intArr;
        }

        public long getSize(Object arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
            return -1L;
        }

        public boolean isWriteable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
            return double[].class.isAssignableFrom(arg0);
        }

        public void writeTo(Object arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4, MultivaluedMap<String, Object> arg5, OutputStream arg6) throws IOException, WebApplicationException {
            double[] arr = (double[])arg0;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < arr.length; ++i) {
                sb.append(Double.toString(arr[i]));
                if (i + 1 >= arr.length) continue;
                sb.append(",");
            }
            arg6.write(sb.toString().getBytes());
        }
    }

    public static class PrimitiveIntArrayReaderWriter
    implements MessageBodyReader<int[]>,
    MessageBodyWriter<int[]> {
        public boolean isReadable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
            return int[].class.isAssignableFrom(arg0);
        }

        public int[] readFrom(Class<int[]> arg0, Type arg1, Annotation[] arg2, MediaType arg3, MultivaluedMap<String, String> arg4, InputStream arg5) throws IOException, WebApplicationException {
            String[] stringArr = IOUtils.readStringFromStream((InputStream)arg5).split(",");
            int[] intArr = new int[stringArr.length];
            for (int i = 0; i < stringArr.length; ++i) {
                intArr[i] = Integer.valueOf(stringArr[i]);
            }
            return intArr;
        }

        public long getSize(int[] arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
            return -1L;
        }

        public boolean isWriteable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
            return int[].class.isAssignableFrom(arg0);
        }

        public void writeTo(int[] arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4, MultivaluedMap<String, Object> arg5, OutputStream arg6) throws IOException, WebApplicationException {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < arg0.length; ++i) {
                sb.append(Integer.toString(arg0[i]));
                if (i + 1 >= arg0.length) continue;
                sb.append(",");
            }
            arg6.write(sb.toString().getBytes());
        }
    }

    public static class StringListBodyReaderWriter
    implements MessageBodyReader<List<String>>,
    MessageBodyWriter<List<String>> {
        public boolean isReadable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
            return List.class.isAssignableFrom(arg0) && String.class == InjectionUtils.getActualType((Type)arg1);
        }

        public List<String> readFrom(Class<List<String>> arg0, Type arg1, Annotation[] arg2, MediaType arg3, MultivaluedMap<String, String> arg4, InputStream arg5) throws IOException, WebApplicationException {
            return Collections.singletonList(IOUtils.readStringFromStream((InputStream)arg5));
        }

        public long getSize(List<String> arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
            return -1L;
        }

        public boolean isWriteable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
            return List.class.isAssignableFrom(arg0) && String.class == InjectionUtils.getActualType((Type)arg1);
        }

        public void writeTo(List<String> arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4, MultivaluedMap<String, Object> arg5, OutputStream arg6) throws IOException, WebApplicationException {
            arg6.write(arg0.get(0).getBytes());
        }
    }

    public static class StringArrayBodyReaderWriter
    implements MessageBodyReader<String[]>,
    MessageBodyWriter<String[]> {
        public boolean isReadable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
            return String[].class.isAssignableFrom(arg0);
        }

        public String[] readFrom(Class<String[]> arg0, Type arg1, Annotation[] arg2, MediaType arg3, MultivaluedMap<String, String> arg4, InputStream arg5) throws IOException, WebApplicationException {
            return new String[]{IOUtils.readStringFromStream((InputStream)arg5)};
        }

        public long getSize(String[] arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
            return -1L;
        }

        public boolean isWriteable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
            return String[].class.isAssignableFrom(arg0);
        }

        public void writeTo(String[] arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4, MultivaluedMap<String, Object> arg5, OutputStream arg6) throws IOException, WebApplicationException {
            arg6.write(arg0[0].getBytes());
        }
    }

    public static class BookNotReturnedException
    extends RuntimeException {
        private static final long serialVersionUID = 4935423670510083220L;

        public BookNotReturnedException(String errorMessage) {
            super(errorMessage);
        }
    }

    public static class BookBean2 {
        private long id;
        private long id2;
        private long id3;

        public long getId() {
            return this.id;
        }

        @PathParam(value="id")
        public void setId(long id) {
            this.id = id;
        }

        public long getId2() {
            return this.id2;
        }

        @QueryParam(value="id2")
        public void setId2(long id2) {
            this.id2 = id2;
        }

        @Context
        public void setUriInfo(UriInfo ui) {
            String id3Value = (String)ui.getQueryParameters().getFirst((Object)"id3");
            if (id3Value != null) {
                this.id3 = Long.valueOf(id3Value);
            }
        }

        public long getId3() {
            return this.id3;
        }
    }

    public static class BookBeanNested {
        private long id4;

        public long getId4() {
            return this.id4;
        }

        @QueryParam(value="id4")
        public void setId4(long id4) {
            this.id4 = id4;
        }
    }

    public static class BookBean {
        private long id;
        private long id2;
        private long id3;

        public long getId() {
            return this.id;
        }

        @PathParam(value="id")
        public void setId(long id) {
            this.id = id;
        }

        public long getId2() {
            return this.id2;
        }

        @QueryParam(value="id_2")
        public void setId2(long id2) {
            this.id2 = id2;
        }

        @Context
        public void setUriInfo(UriInfo ui) {
            String id3Value = (String)ui.getQueryParameters().getFirst((Object)"id3");
            if (id3Value != null) {
                this.id3 = Long.valueOf(id3Value);
            }
        }

        public long getId3() {
            return this.id3;
        }
    }

    private class ResponseStreamingOutputImpl
    implements StreamingOutput {
        private ResponseStreamingOutputImpl() {
        }

        public void write(OutputStream output) throws IOException, WebApplicationException {
            BookStore.this.messageContext.put((Object)Message.RESPONSE_CODE, (Object)503);
            MetadataMap headers = new MetadataMap();
            headers.putSingle((Object)"Content-Type", (Object)"text/plain");
            headers.putSingle((Object)"CustomHeader", (Object)"CustomValue");
            BookStore.this.messageContext.put((Object)Message.PROTOCOL_HEADERS, (Object)headers);
            output.write("Response is not available".getBytes());
        }
    }

    private static class StreamingOutputImpl
    implements StreamingOutput {
        private boolean failEarly;

        public StreamingOutputImpl(boolean failEarly) {
            this.failEarly = failEarly;
        }

        public void write(OutputStream output) throws IOException, WebApplicationException {
            if (this.failEarly) {
                throw new WebApplicationException(Response.status((int)410).header("content-type", (Object)"text/plain").entity((Object)"This is supposed to go on the wire").build());
            }
            output.write("This is not supposed to go on the wire".getBytes());
            throw new WebApplicationException(410);
        }
    }

    static class BadBook {
        public BadBook(String s) {
            throw new RuntimeException("The bad book");
        }
    }

    public static class BookInfoAdapter
    extends XmlAdapter<Book, BookInfo> {
        public Book marshal(BookInfo v) throws Exception {
            return new Book(v.getName(), v.getId());
        }

        public BookInfo unmarshal(Book b) throws Exception {
            return new BookInfo(b);
        }
    }

    public static class BookInfoAdapter2
    extends XmlAdapter<Book, BookInfo2> {
        public Book marshal(BookInfo2 v) throws Exception {
            return new Book(v.getName(), v.getId());
        }

        public BookInfo2 unmarshal(Book b) throws Exception {
            return new BookInfo2(b);
        }
    }

    static class BookInfo2
    extends BookInfo
    implements BookInfoInterface {
        public BookInfo2() {
        }

        public BookInfo2(Book b) {
            super(b);
        }
    }

    static class BookInfo {
        private String name;
        private long id;

        public BookInfo() {
        }

        public BookInfo(Book b) {
            this.name = b.getName();
            this.id = b.getId();
            if (this.id == 0L) {
                this.id = 124L;
            }
        }

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }

        public Book asBook() {
            Book b = new Book();
            b.setId(this.id);
            b.setName(this.name);
            return b;
        }
    }

    @XmlJavaTypeAdapter(value=BookInfoAdapter2.class)
    static interface BookInfoInterface {
        public String getName();

        public long getId();
    }
}

