/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookNotFoundDetails;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;

@Path(value="/bookstore2")
public class BookStorePerRequest {
    private HttpHeaders httpHeaders;
    private Map<Long, Book> books = new HashMap<Long, Book>();
    private List<String> bookIds;
    private List<String> setterBookIds;

    public BookStorePerRequest() {
        throw new RuntimeException();
    }

    public BookStorePerRequest(@Context HttpHeaders headers) {
        throw new RuntimeException();
    }

    public BookStorePerRequest(@Context HttpHeaders headers, Long bar) {
        throw new RuntimeException();
    }

    public BookStorePerRequest(@Context HttpHeaders headers, @HeaderParam(value="BOOK") List<String> bookIds) {
        if (!bookIds.contains("3")) {
            throw new ClientErrorException(Response.status((int)400).type("text/plain").entity((Object)"Constructor: Header value 3 is required").build());
        }
        this.httpHeaders = headers;
        this.bookIds = bookIds;
        this.init();
    }

    @HeaderParam(value="Book")
    public void setBook(List<String> ids) {
        if (!ids.equals(this.bookIds) || ids.size() != 3) {
            throw new ClientErrorException(Response.status((int)400).type("text/plain").entity((Object)"Param setter: 3 header values are required").build());
        }
        this.setterBookIds = ids;
    }

    @Context
    public void setHttpHeaders(HttpHeaders headers) {
        List ids = this.httpHeaders.getRequestHeader("BOOK");
        if (ids.contains("4")) {
            throw new ClientErrorException(Response.status((int)400).type("text/plain").entity((Object)"Context setter: unexpected header value").build());
        }
    }

    @GET
    @Path(value="/bookheaders/")
    public Book getBookByHeader() throws Exception {
        List ids = this.httpHeaders.getRequestHeader("BOOK");
        if (!ids.equals(this.bookIds)) {
            throw new RuntimeException();
        }
        return this.doGetBook((String)ids.get(0) + (String)ids.get(1) + (String)ids.get(2));
    }

    @GET
    @Path(value="/bookheaders/injected")
    public Book getBookByHeaderInjected() throws Exception {
        return this.doGetBook(this.setterBookIds.get(0) + this.setterBookIds.get(1) + this.setterBookIds.get(2));
    }

    private Book doGetBook(String id) throws BookNotFoundFault {
        Book book = this.books.get(Long.parseLong(id));
        if (book != null) {
            return book;
        }
        BookNotFoundDetails details = new BookNotFoundDetails();
        details.setId(Long.parseLong(id));
        throw new BookNotFoundFault(details);
    }

    final void init() {
        Book book = new Book();
        book.setId(123L);
        book.setName("CXF in Action");
        this.books.put(book.getId(), book);
    }
}

