/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.annotations.Logging;
import org.apache.cxf.staxutils.DepthExceededStaxException;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.Book2;
import org.apache.cxf.systest.jaxrs.Books;
import org.apache.cxf.systest.jaxrs.RETRIEVE;
import org.apache.cxf.systest.jaxrs.RETRIEVE_get;
import org.apache.cxf.systest.jaxrs.SuperBook;

@Path(value="/")
@Produces(value={"application/json"})
@Logging
public class BookStoreSpring {
    private Map<Long, Book> books = new HashMap<Long, Book>();
    private Long mainId = 123L;
    @Context
    private UriInfo ui;
    private boolean postConstructCalled;

    public BookStoreSpring() {
        this.init();
    }

    @PostConstruct
    public void postConstruct() {
        this.postConstructCalled = true;
    }

    @PreDestroy
    public void preDestroy() {
    }

    @GET
    @Path(value="/books/webex")
    public Books getBookWebEx() {
        throw new WebApplicationException((Throwable)new RuntimeException("Book web exception"));
    }

    @GET
    @Path(value="/books/redirectStart")
    public Book getBookRedirectStart() {
        return new Book("Redirect start", 123L);
    }

    @GET
    @Path(value="/books/redirectComplete")
    public Book getBookRedirectComplete(@Context HttpServletRequest request) {
        Book book = (Book)request.getAttribute(Book.class.getSimpleName().toLowerCase());
        book.setName("Redirect complete: " + request.getRequestURI());
        return book;
    }

    @GET
    @Path(value="/books/webex2")
    public Books getBookWebEx2() {
        throw new InternalServerErrorException((Throwable)new RuntimeException("Book web exception"));
    }

    @GET
    @Path(value="/books/list/{id}")
    public Books getBookAsJsonList(@PathParam(value="id") Long id) {
        return new Books(this.books.get(id));
    }

    @GET
    @Path(value="/books/xsitype")
    @Produces(value={"application/xml"})
    public Book getBookXsiType() {
        return new SuperBook("SuperBook", 999L, true);
    }

    @GET
    @Path(value="/books/superbook")
    @Produces(value={"application/json"})
    public <T extends Book> T getSuperBookJson() {
        SuperBook book = new SuperBook("SuperBook", 999L, true);
        return (T)book;
    }

    @GET
    @Path(value="/books/superbooks")
    @Produces(value={"application/json"})
    public <T extends Book> List<T> getSuperBookCollectionJson() {
        SuperBook book = new SuperBook("SuperBook", 999L, true);
        return Collections.singletonList(book);
    }

    @POST
    @Path(value="/books/superbook")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public <T extends Book> T echoSuperBookJson(T book) {
        if (((SuperBook)book).isSuperBook()) {
            return book;
        }
        throw new WebApplicationException(400);
    }

    @POST
    @Path(value="/books/superbooks")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public <T extends Book> List<T> echoSuperBookCollectionJson(List<T> book) {
        if (((SuperBook)book.get(0)).isSuperBook()) {
            return book;
        }
        throw new WebApplicationException(400);
    }

    @POST
    @Path(value="/books/xsitype")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public Book postGetBookXsiType(Book book) {
        return book;
    }

    @GET
    @Path(value="/books/{id}")
    @Produces(value={"application/json", "application/vnd.example-com.foo+json"})
    public Book getBookById(@PathParam(value="id") Long id) {
        return this.books.get(id);
    }

    @GET
    @Path(value="/bookstore/books/{id}")
    @Produces(value={"application/xml"})
    public Book getBookXml(@PathParam(value="id") Long id) {
        return this.books.get(id);
    }

    @GET
    @Path(value="/semicolon{id}")
    @Produces(value={"application/xml"})
    public Book getBookWithSemicoln(@PathParam(value="id") String name) {
        return new Book(name, 333L);
    }

    @GET
    @Path(value="/ISO-8859-1/1")
    @Produces(value={"application/json;charset=ISO-8859-1", "application/xml;charset=ISO-8859-1"})
    public Book getBookISO() throws Exception {
        String eWithAcute = "\u00e9";
        String helloStringUTF16 = "F" + eWithAcute + "lix";
        byte[] iso88591bytes = helloStringUTF16.getBytes("ISO-8859-1");
        String helloStringISO88591 = new String(iso88591bytes, "ISO-8859-1");
        return new Book(helloStringISO88591, 333L);
    }

    @GET
    @Path(value="/ISO-8859-1/2")
    @Produces(value={"application/json", "application/xml"})
    public Book getBookISO2() throws Exception {
        return this.getBookISO();
    }

    @GET
    @Path(value="/semicolon2{id}")
    @Produces(value={"application/xml"})
    public Book getBookWithSemicolnAndMatrixParam(@PathParam(value="id") String name, @MatrixParam(value="a") String matrixParam) {
        return new Book(name + matrixParam, 333L);
    }

    @GET
    @Path(value="/bookinfo")
    public Book getBookByUriInfo() throws Exception {
        MultivaluedMap params = this.ui.getQueryParameters();
        String id = (String)params.getFirst((Object)"param1") + (String)params.getFirst((Object)"param2");
        return this.books.get(Long.valueOf(id));
    }

    @GET
    @Path(value="/booksquery")
    public Book getBookByQuery(@QueryParam(value="id") String id) {
        if (!this.postConstructCalled) {
            throw new RuntimeException();
        }
        String[] values = id.split("\\+");
        StringBuilder b = new StringBuilder();
        b.append(values[0]).append(values[1]);
        return this.books.get(Long.valueOf(b.toString()));
    }

    @GET
    @Path(value="id={id}")
    public Book getBookByEncodedId(@PathParam(value="id") String id) {
        String[] values = id.split("\\+");
        StringBuilder b = new StringBuilder();
        b.append(values[0]).append(values[1]);
        return this.books.get(Long.valueOf(b.toString()));
    }

    @GET
    public Book getDefaultBook() {
        return this.books.get(this.mainId);
    }

    @POST
    @Path(value="depth")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Book echoBook(Book book) {
        return book;
    }

    @POST
    @Path(value="depth-source")
    @Consumes(value={"application/xml"})
    public void postSourceBook(Source source) {
        block3: {
            try {
                StaxUtils.copy((Source)source, (OutputStream)new ByteArrayOutputStream());
            }
            catch (DepthExceededStaxException ex) {
                throw new WebApplicationException(413);
            }
            catch (XMLStreamException ex) {
                if (!ex.getMessage().startsWith("Maximum Number")) break block3;
                throw new WebApplicationException(413);
            }
        }
        throw new WebApplicationException(500);
    }

    @POST
    @Path(value="depth-dom")
    @Consumes(value={"application/xml"})
    public void postDomBook(DOMSource source) {
    }

    @POST
    @Path(value="depth-form")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void depthForm(MultivaluedMap<String, String> map) {
    }

    @POST
    @Path(value="books/convert")
    @Consumes(value={"application/xml", "application/json", "application/vnd.example-com.foo+json"})
    @Produces(value={"application/xml", "application/vnd.example-com.foo+json"})
    public Book convertBook(Book2 book) {
        Book b = new Book();
        b.setId(book.getId());
        b.setName(book.getName());
        return b;
    }

    @PUT
    @Path(value="books/convert2/{id}")
    @Consumes(value={"application/xml", "application/json", "application/jettison"})
    @Produces(value={"application/xml"})
    public Book convertBook2(Book2 book) {
        return this.convertBook(book);
    }

    @GET
    @Path(value="books/aegis")
    @Produces(value={"application/html;q=1.0", "application/xml;q=0.5", "application/json;q=0.5"})
    public Book getBookAegis() {
        Book b = new Book();
        b.setId(124L);
        b.setName("CXF in Action - 2");
        return b;
    }

    @RETRIEVE
    @Path(value="books/aegis/retrieve")
    @Produces(value={"application/html;q=0.5", "application/xml;q=1.0", "application/json;q=0.5"})
    public Book getBookAegisRetrieve() {
        return this.getBookAegis();
    }

    @RETRIEVE_get
    @Path(value="books/aegis/retrieve/get")
    @Produces(value={"application/html;q=0.5", "application/xml;q=1.0", "application/json;q=0.5"})
    public Book getBookAegisRetrieveGet() {
        return this.getBookAegis();
    }

    @GET
    @Path(value="books/xslt/{id}")
    @Produces(value={"text/html", "application/xhtml+xml", "application/xml"})
    public Book getBookXSLT(@PathParam(value="id") long id, @QueryParam(value="name") String name, @MatrixParam(value="name2") String name2) {
        Book b = new Book();
        b.setId(999L);
        b.setName("CXF in ");
        return b;
    }

    final void init() {
        Book book = new Book();
        book.setId(this.mainId);
        book.setName("CXF in Action");
        this.books.put(book.getId(), book);
    }
}

