/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.systest.jaxrs.BookServerProxySpring;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSClientServerProxySpringBookTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookServerProxySpring.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        AbstractResourceInfo.clearAllMaps();
        JAXRSClientServerProxySpringBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerProxySpringBookTest.launchServer(BookServerProxySpring.class, (boolean)true));
        JAXRSClientServerProxySpringBookTest.createStaticBus();
    }

    @Test
    public void testGetBookNotFound() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/test/bookstore/books/12345";
        URL url = new URL(endpointAddress);
        HttpURLConnection connect = (HttpURLConnection)url.openConnection();
        connect.addRequestProperty("Accept", "text/plain,application/xml");
        JAXRSClientServerProxySpringBookTest.assertEquals((long)500L, (long)connect.getResponseCode());
        InputStream in = connect.getErrorStream();
        JAXRSClientServerProxySpringBookTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book_notfound_mapped.txt");
        JAXRSClientServerProxySpringBookTest.assertEquals((String)"Exception is not mapped correctly", (Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(expected).trim()), (Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(in).trim()));
    }

    @Test
    public void testGetThatBook123() throws Exception {
        this.getBook("http://localhost:" + PORT + "/test/bookstorestorage/thosebooks/123");
    }

    @Test
    public void testGetThatBookSingleton() throws Exception {
        this.getBook("http://localhost:" + PORT + "/test/4/bookstore/books/123");
        this.getBook("http://localhost:" + PORT + "/test/4/bookstore/books/123");
    }

    @Test
    public void testGetThatBookInterfaceSingleton() throws Exception {
        this.getBook("http://localhost:" + PORT + "/test/4/bookstorestorage/thosebooks/123");
    }

    @Test
    public void testGetThatBookPrototype() throws Exception {
        this.getBook("http://localhost:" + PORT + "/test/5/bookstore/books/123");
    }

    @Test
    public void testGetThatBookInterfacePrototype() throws Exception {
        this.getBook("http://localhost:" + PORT + "/test/5/bookstorestorage/thosebooks/123");
    }

    @Test
    public void testGetThatBookInterface2Prototype() throws Exception {
        this.getBook("http://localhost:" + PORT + "/test/6/bookstorestorage/thosebooks/123");
    }

    @Test
    public void testGetThatBook123UserResource() throws Exception {
        this.getBook("http://localhost:" + PORT + "/test/2/bookstore/books/123");
    }

    @Test
    public void testGetThatBook123UserResourceInterface() throws Exception {
        this.getBook("http://localhost:" + PORT + "/test/3/bookstore2/books/123");
    }

    private void getBook(String endpointAddress) throws Exception {
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Content-Type", "*/*");
        connect.addRequestProperty("Accept", "application/xml");
        connect.addRequestProperty("SpringProxy", "true");
        InputStream in = connect.getInputStream();
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123.txt");
        JAXRSClientServerProxySpringBookTest.assertEquals((Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(expected)), (Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(in)));
    }

    @Test
    public void testGetThatBookOverloaded() throws Exception {
        this.getBook("http://localhost:" + PORT + "/test/bookstorestorage/thosebooks/123/123");
    }

    @Test
    public void testGetThatBookOverloaded2() throws Exception {
        this.getBook("http://localhost:" + PORT + "/test/bookstorestorage/thosebooks");
    }

    @Test
    public void testGetBook123() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/test/bookstore/books/123";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/json");
        InputStream in = connect.getInputStream();
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123json.txt");
        JAXRSClientServerProxySpringBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
    }

    @Test
    public void testGetName() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/test/v1/names/1";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"application/json"});
        String name = (String)wc.get(String.class);
        JAXRSClientServerProxySpringBookTest.assertEquals((Object)"{\"name\":\"Barry\"}", (Object)name);
    }

    @Test
    public void testPutName() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/test/v1/names/1";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.type("application/json").accept(new String[]{"application/json"});
        String id = (String)wc.put(null, String.class);
        JAXRSClientServerProxySpringBookTest.assertEquals((Object)"1", (Object)id);
    }

    @Test
    public void testGetBookWithRequestScope() {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/test/request/bookstore/booksecho2"));
        wc.type("text/plain").accept(new String[]{"text/plain"});
        wc.header("CustomHeader", new Object[]{"custom-header"});
        String value = (String)wc.post((Object)"CXF", String.class);
        JAXRSClientServerProxySpringBookTest.assertEquals((Object)"CXF", (Object)value);
        JAXRSClientServerProxySpringBookTest.assertEquals((Object)"custom-header", (Object)wc.getResponse().getMetadata().getFirst((Object)"CustomHeader"));
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        String str = new String(bos.getBytes());
        in.close();
        bos.close();
        return str;
    }

    private String stripXmlInstructionIfNeeded(String str) {
        if (str != null && str.startsWith("<?xml")) {
            int index = str.indexOf("?>");
            str = str.substring(index + 2);
        }
        return str;
    }
}

