/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.systest.jaxrs.BookServerResourceCreatedOutside;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSClientServerResourceCreatedOutsideBookTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookServerResourceCreatedOutside.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        AbstractResourceInfo.clearAllMaps();
        JAXRSClientServerResourceCreatedOutsideBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerResourceCreatedOutsideBookTest.launchServer(BookServerResourceCreatedOutside.class, (boolean)true));
        JAXRSClientServerResourceCreatedOutsideBookTest.createStaticBus();
    }

    @Test
    public void testGetBook123() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/books/123";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/xml");
        InputStream in = connect.getInputStream();
        JAXRSClientServerResourceCreatedOutsideBookTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123.txt");
        JAXRSClientServerResourceCreatedOutsideBookTest.assertEquals((Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(expected)), (Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(in)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddBookHTTPURL() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/books";
        URL url = new URL(endpointAddress);
        HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
        httpUrlConnection.setUseCaches(false);
        httpUrlConnection.setDefaultUseCaches(false);
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setDoInput(true);
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setRequestProperty("Accept", "text/xml");
        httpUrlConnection.setRequestProperty("Content-type", "application/xml");
        httpUrlConnection.setRequestProperty("Connection", "close");
        OutputStream outputstream = httpUrlConnection.getOutputStream();
        File inputFile = new File(((Object)((Object)this)).getClass().getResource("resources/add_book.txt").toURI());
        byte[] tmp = new byte[4096];
        int i = 0;
        FileInputStream is = new FileInputStream(inputFile);
        try {
            while ((i = ((InputStream)is).read(tmp)) >= 0) {
                outputstream.write(tmp, 0, i);
            }
        }
        finally {
            ((InputStream)is).close();
        }
        outputstream.flush();
        int responseCode = httpUrlConnection.getResponseCode();
        JAXRSClientServerResourceCreatedOutsideBookTest.assertEquals((long)200L, (long)responseCode);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_add_book.txt");
        JAXRSClientServerResourceCreatedOutsideBookTest.assertEquals((Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(expected)), (Object)this.stripXmlInstructionIfNeeded(this.getStringFromInputStream(httpUrlConnection.getInputStream())));
        httpUrlConnection.disconnect();
    }

    private String stripXmlInstructionIfNeeded(String str) {
        if (str != null && str.startsWith("<?xml")) {
            int index = str.indexOf("?>");
            str = str.substring(index + 2);
        }
        return str;
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        String str = new String(bos.getBytes());
        in.close();
        bos.close();
        return str;
    }
}

