/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookServerResourceJacksonSpringProviders;
import org.apache.cxf.systest.jaxrs.BookStoreSpring;
import org.apache.cxf.systest.jaxrs.GenericBookStoreSpring;
import org.apache.cxf.systest.jaxrs.GenericBookStoreSpring2;
import org.apache.cxf.systest.jaxrs.MultipartStore;
import org.apache.cxf.systest.jaxrs.SuperBook;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSClientServerResourceJacksonSpringProviderTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookServerResourceJacksonSpringProviders.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        AbstractResourceInfo.clearAllMaps();
        JAXRSClientServerResourceJacksonSpringProviderTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerResourceJacksonSpringProviderTest.launchServer(BookServerResourceJacksonSpringProviders.class, (boolean)true));
        JAXRSClientServerResourceJacksonSpringProviderTest.createStaticBus();
    }

    @Test
    public void testGetBook123() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/store1/bookstore/books/123";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/json");
        InputStream in = connect.getInputStream();
        JAXRSClientServerResourceJacksonSpringProviderTest.assertNotNull((Object)in);
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((String)"Jackson output not correct", (Object)"{\"class\":\"org.apache.cxf.systest.jaxrs.Book\",\"name\":\"CXF in Action\",\"id\":123}", (Object)this.getStringFromInputStream(in).trim());
    }

    @Test
    public void testGetSuperBookProxy() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/store2";
        BookStoreSpring proxy = (BookStoreSpring)JAXRSClientFactory.create((String)endpointAddress, BookStoreSpring.class, Collections.singletonList(new JacksonJsonProvider()));
        SuperBook book = (SuperBook)proxy.getSuperBookJson();
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)999L, (long)book.getId());
    }

    @Test
    public void testMultipart() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/multipart";
        MultipartStore proxy = (MultipartStore)JAXRSClientFactory.create((String)endpointAddress, MultipartStore.class, Collections.singletonList(new JacksonJsonProvider()));
        Book json = new Book("json", 1L);
        InputStream is1 = ((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/java.jpg");
        Map<String, Object> attachments = proxy.addBookJsonImageStream(json, is1);
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)2L, (long)attachments.size());
        Book json2 = (Book)((Attachment)attachments.get("application/json")).getObject(Book.class);
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((Object)"json", (Object)json2.getName());
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)1L, (long)json2.getId());
        InputStream is2 = (InputStream)((Attachment)attachments.get("application/octet-stream")).getObject(InputStream.class);
        byte[] image1 = IOUtils.readBytesFromStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cxf/systest/jaxrs/resources/java.jpg"));
        byte[] image2 = IOUtils.readBytesFromStream((InputStream)is2);
        JAXRSClientServerResourceJacksonSpringProviderTest.assertTrue((boolean)Arrays.equals(image1, image2));
    }

    @Test
    public void testGetSuperBookCollectionProxy() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/store2";
        BookStoreSpring proxy = (BookStoreSpring)JAXRSClientFactory.create((String)endpointAddress, BookStoreSpring.class, Collections.singletonList(new JacksonJsonProvider()));
        List books = proxy.getSuperBookCollectionJson();
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)999L, (long)((SuperBook)books.get(0)).getId());
    }

    @Test
    public void testEchoSuperBookCollectionProxy() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/store2";
        BookStoreSpring proxy = (BookStoreSpring)JAXRSClientFactory.create((String)endpointAddress, BookStoreSpring.class, Collections.singletonList(new JacksonJsonProvider()));
        WebClient.getConfig((Object)proxy).getHttpConduit().getClient().setReceiveTimeout(10000000L);
        List<SuperBook> books = proxy.echoSuperBookCollectionJson(Collections.singletonList(new SuperBook("Super", 124L, true)));
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)124L, (long)books.get(0).getId());
        JAXRSClientServerResourceJacksonSpringProviderTest.assertTrue((boolean)books.get(0).isSuperBook());
    }

    @Test
    public void testEchoSuperBookProxy() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/store2";
        BookStoreSpring proxy = (BookStoreSpring)JAXRSClientFactory.create((String)endpointAddress, BookStoreSpring.class, Collections.singletonList(new JacksonJsonProvider()));
        SuperBook book = proxy.echoSuperBookJson(new SuperBook("Super", 124L, true));
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)124L, (long)book.getId());
        JAXRSClientServerResourceJacksonSpringProviderTest.assertTrue((boolean)book.isSuperBook());
    }

    @Test
    public void testEchoGenericSuperBookCollectionProxy() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/custombus/genericstore";
        GenericBookStoreSpring proxy = (GenericBookStoreSpring)JAXRSClientFactory.create((String)endpointAddress, GenericBookStoreSpring.class, Collections.singletonList(new JacksonJsonProvider()));
        List<SuperBook> books = proxy.echoSuperBookCollectionJson(Collections.singletonList(new SuperBook("Super", 124L, true)));
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)124L, (long)books.get(0).getId());
        JAXRSClientServerResourceJacksonSpringProviderTest.assertTrue((boolean)books.get(0).isSuperBook());
    }

    @Test
    public void testEchoGenericSuperBookProxy() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/custombus/genericstore";
        GenericBookStoreSpring proxy = (GenericBookStoreSpring)JAXRSClientFactory.create((String)endpointAddress, GenericBookStoreSpring.class, Collections.singletonList(new JacksonJsonProvider()));
        WebClient.getConfig((Object)proxy).getHttpConduit().getClient().setReceiveTimeout(1000000000L);
        SuperBook book = proxy.echoSuperBookJson(new SuperBook("Super", 124L, true));
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)124L, (long)book.getId());
        JAXRSClientServerResourceJacksonSpringProviderTest.assertTrue((boolean)book.isSuperBook());
    }

    @Test
    public void testEchoGenericSuperBookProxy2() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/genericstore2";
        GenericBookStoreSpring2 proxy = (GenericBookStoreSpring2)JAXRSClientFactory.create((String)endpointAddress, GenericBookStoreSpring2.class, Collections.singletonList(new JacksonJsonProvider()));
        WebClient.getConfig((Object)proxy).getHttpConduit().getClient().setReceiveTimeout(1000000000L);
        SuperBook book = proxy.echoSuperBookJson(new SuperBook("Super", 124L, true));
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)124L, (long)book.getId());
        JAXRSClientServerResourceJacksonSpringProviderTest.assertTrue((boolean)book.isSuperBook());
    }

    @Test
    public void testEchoGenericSuperBookCollectionProxy2() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/genericstore2";
        GenericBookStoreSpring2 proxy = (GenericBookStoreSpring2)JAXRSClientFactory.create((String)endpointAddress, GenericBookStoreSpring2.class, Collections.singletonList(new JacksonJsonProvider()));
        List<SuperBook> books = proxy.echoSuperBookCollectionJson(Collections.singletonList(new SuperBook("Super", 124L, true)));
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)124L, (long)books.get(0).getId());
        JAXRSClientServerResourceJacksonSpringProviderTest.assertTrue((boolean)books.get(0).isSuperBook());
    }

    @Test
    public void testEchoGenericSuperBookWebClient() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/custombus/genericstore/books/superbook";
        WebClient wc = WebClient.create((String)endpointAddress, Collections.singletonList(new JacksonJsonProvider()));
        wc.accept(new String[]{"application/json"}).type("application/json");
        SuperBook book = (SuperBook)wc.post((Object)new SuperBook("Super", 124L, true), SuperBook.class);
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)124L, (long)book.getId());
        JAXRSClientServerResourceJacksonSpringProviderTest.assertTrue((boolean)book.isSuperBook());
    }

    @Test
    public void testEchoGenericSuperBookWebClientXml() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/custombus/genericstore/books/superbook";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"application/xml"}).type("application/xml");
        SuperBook book = (SuperBook)wc.post((Object)new SuperBook("Super", 124L, true), SuperBook.class);
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)124L, (long)book.getId());
        JAXRSClientServerResourceJacksonSpringProviderTest.assertTrue((boolean)book.isSuperBook());
    }

    @Test
    public void testEchoGenericSuperBookCollectionWebClient() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/custombus/genericstore/books/superbooks";
        WebClient wc = WebClient.create((String)endpointAddress, Collections.singletonList(new JacksonJsonProvider()));
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setReceiveTimeout(100000000L);
        wc.accept(new String[]{"application/json"}).type("application/json");
        Collection books = wc.postAndGetCollection(Collections.singletonList(new SuperBook("Super", 124L, true)), SuperBook.class, SuperBook.class);
        SuperBook book = (SuperBook)books.iterator().next();
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)124L, (long)book.getId());
        JAXRSClientServerResourceJacksonSpringProviderTest.assertTrue((boolean)book.isSuperBook());
    }

    @Test
    public void testGetGenericSuperBookCollectionWebClient() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/custombus/genericstore/books/superbooks2";
        WebClient wc = WebClient.create((String)endpointAddress, Collections.singletonList(new JacksonJsonProvider()));
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setReceiveTimeout(100000000L);
        wc.accept(new String[]{"application/json"});
        List books = (List)wc.get((GenericType)new GenericType<List<SuperBook>>(){});
        SuperBook book = (SuperBook)books.iterator().next();
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)124L, (long)book.getId());
        JAXRSClientServerResourceJacksonSpringProviderTest.assertTrue((boolean)book.isSuperBook());
    }

    @Test
    public void testEchoGenericSuperBookCollectionWebClientXml() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/custombus/genericstore/books/superbooks";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"application/xml"}).type("application/xml");
        Collection books = wc.postAndGetCollection(Collections.singletonList(new SuperBook("Super", 124L, true)), SuperBook.class, SuperBook.class);
        SuperBook book = (SuperBook)books.iterator().next();
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)124L, (long)book.getId());
        JAXRSClientServerResourceJacksonSpringProviderTest.assertTrue((boolean)book.isSuperBook());
    }

    @Test
    public void testGetCollectionOfBooks() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/store1/bookstore/collections";
        WebClient wc = WebClient.create((String)endpointAddress, Collections.singletonList(new JacksonJsonProvider()));
        wc.accept(new String[]{"application/json"});
        Collection collection = wc.getCollection(Book.class);
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)1L, (long)collection.size());
        Book book = (Book)collection.iterator().next();
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testGetCollectionOfSuperBooks() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/webapp/store2/books/superbooks";
        WebClient wc = WebClient.create((String)endpointAddress, Collections.singletonList(new JacksonJsonProvider()));
        wc.accept(new String[]{"application/json"});
        Collection collection = wc.getCollection(Book.class);
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)1L, (long)collection.size());
        Book book = (Book)collection.iterator().next();
        JAXRSClientServerResourceJacksonSpringProviderTest.assertEquals((long)999L, (long)book.getId());
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        return IOUtils.toString((InputStream)in);
    }
}

