/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.xml.bind.JAXBContext;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.provider.atom.AtomEntryProvider;
import org.apache.cxf.jaxrs.provider.atom.AtomFeedProvider;
import org.apache.cxf.management.web.logging.LogLevel;
import org.apache.cxf.management.web.logging.LogRecord;
import org.apache.cxf.management.web.logging.ReadWriteLogStorage;
import org.apache.cxf.management.web.logging.ReadableLogStorage;
import org.apache.cxf.management.web.logging.atom.AtomPullServer;
import org.apache.cxf.systest.jaxrs.AbstractSpringServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSLoggingAtomPullSpringTest
extends AbstractBusClientServerTestBase {
    public static final int PORT = SpringServer.PORT;
    private static JAXBContext context;
    private int fakyLogger;
    private int namedLogger;
    private int resourceLogger;
    private int throwables;
    private int errorLevels;
    private int traceLevels;
    private int infoLevels;
    private int debugLevels;
    private int warningLevels;

    @BeforeClass
    public static void beforeClass() throws Exception {
        new Resource();
        new Resource2();
        new Resource3();
        String resourceDir = JAXRSLoggingAtomPullSpringTest.class.getResource("resources").toURI().getPath();
        System.setProperty("systemtests.jaxrs.logs.folder", resourceDir);
        JAXRSLoggingAtomPullSpringTest.launchServer(SpringServer.class, (boolean)true);
        context = JAXBContext.newInstance((Class[])new Class[]{LogRecord.class});
        JAXRSLoggingAtomPullSpringTest.createStaticBus();
        System.clearProperty("systemtests.jaxrs.logs.folder");
    }

    @Before
    public void before() throws Exception {
        Storage.clearRecords();
    }

    @Test
    public void testFeed() throws Exception {
        String listing = (String)WebClient.create((String)("http://localhost:" + PORT + "/services")).get(String.class);
        JAXRSLoggingAtomPullSpringTest.assertTrue((String)listing, (boolean)listing.contains("http://localhost:" + PORT + "/atom/logs"));
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/resource/root"));
        wc.path((Object)"/log").get();
        Thread.sleep(3000L);
        this.checkSimpleFeed(this.getFeed("http://localhost:" + PORT + "/atom/logs").getEntries());
        this.checkSimpleFeed(this.getFeed("http://localhost:" + PORT + "/atom/logs").getEntries());
        LinkedList<Entry> entries = new LinkedList<Entry>();
        WebClient wcEntry = WebClient.create((String)("http://localhost:" + PORT + "/atom/logs"), Collections.singletonList(new AtomEntryProvider())).accept(new String[]{"application/atom+xml;type=entry"});
        for (int i = 0; i < 8; ++i) {
            Entry entry = (Entry)wcEntry.path((Object)("entry/" + i)).get(Entry.class);
            entry.toString();
            entries.add(entry);
            wcEntry.back(true);
        }
        this.checkSimpleFeed(entries);
    }

    private void checkSimpleFeed(List<Entry> entries) throws Exception {
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)8L, (long)entries.size());
        this.resetCounters();
        for (Entry e : entries) {
            this.updateCounters(this.readLogRecord(e.getContent()), "Resource", "namedLogger");
        }
        this.verifyCounters();
    }

    @Test
    public void testPagedFeed() throws Exception {
        WebClient wcReset = WebClient.create((String)("http://localhost:" + PORT + "/reset"));
        wcReset.post(null);
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/resource2/paged"));
        wc.path((Object)"/log").get();
        Thread.sleep(3000L);
        this.verifyPages("http://localhost:" + PORT + "/atom2/logs", "next", 3, 2, "theNamedLogger");
        this.verifyPages("http://localhost:" + PORT + "/atom2/logs/3", "previous", 2, 3, "theNamedLogger");
    }

    @Test
    public void testPagedFeedWithQuery() throws Exception {
        WebClient wcReset = WebClient.create((String)("http://localhost:" + PORT + "/reset"));
        wcReset.post(null);
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/resource2/paged/log"));
        wc.get();
        Thread.sleep(3000L);
        String address = "http://localhost:" + PORT + "/atom2/logs" + "?_s=level==INFO,level==ERROR,level==WARN";
        this.verifyPagesWithQuery(address, "next", 3, 2, "Resource2", "theNamedLogger");
        this.verifyPagesWithQuery(address, "next", 3, 2, "Resource2", "theNamedLogger");
    }

    @Test
    public void testPagedFeedWithReadWriteStorage() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/resource3/storage"));
        wc.path((Object)"/log").get();
        Thread.sleep(3000L);
        this.verifyStoragePages("http://localhost:" + PORT + "/atom3/logs", "next", "Resource3", "theStorageLogger", false);
        List<LogRecord> list = Storage.getRecords();
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)4L, (long)list.size());
        this.verifyStoragePages("http://localhost:" + PORT + "/atom3/logs", "next", "Resource3", "theStorageLogger", false);
        this.verifyStoragePages("http://localhost:" + PORT + "/atom3/logs/2", "previous", "Resource3", "theStorageLogger", false);
    }

    @Test
    public void testPagedFeedWithReadOnlyStorage() throws Exception {
        this.verifyStoragePages("http://localhost:" + PORT + "/atom4/logs", "next", "Resource4", "readOnlyStorageLogger", true);
        this.verifyStoragePages("http://localhost:" + PORT + "/atom4/logs/2", "previous", "Resource4", "readOnlyStorageLogger", true);
    }

    @Test
    public void testPagedFeedWithReadonlyStorageAngQuery() throws Exception {
        this.checkInfoLevelOnly();
        this.checkDebugLevelOnly();
        this.checkInfoLevelOnly();
        this.checkDebugLevelOnly();
        this.checkInfoOrDebugLevel();
    }

    private void checkInfoLevelOnly() throws Exception {
        String address = "http://localhost:" + PORT + "/atom5/logs" + "?_s=level==INFO";
        ArrayList<Entry> entries = new ArrayList<Entry>();
        String href1 = this.fillPagedEntries(entries, address, 1, "next", true);
        this.resetCounters();
        for (Entry e : entries) {
            this.updateCounters(this.readLogRecord(e.getContent()), "", "");
        }
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.errorLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)1L, (long)this.infoLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.debugLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.traceLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.warningLevels);
        entries.clear();
        this.fillPagedEntries(entries, href1, 0, "next", false);
    }

    private void checkInfoOrDebugLevel() throws Exception {
        String address = "http://localhost:" + PORT + "/atom5/logs" + "?_s=level==INFO,level==DEBUG";
        ArrayList<Entry> entries = new ArrayList<Entry>();
        String href1 = this.fillPagedEntries(entries, address, 1, "next", true);
        this.resetCounters();
        for (Entry e : entries) {
            this.updateCounters(this.readLogRecord(e.getContent()), "", "");
        }
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.errorLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)1L, (long)this.infoLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.debugLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.traceLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.warningLevels);
        entries.clear();
        String href2 = this.fillPagedEntries(entries, href1, 1, "next", true);
        this.resetCounters();
        for (Entry e : entries) {
            this.updateCounters(this.readLogRecord(e.getContent()), "", "");
        }
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.errorLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.infoLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)1L, (long)this.debugLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.traceLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.warningLevels);
        entries.clear();
        this.fillPagedEntries(entries, href2, 0, "next", false);
    }

    private void checkDebugLevelOnly() throws Exception {
        String address = "http://localhost:" + PORT + "/atom5/logs" + "?_s=level==DEBUG";
        ArrayList<Entry> entries = new ArrayList<Entry>();
        String href1 = this.fillPagedEntries(entries, address, 1, "next", true);
        this.resetCounters();
        for (Entry e : entries) {
            this.updateCounters(this.readLogRecord(e.getContent()), "", "");
        }
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.errorLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.infoLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)1L, (long)this.debugLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.traceLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.warningLevels);
        entries.clear();
        this.fillPagedEntries(entries, href1, 0, "next", false);
    }

    private void verifyStoragePages(String startAddress, String rel, String resourceName, String nLogger, boolean readOnly) throws Exception {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        String href1 = this.fillPagedEntries(entries, startAddress, 4, rel, true);
        this.fillPagedEntries(entries, href1, 4, rel, "next".equals(rel) && readOnly);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)8L, (long)entries.size());
        this.resetCounters();
        for (Entry e : entries) {
            this.updateCounters(this.readLogRecord(e.getContent()), resourceName, nLogger);
        }
        if ("Resource4".equals(resourceName)) {
            JAXRSLoggingAtomPullSpringTest.assertEquals((long)1L, (long)this.throwables);
            JAXRSLoggingAtomPullSpringTest.assertEquals((long)6L, (long)this.resourceLogger);
            JAXRSLoggingAtomPullSpringTest.assertEquals((long)2L, (long)this.namedLogger);
            JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.fakyLogger);
        } else {
            this.verifyCounters();
        }
    }

    private void verifyPages(String startAddress, String rel, int firstValue, int lastValue, String nLogger) throws Exception {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        String href1 = this.fillPagedEntries(entries, startAddress, firstValue, rel, true);
        String href2 = this.fillPagedEntries(entries, href1, 3, rel, true);
        this.fillPagedEntries(entries, href2, lastValue, rel, false);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)8L, (long)entries.size());
        this.resetCounters();
        for (Entry e : entries) {
            this.updateCounters(this.readLogRecord(e.getContent()), "Resource2", nLogger);
        }
        this.verifyCounters();
    }

    private void verifyPagesWithQuery(String startAddress, String rel, int firstValue, int lastValue, String resourceName, String nLogger) throws Exception {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        String hrefRel = this.fillPagedEntries(entries, startAddress, firstValue, rel, true);
        hrefRel = this.fillPagedEntries(entries, hrefRel, lastValue, rel, false);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)(firstValue + lastValue), (long)entries.size());
        this.resetCounters();
        for (Entry e : entries) {
            this.updateCounters(this.readLogRecord(e.getContent()), "Resource2", nLogger);
        }
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)3L, (long)this.errorLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)1L, (long)this.infoLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.debugLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)0L, (long)this.traceLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)1L, (long)this.warningLevels);
    }

    private String fillPagedEntries(List<Entry> entries, String href, int expected, String rel, boolean relExpected) {
        Feed feed = this.getFeed(href);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)expected, (long)feed.getEntries().size());
        entries.addAll(feed.getEntries());
        Link link = feed.getLink(rel);
        if (relExpected) {
            JAXRSLoggingAtomPullSpringTest.assertNotNull((Object)link);
            return link.getHref().toString();
        }
        JAXRSLoggingAtomPullSpringTest.assertNull((Object)link);
        return null;
    }

    private Feed getFeed(String address) {
        WebClient wc = WebClient.create((String)address, Collections.singletonList(new AtomFeedProvider()));
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setReceiveTimeout(10000000L);
        Feed feed = (Feed)wc.accept(new String[]{"application/atom+xml"}).get(Feed.class);
        feed.toString();
        return feed;
    }

    private static void doLog(Logger l1, Logger l2) {
        l1.severe("severe message");
        l1.warning("warning message");
        l1.info("info message");
        java.util.logging.LogRecord r = new java.util.logging.LogRecord(Level.FINE, "fine message");
        if ("Resource4".equals(l1.getName())) {
            r.setLoggerName(l1.getName());
        }
        r.setThrown(new IllegalArgumentException("tadaam"));
        l1.log(r);
        r = new java.util.logging.LogRecord(Level.FINER, "finer message with {0} and {1}");
        r.setParameters(new Object[]{"param1", "param2"});
        r.setLoggerName("faky-logger");
        l1.log(r);
        l1.finest("finest message");
        l2.severe("severe message");
        l2.severe("severe message2");
        l2.info("info message - should not pass!");
        l2.finer("finer message - should not pass!");
    }

    private LogRecord readLogRecord(String value) throws Exception {
        return (LogRecord)context.createUnmarshaller().unmarshal((Reader)new StringReader(value));
    }

    private void updateCounters(LogRecord record, String clsName, String namedLoggerName) {
        LogLevel level;
        String name = record.getLoggerName();
        if (name != null && name.length() > 0) {
            if (("org.apache.cxf.systest.jaxrs.JAXRSLoggingAtomPullSpringTest$" + clsName).equals(name)) {
                ++this.resourceLogger;
            } else if (namedLoggerName.equals(name)) {
                ++this.namedLogger;
            } else if ("faky-logger".equals(name)) {
                ++this.fakyLogger;
            }
        }
        if (record.getThrowable().length() > 0) {
            ++this.throwables;
        }
        if ((level = record.getLevel()) == LogLevel.ERROR) {
            ++this.errorLevels;
        } else if (level == LogLevel.DEBUG) {
            ++this.debugLevels;
        } else if (level == LogLevel.TRACE) {
            ++this.traceLevels;
        } else if (level == LogLevel.INFO) {
            ++this.infoLevels;
        } else {
            ++this.warningLevels;
        }
    }

    private void resetCounters() {
        this.fakyLogger = 0;
        this.namedLogger = 0;
        this.resourceLogger = 0;
        this.throwables = 0;
        this.errorLevels = 0;
        this.infoLevels = 0;
        this.debugLevels = 0;
        this.traceLevels = 0;
        this.warningLevels = 0;
    }

    private void verifyCounters() {
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)1L, (long)this.throwables);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)4L, (long)this.resourceLogger);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)2L, (long)this.namedLogger);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)1L, (long)this.fakyLogger);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)3L, (long)this.errorLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)1L, (long)this.infoLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)2L, (long)this.debugLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)1L, (long)this.traceLevels);
        JAXRSLoggingAtomPullSpringTest.assertEquals((long)1L, (long)this.warningLevels);
    }

    @Ignore
    public static class Storage
    implements ReadWriteLogStorage {
        private static List<LogRecord> records = new LinkedList<LogRecord>();

        public int load(List<LogRecord> list, SearchCondition<LogRecord> sc, int pageNumber, int pageSize) {
            int loadFrom;
            int n = loadFrom = pageNumber == 1 ? 0 : pageSize * (pageNumber - 1);
            if (loadFrom + pageSize <= records.size()) {
                list.addAll(records.subList(loadFrom, loadFrom + pageSize));
            }
            return pageNumber;
        }

        public void save(List<LogRecord> list) {
            records.addAll(list);
        }

        public void clear() {
        }

        public void close() {
        }

        public int getSize() {
            return records.size();
        }

        public static List<LogRecord> getRecords() {
            return records;
        }

        public static void clearRecords() {
            records.clear();
        }
    }

    @Ignore
    public static class ExternalStorage
    implements ReadableLogStorage {
        private List<LogRecord> records = new LinkedList<LogRecord>();

        public ExternalStorage() {
            this.addRecord("org.apache.cxf.systest.jaxrs.JAXRSLoggingAtomPullSpringTest$Resource4", Level.SEVERE, null);
            this.addRecord("org.apache.cxf.systest.jaxrs.JAXRSLoggingAtomPullSpringTest$Resource4", Level.WARNING, null);
            this.addRecord("org.apache.cxf.systest.jaxrs.JAXRSLoggingAtomPullSpringTest$Resource4", Level.INFO, null);
            this.addRecord("org.apache.cxf.systest.jaxrs.JAXRSLoggingAtomPullSpringTest$Resource4", Level.FINE, new IllegalArgumentException());
            this.addRecord("org.apache.cxf.systest.jaxrs.JAXRSLoggingAtomPullSpringTest$Resource4", Level.FINEST, null);
            this.addRecord("org.apache.cxf.systest.jaxrs.JAXRSLoggingAtomPullSpringTest$Resource4", Level.FINER, null);
            this.addRecord("readOnlyStorageLogger", Level.SEVERE, null);
            this.addRecord("readOnlyStorageLogger", Level.SEVERE, null);
        }

        private void addRecord(String loggerName, Level level, Throwable t) {
            LogRecord lr = new LogRecord();
            lr.setLoggerName(loggerName);
            lr.setLevel(LogLevel.fromJUL((Level)level));
            if (t != null) {
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                lr.setThrowable(sw.getBuffer().toString());
            }
            this.records.add(lr);
        }

        public void close() {
        }

        public int getSize() {
            return -1;
        }

        public int load(List<LogRecord> list, SearchCondition<LogRecord> condition, int pageNumber, int pageSize) {
            int loadFrom;
            for (int i = loadFrom = pageNumber == 1 ? 0 : pageSize * (pageNumber - 1); i < loadFrom + pageSize; ++i) {
                if (!condition.isMet((Object)this.records.get(i))) continue;
                list.add(this.records.get(i));
            }
            return pageNumber;
        }
    }

    @Path(value="/")
    public static class AtomServerReset {
        private AtomPullServer server;

        public void setServer(AtomPullServer s) {
            this.server = s;
        }

        @POST
        public void reset() {
            this.server.reset();
        }
    }

    @Ignore
    @Path(value="/storage")
    public static class Resource3 {
        private static final Logger LOG1 = LogUtils.getL7dLogger(Resource3.class);
        private static final Logger LOG2 = LogUtils.getL7dLogger(Resource3.class, null, (String)"theStorageLogger");

        @GET
        @Path(value="/log")
        public void doLogging() {
            JAXRSLoggingAtomPullSpringTest.doLog(Resource3.LOG1, Resource3.LOG2);
        }
    }

    @Ignore
    @Path(value="/paged")
    public static class Resource2 {
        private static final Logger LOG1 = LogUtils.getL7dLogger(Resource2.class);
        private static final Logger LOG2 = LogUtils.getL7dLogger(Resource2.class, null, (String)"theNamedLogger");

        @GET
        @Path(value="/log")
        public void doLogging() {
            JAXRSLoggingAtomPullSpringTest.doLog(Resource2.LOG1, Resource2.LOG2);
        }
    }

    @Ignore
    @Path(value="/root")
    public static class Resource {
        private static final Logger LOG1 = LogUtils.getL7dLogger(Resource.class);
        private static final Logger LOG2 = LogUtils.getL7dLogger(Resource.class, null, (String)"namedLogger");

        @GET
        @Path(value="/log")
        public void doLogging() {
            JAXRSLoggingAtomPullSpringTest.doLog(Resource.LOG1, Resource.LOG2);
        }
    }

    @Ignore
    public static class SpringServer
    extends AbstractSpringServer {
        public static final int PORT = SpringServer.allocatePortAsInt(SpringServer.class);

        public SpringServer() {
            super("/jaxrs_logging_atompull", PORT);
        }
    }
}

