/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.cors;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.AbstractSpringServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class CrossOriginSimpleTest
extends AbstractBusClientServerTestBase {
    public static final int PORT = SpringServer.PORT;
    private WebClient configClient;

    @BeforeClass
    public static void startServers() throws Exception {
        CrossOriginSimpleTest.assertTrue((String)"server did not launch correctly", (boolean)CrossOriginSimpleTest.launchServer(SpringServer.class, (boolean)true));
    }

    @Before
    public void before() {
        ArrayList<JacksonJsonProvider> providers = new ArrayList<JacksonJsonProvider>();
        providers.add(new JacksonJsonProvider());
        this.configClient = WebClient.create((String)("http://localhost:" + PORT + "/config"), providers);
    }

    private List<String> headerValues(Header[] headers) {
        ArrayList<String> values = new ArrayList<String>();
        for (Header h : headers) {
            for (HeaderElement e : h.getElements()) {
                values.add(e.getName());
            }
        }
        return values;
    }

    private void assertAllOrigin(boolean allOrigins, String[] originList, String[] requestOrigins, boolean permitted) throws ClientProtocolException, IOException {
        this.configureAllowOrigins(allOrigins, originList);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet("http://localhost:" + PORT + "/untest/simpleGet/HelloThere");
        if (requestOrigins != null) {
            StringBuffer ob = new StringBuffer();
            for (String requestOrigin : requestOrigins) {
                ob.append(requestOrigin);
                ob.append(" ");
            }
            httpget.addHeader("Origin", ob.toString());
        }
        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        HttpEntity entity = response.getEntity();
        String e = IOUtils.toString((InputStream)entity.getContent(), (String)"utf-8");
        CrossOriginSimpleTest.assertEquals((Object)"HelloThere", (Object)e);
        this.assertOriginResponse(allOrigins, requestOrigins, permitted, response);
    }

    private void assertOriginResponse(boolean allOrigins, String[] requestOrigins, boolean permitted, HttpResponse response) {
        Header[] aaoHeaders = response.getHeaders("Access-Control-Allow-Origin");
        if (permitted) {
            CrossOriginSimpleTest.assertNotNull((Object)aaoHeaders);
            if (allOrigins) {
                CrossOriginSimpleTest.assertEquals((long)1L, (long)aaoHeaders.length);
                CrossOriginSimpleTest.assertEquals((Object)"*", (Object)aaoHeaders[0].getValue());
            } else {
                List<String> ovalues = this.headerValues(aaoHeaders);
                CrossOriginSimpleTest.assertEquals((long)1L, (long)ovalues.size());
                String[] origins = ovalues.get(0).split(" +");
                for (int x = 0; x < requestOrigins.length; ++x) {
                    CrossOriginSimpleTest.assertEquals((Object)requestOrigins[x], (Object)origins[x]);
                }
            }
        } else {
            CrossOriginSimpleTest.assertTrue((aaoHeaders == null || aaoHeaders.length == 0 ? 1 : 0) != 0);
        }
    }

    private void configureAllowOrigins(boolean allOrigins, String[] originList) {
        if (allOrigins) {
            originList = new String[]{};
        }
        String confResult = (String)this.configClient.accept(new String[]{"text/plain"}).replacePath("/setOriginList").type("application/json").post((Object)originList, String.class);
        CrossOriginSimpleTest.assertEquals((Object)"ok", (Object)confResult);
    }

    @Test
    public void failNoOrigin() throws Exception {
        this.assertAllOrigin(true, null, null, false);
    }

    @Test
    public void allowStarPassOne() throws Exception {
        this.assertAllOrigin(true, null, new String[]{"http://localhost:" + PORT}, true);
    }

    @Test
    public void preflightPostClassAnnotationFail() throws ClientProtocolException, IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpOptions httpoptions = new HttpOptions("http://localhost:" + PORT + "/antest/unannotatedPost");
        httpoptions.addHeader("Origin", "http://in.org");
        httpoptions.addHeader("Content-Type", "application/json");
        httpoptions.addHeader("Access-Control-Request-Method", "POST");
        httpoptions.addHeader("Access-Control-Request-Headers", "X-custom-1");
        HttpResponse response = httpclient.execute((HttpUriRequest)httpoptions);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        CrossOriginSimpleTest.assertEquals((long)0L, (long)response.getHeaders("Access-Control-Allow-Origin").length);
        CrossOriginSimpleTest.assertEquals((long)0L, (long)response.getHeaders("Access-Control-Allow-Headers").length);
        CrossOriginSimpleTest.assertEquals((long)0L, (long)response.getHeaders("Access-Control-Allow-Methods").length);
    }

    @Test
    public void preflightPostClassAnnotationFail2() throws ClientProtocolException, IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpOptions httpoptions = new HttpOptions("http://localhost:" + PORT + "/antest/unannotatedPost");
        httpoptions.addHeader("Origin", "http://area51.mil:31415");
        httpoptions.addHeader("Content-Type", "application/json");
        httpoptions.addHeader("Access-Control-Request-Method", "POST");
        httpoptions.addHeader("Access-Control-Request-Headers", "X-custom-3");
        HttpResponse response = httpclient.execute((HttpUriRequest)httpoptions);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        CrossOriginSimpleTest.assertEquals((long)0L, (long)response.getHeaders("Access-Control-Allow-Origin").length);
        CrossOriginSimpleTest.assertEquals((long)0L, (long)response.getHeaders("Access-Control-Allow-Headers").length);
        CrossOriginSimpleTest.assertEquals((long)0L, (long)response.getHeaders("Access-Control-Allow-Methods").length);
    }

    @Test
    public void preflightPostClassAnnotationPass() throws ClientProtocolException, IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpOptions httpoptions = new HttpOptions("http://localhost:" + PORT + "/antest/unannotatedPost");
        httpoptions.addHeader("Origin", "http://area51.mil:31415");
        httpoptions.addHeader("Content-Type", "application/json");
        httpoptions.addHeader("Access-Control-Request-Method", "POST");
        httpoptions.addHeader("Access-Control-Request-Headers", "X-custom-1");
        HttpResponse response = httpclient.execute((HttpUriRequest)httpoptions);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Header[] origin = response.getHeaders("Access-Control-Allow-Origin");
        CrossOriginSimpleTest.assertEquals((long)1L, (long)origin.length);
        CrossOriginSimpleTest.assertEquals((Object)"http://area51.mil:31415", (Object)origin[0].getValue());
        Header[] method = response.getHeaders("Access-Control-Allow-Methods");
        CrossOriginSimpleTest.assertEquals((long)1L, (long)method.length);
        CrossOriginSimpleTest.assertEquals((Object)"POST", (Object)method[0].getValue());
        Header[] requestHeaders = response.getHeaders("Access-Control-Allow-Headers");
        CrossOriginSimpleTest.assertEquals((long)1L, (long)requestHeaders.length);
        CrossOriginSimpleTest.assertEquals((Object)"X-custom-1", (Object)requestHeaders[0].getValue());
    }

    @Test
    public void preflightPostClassAnnotationPass2() throws ClientProtocolException, IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpOptions httpoptions = new HttpOptions("http://localhost:" + PORT + "/antest/unannotatedPost");
        httpoptions.addHeader("Origin", "http://area51.mil:31415");
        httpoptions.addHeader("Content-Type", "application/json");
        httpoptions.addHeader("Access-Control-Request-Method", "POST");
        httpoptions.addHeader("Access-Control-Request-Headers", "X-custom-1, X-custom-2");
        HttpResponse response = httpclient.execute((HttpUriRequest)httpoptions);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Header[] origin = response.getHeaders("Access-Control-Allow-Origin");
        CrossOriginSimpleTest.assertEquals((long)1L, (long)origin.length);
        CrossOriginSimpleTest.assertEquals((Object)"http://area51.mil:31415", (Object)origin[0].getValue());
        Header[] method = response.getHeaders("Access-Control-Allow-Methods");
        CrossOriginSimpleTest.assertEquals((long)1L, (long)method.length);
        CrossOriginSimpleTest.assertEquals((Object)"POST", (Object)method[0].getValue());
        Header[] requestHeaders = response.getHeaders("Access-Control-Allow-Headers");
        CrossOriginSimpleTest.assertEquals((long)1L, (long)requestHeaders.length);
        CrossOriginSimpleTest.assertTrue((boolean)requestHeaders[0].getValue().contains("X-custom-1"));
        CrossOriginSimpleTest.assertTrue((boolean)requestHeaders[0].getValue().contains("X-custom-2"));
    }

    @Test
    public void simplePostClassAnnotation() throws ClientProtocolException, IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpOptions httpoptions = new HttpOptions("http://localhost:" + PORT + "/antest/unannotatedPost");
        httpoptions.addHeader("Origin", "http://in.org");
        httpoptions.addHeader("Content-Type", "text/plain");
        httpoptions.addHeader("Access-Control-Request-Method", "POST");
        HttpResponse response = httpclient.execute((HttpUriRequest)httpoptions);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
    }

    @Test
    public void allowStarPassNone() throws Exception {
        this.assertAllOrigin(true, null, null, false);
    }

    @Test
    public void allowOnePassOne() throws Exception {
        this.assertAllOrigin(false, new String[]{"http://localhost:" + PORT}, new String[]{"http://localhost:" + PORT}, true);
    }

    @Test
    public void allowOnePassWrong() throws Exception {
        this.assertAllOrigin(false, new String[]{"http://localhost:" + PORT}, new String[]{"http://area51.mil:31315"}, false);
    }

    @Test
    public void allowTwoPassOne() throws Exception {
        this.assertAllOrigin(false, new String[]{"http://localhost:" + PORT, "http://area51.mil:3141"}, new String[]{"http://localhost:" + PORT}, true);
    }

    @Test
    public void allowTwoPassTwo() throws Exception {
        this.assertAllOrigin(false, new String[]{"http://localhost:" + PORT, "http://area51.mil:3141"}, new String[]{"http://localhost:" + PORT, "http://area51.mil:3141"}, true);
    }

    @Test
    public void allowTwoPassThree() throws Exception {
        this.assertAllOrigin(false, new String[]{"http://localhost:" + PORT, "http://area51.mil:3141"}, new String[]{"http://localhost:" + PORT, "http://area51.mil:3141", "http://hogwarts.edu:9"}, false);
    }

    @Test
    public void testAllowCredentials() throws Exception {
        String r = (String)this.configClient.replacePath("/setAllowCredentials/true").accept(new String[]{"text/plain"}).post(null, String.class);
        CrossOriginSimpleTest.assertEquals((Object)"ok", (Object)r);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet("http://localhost:" + PORT + "/untest/simpleGet/HelloThere");
        httpget.addHeader("Origin", "http://localhost:" + PORT);
        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        this.assertAllowCredentials(response, true);
    }

    @Test
    public void testForbidCredentials() throws Exception {
        String r = (String)this.configClient.replacePath("/setAllowCredentials/false").accept(new String[]{"text/plain"}).post(null, String.class);
        CrossOriginSimpleTest.assertEquals((Object)"ok", (Object)r);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet("http://localhost:" + PORT + "/untest/simpleGet/HelloThere");
        httpget.addHeader("Origin", "http://localhost:" + PORT);
        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        this.assertAllowCredentials(response, false);
    }

    @Test
    public void testNonSimpleActualRequest() throws Exception {
        this.configureAllowOrigins(true, null);
        String r = (String)this.configClient.replacePath("/setAllowCredentials/false").accept(new String[]{"text/plain"}).post(null, String.class);
        CrossOriginSimpleTest.assertEquals((Object)"ok", (Object)r);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpDelete httpdelete = new HttpDelete("http://localhost:" + PORT + "/untest/delete");
        httpdelete.addHeader("Origin", "http://localhost:" + PORT);
        HttpResponse response = httpclient.execute((HttpUriRequest)httpdelete);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        this.assertAllowCredentials(response, false);
        this.assertOriginResponse(true, null, true, response);
    }

    private void assertAllowCredentials(HttpResponse response, boolean correct) {
        Header[] aaoHeaders = response.getHeaders("Access-Control-Allow-Credentials");
        CrossOriginSimpleTest.assertEquals((long)1L, (long)aaoHeaders.length);
        CrossOriginSimpleTest.assertEquals((Object)Boolean.toString(correct), (Object)aaoHeaders[0].getValue());
    }

    @Test
    public void testAnnotatedSimple() throws Exception {
        this.configureAllowOrigins(true, null);
        String r = (String)this.configClient.replacePath("/setAllowCredentials/false").accept(new String[]{"text/plain"}).post(null, String.class);
        CrossOriginSimpleTest.assertEquals((Object)"ok", (Object)r);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet("http://localhost:" + PORT + "/untest/annotatedGet/HelloThere");
        httpget.addHeader("Origin", "http://area51.mil:31415");
        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        this.assertOriginResponse(false, new String[]{"http://area51.mil:31415"}, true, response);
        this.assertAllowCredentials(response, false);
        List<String> exposeHeadersValues = this.headerValues(response.getHeaders("Access-Control-Expose-Headers"));
        CrossOriginSimpleTest.assertEquals(Arrays.asList("X-custom-3", "X-custom-4"), exposeHeadersValues);
    }

    @Test
    public void testAnnotatedMethodPreflight() throws Exception {
        this.configureAllowOrigins(true, null);
        String r = (String)this.configClient.replacePath("/setAllowCredentials/false").accept(new String[]{"text/plain"}).post(null, String.class);
        CrossOriginSimpleTest.assertEquals((Object)"ok", (Object)r);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpOptions http = new HttpOptions("http://localhost:" + PORT + "/untest/annotatedPut");
        http.addHeader("Origin", "http://area51.mil:31415");
        http.addHeader("Access-Control-Request-Method", "PUT");
        http.addHeader("Access-Control-Request-Headers", "X-custom-1, x-custom-2");
        HttpResponse response = httpclient.execute((HttpUriRequest)http);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        this.assertOriginResponse(false, new String[]{"http://area51.mil:31415"}, true, response);
        this.assertAllowCredentials(response, true);
        List<String> exposeHeadersValues = this.headerValues(response.getHeaders("Access-Control-Expose-Headers"));
        CrossOriginSimpleTest.assertEquals(Collections.emptyList(), exposeHeadersValues);
        List<String> allowHeadersValues = this.headerValues(response.getHeaders("Access-Control-Allow-Headers"));
        CrossOriginSimpleTest.assertEquals(Arrays.asList("X-custom-1", "x-custom-2"), allowHeadersValues);
    }

    @Test
    public void testAnnotatedMethodPreflight2() throws Exception {
        this.configureAllowOrigins(true, null);
        String r = (String)this.configClient.replacePath("/setAllowCredentials/false").accept(new String[]{"text/plain"}).post(null, String.class);
        CrossOriginSimpleTest.assertEquals((Object)"ok", (Object)r);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpOptions http = new HttpOptions("http://localhost:" + PORT + "/untest/annotatedPut2");
        http.addHeader("Origin", "http://area51.mil:31415");
        http.addHeader("Access-Control-Request-Method", "PUT");
        http.addHeader("Access-Control-Request-Headers", "X-custom-1, x-custom-2");
        HttpResponse response = httpclient.execute((HttpUriRequest)http);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        this.assertOriginResponse(false, new String[]{"http://area51.mil:31415"}, true, response);
        this.assertAllowCredentials(response, true);
        List<String> exposeHeadersValues = this.headerValues(response.getHeaders("Access-Control-Expose-Headers"));
        CrossOriginSimpleTest.assertEquals(Collections.emptyList(), exposeHeadersValues);
        List<String> allowHeadersValues = this.headerValues(response.getHeaders("Access-Control-Allow-Headers"));
        CrossOriginSimpleTest.assertEquals(Arrays.asList("X-custom-1", "x-custom-2"), allowHeadersValues);
        if (httpclient instanceof Closeable) {
            ((Closeable)httpclient).close();
        }
    }

    @Test
    public void testAnnotatedClassCorrectOrigin() throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet("http://localhost:" + PORT + "/antest/simpleGet/HelloThere");
        httpget.addHeader("Origin", "http://area51.mil:31415");
        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        HttpEntity entity = response.getEntity();
        String e = IOUtils.toString((InputStream)entity.getContent(), (String)"utf-8");
        CrossOriginSimpleTest.assertEquals((Object)"HelloThere", (Object)e);
        this.assertOriginResponse(false, new String[]{"http://area51.mil:31415"}, true, response);
    }

    @Test
    public void testAnnotatedClassWrongOrigin() throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet("http://localhost:" + PORT + "/antest/simpleGet/HelloThere");
        httpget.addHeader("Origin", "http://su.us:1001");
        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        HttpEntity entity = response.getEntity();
        String e = IOUtils.toString((InputStream)entity.getContent(), (String)"utf-8");
        CrossOriginSimpleTest.assertEquals((Object)"HelloThere", (Object)e);
        this.assertOriginResponse(false, null, false, response);
    }

    @Test
    public void testAnnotatedLocalPreflight() throws Exception {
        this.configureAllowOrigins(true, null);
        String r = (String)this.configClient.replacePath("/setAllowCredentials/false").accept(new String[]{"text/plain"}).post(null, String.class);
        CrossOriginSimpleTest.assertEquals((Object)"ok", (Object)r);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpOptions http = new HttpOptions("http://localhost:" + PORT + "/antest/delete");
        http.addHeader("Origin", "http://area51.mil:3333");
        http.addHeader("Access-Control-Request-Method", "DELETE");
        HttpResponse response = httpclient.execute((HttpUriRequest)http);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        this.assertOriginResponse(false, new String[]{"http://area51.mil:3333"}, true, response);
        this.assertAllowCredentials(response, false);
        List<String> exposeHeadersValues = this.headerValues(response.getHeaders("Access-Control-Expose-Headers"));
        CrossOriginSimpleTest.assertEquals(Collections.emptyList(), exposeHeadersValues);
        List<String> allowedMethods = this.headerValues(response.getHeaders("Access-Control-Allow-Methods"));
        CrossOriginSimpleTest.assertEquals(Arrays.asList("DELETE PUT"), allowedMethods);
    }

    @Test
    public void testAnnotatedLocalPreflightNoGo() throws Exception {
        this.configureAllowOrigins(true, null);
        String r = (String)this.configClient.replacePath("/setAllowCredentials/false").accept(new String[]{"text/plain"}).post(null, String.class);
        CrossOriginSimpleTest.assertEquals((Object)"ok", (Object)r);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpOptions http = new HttpOptions("http://localhost:" + PORT + "/antest/delete");
        http.addHeader("Origin", "http://area51.mil:4444");
        http.addHeader("Access-Control-Request-Method", "DELETE");
        HttpResponse response = httpclient.execute((HttpUriRequest)http);
        CrossOriginSimpleTest.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        this.assertOriginResponse(false, new String[]{"http://area51.mil:4444"}, false, response);
    }

    @Ignore
    public static class SpringServer
    extends AbstractSpringServer {
        public static final int PORT = SpringServer.allocatePortAsInt(SpringServer.class);

        public SpringServer() {
            super("/jaxrs_cors", PORT);
        }
    }
}

