/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.failover;

import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;

public class Server
extends AbstractBusTestServerBase {
    public static final String PORT1 = Server.allocatePort(Server.class, (int)0);
    public static final String PORT2 = Server.allocatePort(Server.class, (int)1);
    public static final String PORT3 = Server.allocatePort(Server.class, (int)3);
    public static final String ADDRESS1 = "http://localhost:" + PORT1 + "/rest";
    public static final String ADDRESS2 = "http://localhost:" + PORT2 + "/rest";
    public static final String ADDRESS3 = "http://localhost:" + PORT3 + "/work/rest";
    List<org.apache.cxf.endpoint.Server> servers = new ArrayList<org.apache.cxf.endpoint.Server>();

    protected void run() {
        this.createEndpoint(ADDRESS2);
        this.createEndpoint(ADDRESS3);
    }

    public void tearDown() throws Exception {
        for (org.apache.cxf.endpoint.Server s : this.servers) {
            s.stop();
            s.destroy();
        }
        this.servers.clear();
    }

    private void createEndpoint(String address) {
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        sf.setResourceClasses(new Class[]{BookStore.class});
        sf.setResourceProvider(BookStore.class, (ResourceProvider)new SingletonResourceProvider((Object)new BookStore(), false));
        sf.setAddress(address);
        this.servers.add(sf.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Server s = new Server();
            s.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        finally {
            System.out.println("done!");
        }
    }
}

