/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.security;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;
import org.apache.cxf.systest.jaxrs.security.SecureBook;
import org.springframework.security.annotation.Secured;

public interface SecureBookInterface {
    @GET
    @Path(value="/thosebooks/{bookId}/")
    @Produces(value={"application/xml"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN"})
    public Book getThatBook(@PathParam(value="bookId") Long var1) throws BookNotFoundFault;

    @GET
    @Path(value="/thosebooks/{bookId}/{id}")
    @Produces(value={"application/xml"})
    @Secured(value={"ROLE_USER"})
    public Book getThatBook(@PathParam(value="bookId") Long var1, @PathParam(value="id") String var2) throws BookNotFoundFault;

    @GET
    @Path(value="/thosebooks")
    @Produces(value={"application/xml"})
    @Secured(value={"ROLE_ADMIN", "ROLE_BOOK_OWNER"})
    public Book getThatBook() throws BookNotFoundFault;

    @Path(value="/subresource")
    public SecureBookInterface getBookSubResource() throws BookNotFoundFault;

    @GET
    @Produces(value={"application/xml"})
    @Secured(value={"ROLE_ADMIN"})
    public Book getDefaultBook() throws BookNotFoundFault;

    @Path(value="/securebook")
    public SecureBook getSecureBook() throws BookNotFoundFault;
}

