/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.security;

import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.security.KerberosAuthOutInterceptor;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.systest.jaxrs.security.BookKerberosServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSKerberosBookTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookKerberosServer.PORT;
    private static final String KERBEROS_CONFIG_FILE = "org/apache/cxf/systest/jaxrs/security/kerberosClient.xml";

    @BeforeClass
    public static void startServers() throws Exception {
        String jaasConfig = JAXRSKerberosBookTest.class.getResource("/org/apache/cxf/systest/jaxrs/security/kerberos.cfg").toURI().getPath();
        System.setProperty("java.security.auth.login.config", jaasConfig);
        JAXRSKerberosBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSKerberosBookTest.launchServer(BookKerberosServer.class, (boolean)true));
    }

    @Test
    @Ignore
    public void testGetBookWithConfigInHttpConduit() throws Exception {
        this.doTestGetBook123Proxy(KERBEROS_CONFIG_FILE);
    }

    private void doTestGetBook123Proxy(String configFile) throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class, (String)configFile);
        WebClient.getConfig((Object)bs).getOutInterceptors().add(new LoggingOutInterceptor());
        JAXRSKerberosBookTest.assertEquals((Object)("http://localhost:" + PORT), (Object)WebClient.client((Object)bs).getBaseURI().toString());
        Book b = bs.getBook("123");
        JAXRSKerberosBookTest.assertEquals((long)b.getId(), (long)123L);
        b = bs.getBook("123");
        JAXRSKerberosBookTest.assertEquals((long)b.getId(), (long)123L);
    }

    @Test
    @Ignore
    public void testGetBookWithInterceptor() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/books/123"));
        KerberosAuthOutInterceptor kbInterceptor = new KerberosAuthOutInterceptor();
        AuthorizationPolicy policy = new AuthorizationPolicy();
        policy.setAuthorizationType("Negotiate");
        policy.setAuthorization("KerberosClient");
        policy.setUserName("alice");
        policy.setPassword("alice");
        kbInterceptor.setPolicy(policy);
        kbInterceptor.setCredDelegation(true);
        WebClient.getConfig((Object)wc).getOutInterceptors().add(new LoggingOutInterceptor());
        WebClient.getConfig((Object)wc).getOutInterceptors().add(kbInterceptor);
        Book b = (Book)wc.get(Book.class);
        JAXRSKerberosBookTest.assertEquals((long)b.getId(), (long)123L);
    }

    @Test
    @Ignore
    public void testGetBookWithInterceptorAndKeyTab() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/books/123"));
        KerberosAuthOutInterceptor kbInterceptor = new KerberosAuthOutInterceptor();
        AuthorizationPolicy policy = new AuthorizationPolicy();
        policy.setAuthorizationType("Negotiate");
        policy.setAuthorization("KerberosClientKeyTab");
        kbInterceptor.setPolicy(policy);
        kbInterceptor.setCredDelegation(true);
        WebClient.getConfig((Object)wc).getOutInterceptors().add(new LoggingOutInterceptor());
        WebClient.getConfig((Object)wc).getOutInterceptors().add(kbInterceptor);
        Book b = (Book)wc.get(Book.class);
        JAXRSKerberosBookTest.assertEquals((long)b.getId(), (long)123L);
    }

    @Test
    @Ignore
    public void testGetBookWithInterceptorServiceKeyTab() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + PORT + "/bookstore/books/123"));
        KerberosAuthOutInterceptor kbInterceptor = new KerberosAuthOutInterceptor();
        AuthorizationPolicy policy = new AuthorizationPolicy();
        policy.setAuthorizationType("Negotiate");
        policy.setAuthorization("KerberosClient");
        policy.setUserName("alice");
        policy.setPassword("alice");
        kbInterceptor.setPolicy(policy);
        kbInterceptor.setServicePrincipalName("HTTP/ktab");
        WebClient.getConfig((Object)wc).getOutInterceptors().add(new LoggingOutInterceptor());
        WebClient.getConfig((Object)wc).getOutInterceptors().add(kbInterceptor);
        Book b = (Book)wc.get(Book.class);
        JAXRSKerberosBookTest.assertEquals((long)b.getId(), (long)123L);
    }
}

