/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.Ignore;
import org.junit.Test;

public abstract class AbstractJAXRSContinuationsTest
extends AbstractBusClientServerTestBase {
    @Test
    public void testDefaultTimeout() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + this.getPort() + this.getBaseAddress() + "/books/defaulttimeout"));
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setReceiveTimeout(1000000L);
        Response r = wc.get();
        AbstractJAXRSContinuationsTest.assertEquals((long)503L, (long)r.getStatus());
    }

    @Test
    public void testImmediateResume() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + this.getPort() + this.getBaseAddress() + "/books/resume"));
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setReceiveTimeout(1000000L);
        wc.accept(new String[]{"text/plain"});
        String str = (String)wc.get(String.class);
        AbstractJAXRSContinuationsTest.assertEquals((Object)"immediateResume", (Object)str);
    }

    @Test
    public void testImmediateResumeSubresource() throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + this.getPort() + this.getBaseAddress() + "/books/subresources/books/resume"));
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setReceiveTimeout(1000000L);
        wc.accept(new String[]{"text/plain"});
        String str = (String)wc.get(String.class);
        AbstractJAXRSContinuationsTest.assertEquals((Object)"immediateResume", (Object)str);
    }

    @Test
    public void testTimeoutAndCancel() throws Exception {
        this.doTestTimeoutAndCancel(this.getBaseAddress());
    }

    protected void doTestTimeoutAndCancel(String baseAddress) throws Exception {
        WebClient wc = WebClient.create((String)("http://localhost:" + this.getPort() + baseAddress + "/books/cancel"));
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setReceiveTimeout(1000000L);
        Response r = wc.get();
        AbstractJAXRSContinuationsTest.assertEquals((long)503L, (long)r.getStatus());
        String retryAfter = r.getHeaderString("Retry-After");
        AbstractJAXRSContinuationsTest.assertNotNull((Object)retryAfter);
        AbstractJAXRSContinuationsTest.assertEquals((Object)"10", (Object)retryAfter);
    }

    @Test
    public void testContinuationWithTimeHandler() throws Exception {
        this.doTestContinuation("/books/timeouthandler");
    }

    @Test
    public void testContinuationWithTimeHandlerResumeOnly() throws Exception {
        this.doTestContinuation("/books/timeouthandlerresume");
    }

    @Test
    public void testContinuation() throws Exception {
        this.doTestContinuation("/books");
    }

    @Test
    public void testContinuationSubresource() throws Exception {
        this.doTestContinuation("/books/subresources");
    }

    protected void doTestContinuation(String pathSegment) throws Exception {
        String port = this.getPort();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch doneSignal = new CountDownLatch(1);
        ArrayList<BookWorker> workers = new ArrayList<BookWorker>(5);
        for (int x = 1; x < 6; ++x) {
            workers.add(new BookWorker("http://localhost:" + port + this.getBaseAddress() + pathSegment + "/" + x, Integer.toString(x), "CXF in Action" + x, startSignal, doneSignal));
        }
        for (BookWorker w : workers) {
            executor.execute(w);
        }
        startSignal.countDown();
        doneSignal.await(60L, TimeUnit.SECONDS);
        executor.shutdownNow();
        AbstractJAXRSContinuationsTest.assertEquals((String)"Not all invocations have completed", (long)0L, (long)doneSignal.getCount());
        for (BookWorker w : workers) {
            w.checkError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBook(String address, String id, String expected) throws Exception {
        GetMethod get = new GetMethod(address);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)get);
            AbstractJAXRSContinuationsTest.assertEquals((long)200L, (long)result);
            AbstractJAXRSContinuationsTest.assertEquals((String)("Book description for id " + id + " is wrong"), (Object)expected, (Object)IOUtils.toString((InputStream)get.getResponseBodyAsStream()));
        }
        finally {
            get.releaseConnection();
        }
    }

    protected String getBaseAddress() {
        return "/bookstore";
    }

    protected abstract String getPort();

    @Ignore
    private class BookWorker
    implements Runnable {
        private String address;
        private String id;
        private String expected;
        private CountDownLatch startSignal;
        private CountDownLatch doneSignal;
        private Exception error;

        public BookWorker(String address, String id, String expected, CountDownLatch startSignal, CountDownLatch doneSignal) {
            this.address = address;
            this.id = id;
            this.expected = expected;
            this.startSignal = startSignal;
            this.doneSignal = doneSignal;
        }

        public void checkError() throws Exception {
            if (this.error != null) {
                throw this.error;
            }
        }

        @Override
        public void run() {
            try {
                this.startSignal.await();
                AbstractJAXRSContinuationsTest.this.checkBook(this.address, this.id, this.expected);
                this.doneSignal.countDown();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception ex) {
                ex.fillInStackTrace();
                this.error = ex;
            }
        }
    }
}

