/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookServer20;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRS20ClientServerBookTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookServer20.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRS20ClientServerBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRS20ClientServerBookTest.launchServer(BookServer20.class, (boolean)true));
    }

    @Test
    public void testEchoBookElement() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)("http://localhost:" + PORT), BookStore.class);
        JAXBElement<Book> element = store.echoBookElement((JAXBElement<Book>)new JAXBElement(new QName("", "Book"), Book.class, (Object)new Book("CXF", 123L)));
        Book book = (Book)element.getValue();
        JAXRS20ClientServerBookTest.assertEquals((long)123L, (long)book.getId());
        JAXRS20ClientServerBookTest.assertEquals((Object)"CXF", (Object)book.getName());
        Book book2 = store.echoBookElement(new Book("CXF3", 128L));
        JAXRS20ClientServerBookTest.assertEquals((long)130L, (long)book2.getId());
        JAXRS20ClientServerBookTest.assertEquals((Object)"CXF3", (Object)book2.getName());
    }

    @Test
    public void testGetGenericBook() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/genericbooks/123";
        this.doTestGetGenericBook(address, 124L, false);
    }

    @Test
    public void testGetGenericBook2() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/genericbooks2/123";
        this.doTestGetGenericBook(address, 123L, true);
    }

    private void doTestGetGenericBook(String address, long bookId, boolean checkAnnotations) throws Exception {
        WebClient wc = WebClient.create((String)address);
        wc.accept(new String[]{"application/xml"});
        Book book = (Book)wc.get(Book.class);
        JAXRS20ClientServerBookTest.assertEquals((long)bookId, (long)book.getId());
        MediaType mt = wc.getResponse().getMediaType();
        JAXRS20ClientServerBookTest.assertEquals((Object)"application/xml;charset=ISO-8859-1", (Object)mt.toString());
        if (checkAnnotations) {
            JAXRS20ClientServerBookTest.assertEquals((Object)"OK", (Object)wc.getResponse().getHeaderString("Annotations"));
        } else {
            JAXRS20ClientServerBookTest.assertNull((Object)wc.getResponse().getHeaderString("Annotations"));
        }
    }

    @Test
    public void testGetBook() {
        String address = "http://localhost:" + PORT + "/bookstore/bookheaders/simple";
        this.doTestGetBook(address, false);
    }

    @Test
    public void testGetBookSyncLink() {
        String address = "http://localhost:" + PORT + "/bookstore/bookheaders/simple";
        WebClient wc = this.createWebClient(address);
        Book book = (Book)wc.sync().get(Book.class);
        JAXRS20ClientServerBookTest.assertEquals((long)124L, (long)book.getId());
        this.validateResponse(wc);
    }

    @Test
    public void testGetBookSyncWithAsync() {
        String address = "http://localhost:" + PORT + "/bookstore/bookheaders/simple";
        this.doTestGetBook(address, true);
    }

    @Test
    public void testGetBookAsync() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/bookheaders/simple";
        this.doTestGetBookAsync(address, false);
    }

    @Test
    public void testGetBookAsyncNoCallback() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/bookheaders/simple";
        WebClient wc = this.createWebClient(address);
        Future future = wc.async().get(Book.class);
        Book book = (Book)future.get();
        JAXRS20ClientServerBookTest.assertEquals((long)124L, (long)book.getId());
        this.validateResponse(wc);
    }

    @Test
    public void testGetBookAsyncResponse() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/bookheaders/simple";
        this.doTestGetBookAsyncResponse(address, false);
    }

    @Test
    public void testGetBookAsyncInvoker() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/bookheaders/simple";
        this.doTestGetBookAsync(address, true);
    }

    @Test
    public void testPreMatchContainerFilterThrowsException() {
        String address = "http://localhost:" + PORT + "/throwException";
        WebClient wc = WebClient.create((String)address);
        Response response = wc.get();
        JAXRS20ClientServerBookTest.assertEquals((long)500L, (long)response.getStatus());
        JAXRS20ClientServerBookTest.assertEquals((Object)"Prematch filter error", (Object)response.readEntity(String.class));
        JAXRS20ClientServerBookTest.assertEquals((Object)"prematch", (Object)response.getHeaderString("FilterException"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"OK", (Object)response.getHeaderString("Response"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"OK2", (Object)response.getHeaderString("Response2"));
        JAXRS20ClientServerBookTest.assertNull((Object)response.getHeaderString("DynamicResponse"));
        JAXRS20ClientServerBookTest.assertNull((Object)response.getHeaderString("Custom"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"serverWrite", (Object)response.getHeaderString("ServerWriterInterceptor"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"serverWrite2", (Object)response.getHeaderString("ServerWriterInterceptor2"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"serverWriteHttpResponse", (Object)response.getHeaderString("ServerWriterInterceptorHttpResponse"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"text/plain;charset=us-ascii", (Object)response.getMediaType().toString());
    }

    @Test
    public void testPostMatchContainerFilterThrowsException() {
        String address = "http://localhost:" + PORT + "/bookstore/bookheaders/simple?throwException";
        WebClient wc = WebClient.create((String)address);
        Response response = wc.get();
        JAXRS20ClientServerBookTest.assertEquals((long)500L, (long)response.getStatus());
        JAXRS20ClientServerBookTest.assertEquals((Object)"Postmatch filter error", (Object)response.readEntity(String.class));
        JAXRS20ClientServerBookTest.assertEquals((Object)"postmatch", (Object)response.getHeaderString("FilterException"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"OK", (Object)response.getHeaderString("Response"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"OK2", (Object)response.getHeaderString("Response2"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"Dynamic", (Object)response.getHeaderString("DynamicResponse"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"custom", (Object)response.getHeaderString("Custom"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"serverWrite", (Object)response.getHeaderString("ServerWriterInterceptor"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"text/plain;charset=us-ascii", (Object)response.getMediaType().toString());
    }

    @Test
    public void testGetBookWrongPath() {
        String address = "http://localhost:" + PORT + "/wrongpath";
        this.doTestGetBook(address, false);
    }

    @Test
    public void testGetBookWrongPathAsync() throws Exception {
        String address = "http://localhost:" + PORT + "/wrongpath";
        this.doTestGetBookAsync(address, false);
    }

    @Test
    public void testPostCollectionGenericEntity() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/collections3";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"application/xml"}).type("application/xml");
        GenericEntity<List<Book>> collectionEntity = this.createGenericEntity();
        Holder holder = new Holder();
        InvocationCallback<Book> callback = this.createCallback((Holder<Book>)holder);
        Future future = wc.post(collectionEntity, callback);
        Book book = (Book)future.get();
        JAXRS20ClientServerBookTest.assertEquals((long)200L, (long)wc.getResponse().getStatus());
        JAXRS20ClientServerBookTest.assertSame((Object)book, (Object)holder.value);
        JAXRS20ClientServerBookTest.assertNotSame(((List)collectionEntity.getEntity()).get(0), (Object)book);
        JAXRS20ClientServerBookTest.assertEquals((Object)((Book)((List)collectionEntity.getEntity()).get(0)).getName(), (Object)book.getName());
    }

    @Test
    public void testPostCollectionGenericEntityAsEntity() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/collections3";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"application/xml"});
        GenericEntity<List<Book>> collectionEntity = this.createGenericEntity();
        Holder holder = new Holder();
        InvocationCallback<Book> callback = this.createCallback((Holder<Book>)holder);
        Future future = wc.async().post(Entity.entity(collectionEntity, (String)"application/xml"), callback);
        Book book = (Book)future.get();
        JAXRS20ClientServerBookTest.assertEquals((long)200L, (long)wc.getResponse().getStatus());
        JAXRS20ClientServerBookTest.assertSame((Object)book, (Object)holder.value);
        JAXRS20ClientServerBookTest.assertNotSame(((List)collectionEntity.getEntity()).get(0), (Object)book);
        JAXRS20ClientServerBookTest.assertEquals((Object)((Book)((List)collectionEntity.getEntity()).get(0)).getName(), (Object)book.getName());
    }

    @Test
    public void testPostReplaceBook() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/books2";
        WebClient wc = WebClient.create((String)endpointAddress, Collections.singletonList(new ReplaceBodyFilter()));
        wc.accept(new String[]{"text/xml"}).type("application/xml");
        Book book = (Book)wc.post((Object)new Book("book", 555L), Book.class);
        JAXRS20ClientServerBookTest.assertEquals((long)561L, (long)book.getId());
    }

    @Test
    public void testPostReplaceBookMistypedCT() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/books2";
        WebClient wc = WebClient.create((String)endpointAddress, Collections.singletonList(new ReplaceBodyFilter()));
        wc.accept(new String[]{"text/mistypedxml"}).type("text/xml");
        Book book = (Book)wc.post((Object)new Book("book", 555L), Book.class);
        JAXRS20ClientServerBookTest.assertEquals((long)561L, (long)book.getId());
    }

    @Test
    public void testReplaceBookMistypedCTAndHttpVerb() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/books2/mistyped";
        WebClient wc = WebClient.create((String)endpointAddress, Collections.singletonList(new ReplaceBodyFilter()));
        wc.accept(new String[]{"text/mistypedxml"}).type("text/xml").header("THEMETHOD", new Object[]{"PUT"});
        Book book = (Book)wc.invoke("DELETE", (Object)new Book("book", 555L), Book.class);
        JAXRS20ClientServerBookTest.assertEquals((long)561L, (long)book.getId());
    }

    @Test
    public void testReplaceBookMistypedCTAndHttpVerb2() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/books2/mistyped";
        WebClient wc = WebClient.create((String)endpointAddress, Collections.singletonList(new ReplaceBodyFilter()));
        wc.accept(new String[]{"text/mistypedxml"}).header("THEMETHOD", new Object[]{"PUT"});
        Book book = (Book)wc.invoke("GET", null, Book.class);
        JAXRS20ClientServerBookTest.assertEquals((long)561L, (long)book.getId());
    }

    @Test
    public void testPostGetCollectionGenericEntityAndType() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/collections";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"application/xml"}).type("application/xml");
        GenericEntity<List<Book>> collectionEntity = this.createGenericEntity();
        Holder holder = new Holder();
        CustomInvocationCallback callback = new CustomInvocationCallback((Holder<List<Book>>)holder);
        Future future = wc.async().post(Entity.entity(collectionEntity, (String)"application/xml"), (InvocationCallback)callback);
        List books2 = (List)future.get();
        JAXRS20ClientServerBookTest.assertNotNull((Object)books2);
        List books = (List)collectionEntity.getEntity();
        JAXRS20ClientServerBookTest.assertNotSame((Object)books, (Object)books2);
        JAXRS20ClientServerBookTest.assertEquals((long)2L, (long)books2.size());
        Book b11 = (Book)books.get(0);
        JAXRS20ClientServerBookTest.assertEquals((long)123L, (long)b11.getId());
        JAXRS20ClientServerBookTest.assertEquals((Object)"CXF in Action", (Object)b11.getName());
        Book b22 = (Book)books.get(1);
        JAXRS20ClientServerBookTest.assertEquals((long)124L, (long)b22.getId());
        JAXRS20ClientServerBookTest.assertEquals((Object)"CXF Rocks", (Object)b22.getName());
        JAXRS20ClientServerBookTest.assertEquals((long)200L, (long)wc.getResponse().getStatus());
    }

    @Test
    public void testPostGetCollectionGenericEntityAndType2() throws Exception {
        String endpointAddress = "http://localhost:" + PORT + "/bookstore/collections";
        WebClient wc = WebClient.create((String)endpointAddress);
        wc.accept(new String[]{"application/xml"}).type("application/xml");
        GenericEntity<List<Book>> collectionEntity = this.createGenericEntity();
        GenericType<List<Book>> genericResponseType = new GenericType<List<Book>>(){};
        Future future = wc.async().post(Entity.entity(collectionEntity, (String)"application/xml"), (GenericType)genericResponseType);
        List books2 = (List)future.get();
        JAXRS20ClientServerBookTest.assertNotNull((Object)books2);
        List books = (List)collectionEntity.getEntity();
        JAXRS20ClientServerBookTest.assertNotSame((Object)books, (Object)books2);
        JAXRS20ClientServerBookTest.assertEquals((long)2L, (long)books2.size());
        Book b11 = (Book)books.get(0);
        JAXRS20ClientServerBookTest.assertEquals((long)123L, (long)b11.getId());
        JAXRS20ClientServerBookTest.assertEquals((Object)"CXF in Action", (Object)b11.getName());
        Book b22 = (Book)books.get(1);
        JAXRS20ClientServerBookTest.assertEquals((long)124L, (long)b22.getId());
        JAXRS20ClientServerBookTest.assertEquals((Object)"CXF Rocks", (Object)b22.getName());
        JAXRS20ClientServerBookTest.assertEquals((long)200L, (long)wc.getResponse().getStatus());
    }

    private GenericEntity<List<Book>> createGenericEntity() {
        Book b1 = new Book("CXF in Action", 123L);
        Book b2 = new Book("CXF Rocks", 124L);
        ArrayList<Book> books = new ArrayList<Book>();
        books.add(b1);
        books.add(b2);
        return new GenericEntity<List<Book>>(books){};
    }

    private InvocationCallback<Book> createCallback(final Holder<Book> holder) {
        return new InvocationCallback<Book>(){

            public void completed(Book response) {
                holder.value = response;
            }

            public void failed(ClientException error) {
                error.printStackTrace();
            }
        };
    }

    private void doTestGetBook(String address, boolean useAsync) {
        WebClient wc = this.createWebClient(address);
        if (useAsync) {
            WebClient.getConfig((Object)wc).getRequestContext().put("use.async.http.conduit", true);
        }
        Book book = (Book)wc.get(Book.class);
        JAXRS20ClientServerBookTest.assertEquals((long)124L, (long)book.getId());
        this.validateResponse(wc);
    }

    private WebClient createWebClient(String address) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new ClientHeaderRequestFilter());
        providers.add(new ClientHeaderResponseFilter());
        return WebClient.create((String)address, providers);
    }

    private WebClient createWebClientPost(String address) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new ClientHeaderRequestFilter());
        providers.add(new ClientHeaderResponseFilter());
        providers.add(new ClientReaderInterceptor());
        providers.add(new ClientWriterInterceptor());
        return WebClient.create((String)address, providers);
    }

    private void doTestGetBookAsync(String address, boolean asyncInvoker) throws InterruptedException, ExecutionException {
        WebClient wc = this.createWebClient(address);
        Holder holder = new Holder();
        InvocationCallback<Book> callback = this.createCallback((Holder<Book>)holder);
        Future future = asyncInvoker ? wc.async().get(callback) : wc.get(callback);
        Book book = (Book)future.get();
        JAXRS20ClientServerBookTest.assertSame((Object)book, (Object)holder.value);
        JAXRS20ClientServerBookTest.assertEquals((long)124L, (long)book.getId());
        this.validateResponse(wc);
    }

    private void doTestPostBookAsyncHandler(String address) throws InterruptedException, ExecutionException {
        WebClient wc = this.createWebClientPost(address);
        final Holder holder = new Holder();
        InvocationCallback<Book> callback = new InvocationCallback<Book>(){

            public void completed(Book response) {
                holder.value = response;
            }

            public void failed(ClientException error) {
            }
        };
        Future future = wc.post((Object)new Book("async", 126L), (InvocationCallback)callback);
        Book book = (Book)future.get();
        JAXRS20ClientServerBookTest.assertSame((Object)book, (Object)holder.value);
        JAXRS20ClientServerBookTest.assertEquals((long)124L, (long)book.getId());
        this.validatePostResponse(wc);
    }

    private void doTestGetBookAsyncResponse(String address, boolean asyncInvoker) throws InterruptedException, ExecutionException {
        WebClient wc = this.createWebClient(address);
        wc.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        final Holder holder = new Holder();
        InvocationCallback<Response> callback = new InvocationCallback<Response>(){

            public void completed(Response response) {
                holder.value = response;
            }

            public void failed(ClientException error) {
            }
        };
        Future future = asyncInvoker ? wc.async().get((InvocationCallback)callback) : wc.get((InvocationCallback)callback);
        Book book = (Book)((Response)future.get()).readEntity(Book.class);
        JAXRS20ClientServerBookTest.assertEquals((long)124L, (long)book.getId());
        this.validateResponse(wc);
    }

    private void validateResponse(WebClient wc) {
        Response response = wc.getResponse();
        JAXRS20ClientServerBookTest.assertEquals((Object)"OK", (Object)response.getHeaderString("Response"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"OK2", (Object)response.getHeaderString("Response2"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"Dynamic", (Object)response.getHeaderString("DynamicResponse"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"Dynamic2", (Object)response.getHeaderString("DynamicResponse2"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"custom", (Object)response.getHeaderString("Custom"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"simple", (Object)response.getHeaderString("Simple"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"serverWrite", (Object)response.getHeaderString("ServerWriterInterceptor"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"application/xml;charset=us-ascii", (Object)response.getMediaType().toString());
        JAXRS20ClientServerBookTest.assertEquals((Object)"http://localhost/redirect", (Object)response.getHeaderString("Location"));
    }

    private void validatePostResponse(WebClient wc) {
        this.validateResponse(wc);
        Response response = wc.getResponse();
        JAXRS20ClientServerBookTest.assertEquals((Object)"serverRead", (Object)response.getHeaderString("ServerReaderInterceptor"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"clientWrite", (Object)response.getHeaderString("ClientWriterInterceptor"));
        JAXRS20ClientServerBookTest.assertEquals((Object)"clientRead", (Object)response.getHeaderString("ClientReaderInterceptor"));
    }

    @Test
    public void testClientFiltersLocalResponse() {
        String address = "http://localhost:" + PORT + "/bookstores";
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new ClientCacheRequestFilter());
        providers.add(new ClientHeaderResponseFilter());
        WebClient wc = WebClient.create((String)address, providers);
        Book theBook = new Book("Echo", 123L);
        Response r = wc.post((Object)theBook);
        JAXRS20ClientServerBookTest.assertEquals((long)201L, (long)r.getStatus());
        JAXRS20ClientServerBookTest.assertEquals((Object)"http://localhost/redirect", (Object)r.getHeaderString("Location"));
        Book responseBook = (Book)r.readEntity(Book.class);
        JAXRS20ClientServerBookTest.assertSame((Object)theBook, (Object)responseBook);
    }

    @Test
    public void testPostBook() {
        String address = "http://localhost:" + PORT + "/bookstore/bookheaders/simple";
        WebClient wc = this.createWebClientPost(address);
        Book book = (Book)wc.post((Object)new Book("Book", 126L), Book.class);
        JAXRS20ClientServerBookTest.assertEquals((long)124L, (long)book.getId());
        this.validatePostResponse(wc);
    }

    @Test
    public void testPostBookNewMediaType() {
        String address = "http://localhost:" + PORT + "/bookstore/bookheaders/simple";
        WebClient wc = this.createWebClientPost(address);
        wc.header("newmediatype", new Object[]{"application/v1+xml"});
        Book book = (Book)wc.post((Object)new Book("Book", 126L), Book.class);
        JAXRS20ClientServerBookTest.assertEquals((long)124L, (long)book.getId());
        this.validatePostResponse(wc);
        JAXRS20ClientServerBookTest.assertEquals((Object)"application/v1+xml", (Object)wc.getResponse().getHeaderString("newmediatypeused"));
    }

    @Test
    public void testBookExistsServerStreamReplace() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/check2";
        WebClient wc = WebClient.create((String)address);
        wc.accept(new String[]{"text/plain"}).type("text/plain");
        JAXRS20ClientServerBookTest.assertTrue((boolean)((Boolean)wc.post((Object)"s", Boolean.class)));
    }

    @Test
    public void testBookExistsServerAddressOverwrite() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/books/checkN";
        WebClient wc = WebClient.create((String)address);
        wc.accept(new String[]{"text/plain"}).type("text/plain");
        JAXRS20ClientServerBookTest.assertTrue((boolean)((Boolean)wc.post((Object)"s", Boolean.class)));
    }

    @Test
    public void testPostBookAsync() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/bookheaders/simple";
        WebClient wc = this.createWebClientPost(address);
        Future future = wc.async().post(Entity.xml((Object)new Book("Book", 126L)), Book.class);
        JAXRS20ClientServerBookTest.assertEquals((long)124L, (long)((Book)future.get()).getId());
        this.validatePostResponse(wc);
    }

    @Test
    public void testPostBookAsyncHandler() throws Exception {
        String address = "http://localhost:" + PORT + "/bookstore/bookheaders/simple";
        this.doTestPostBookAsyncHandler(address);
    }

    public static class ClientWriterInterceptor
    implements WriterInterceptor {
        public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
            context.getHeaders().add((Object)"ClientWriterInterceptor", (Object)"clientWrite");
            context.proceed();
        }
    }

    public static class ClientReaderInterceptor
    implements ReaderInterceptor {
        public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
            context.getHeaders().add((Object)"ClientReaderInterceptor", (Object)"clientRead");
            return context.proceed();
        }
    }

    private static class ClientHeaderResponseFilter
    implements ClientResponseFilter {
        private ClientHeaderResponseFilter() {
        }

        public void filter(ClientRequestContext reqContext, ClientResponseContext respContext) throws IOException {
            respContext.getHeaders().putSingle((Object)"Location", (Object)"http://localhost/redirect");
        }
    }

    private static class ClientHeaderRequestFilter
    implements ClientRequestFilter {
        private ClientHeaderRequestFilter() {
        }

        public void filter(ClientRequestContext context) throws IOException {
            context.getHeaders().putSingle((Object)"Simple", (Object)"simple");
        }
    }

    private static class ClientCacheRequestFilter
    implements ClientRequestFilter {
        private ClientCacheRequestFilter() {
        }

        public void filter(ClientRequestContext context) throws IOException {
            context.abortWith(Response.status((int)201).entity(context.getEntity()).build());
        }
    }

    private static class ReplaceBodyFilter
    implements ClientRequestFilter {
        private ReplaceBodyFilter() {
        }

        public void filter(ClientRequestContext rc) throws IOException {
            String method = rc.getMethod();
            String expectedMethod = null;
            if (rc.getAcceptableMediaTypes().contains(MediaType.valueOf((String)"text/mistypedxml")) && rc.getHeaders().getFirst((Object)"THEMETHOD") != null) {
                expectedMethod = MediaType.TEXT_XML_TYPE.equals((Object)rc.getMediaType()) ? "DELETE" : "GET";
                rc.setUri(URI.create("http://localhost:" + PORT + "/bookstore/books2"));
                rc.setMethod(rc.getHeaders().getFirst((Object)"THEMETHOD").toString());
                if ("GET".equals(expectedMethod)) {
                    // empty if block
                }
            } else {
                expectedMethod = "POST";
            }
            if (!expectedMethod.equals(method)) {
                throw new RuntimeException();
            }
            if ("GET".equals(expectedMethod)) {
                rc.setEntity((Object)new Book("book", 560L), null, MediaType.TEXT_XML_TYPE);
            } else {
                rc.setEntity((Object)new Book("book", ((Book)rc.getEntity()).getId() + 5L), null, null);
            }
        }
    }

    private static class CustomInvocationCallback
    implements InvocationCallback<List<Book>> {
        private Holder<List<Book>> holder;

        public CustomInvocationCallback(Holder<List<Book>> holder) {
            this.holder = holder;
        }

        public void completed(List<Book> books) {
            this.holder.value = books;
        }

        public void failed(ClientException arg0) {
        }
    }
}

