/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.systest.jaxrs.BookCxfContinuationServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSCxfContinuationsTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BookCxfContinuationServer.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        AbstractResourceInfo.clearAllMaps();
        JAXRSCxfContinuationsTest.createStaticBus();
        JAXRSCxfContinuationsTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSCxfContinuationsTest.launchServer(BookCxfContinuationServer.class));
    }

    @Test
    public void testContinuation() throws Exception {
        this.doTestContinuation("books");
    }

    @Test
    public void testContinuationSubresource() throws Exception {
        this.doTestContinuation("books/subresources");
    }

    private void doTestContinuation(String pathSegment) throws Exception {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch doneSignal = new CountDownLatch(1);
        executor.execute(new BookWorker("http://localhost:" + PORT + "/bookstore/" + pathSegment + "/1", "1", "CXF in Action1", startSignal, doneSignal));
        startSignal.countDown();
        doneSignal.await(60L, TimeUnit.SECONDS);
        executor.shutdownNow();
        JAXRSCxfContinuationsTest.assertEquals((String)"Not all invocations have completed", (long)0L, (long)doneSignal.getCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBook(String address, String id, String expected) throws Exception {
        GetMethod get = new GetMethod(address);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)get);
            JAXRSCxfContinuationsTest.assertEquals((long)200L, (long)result);
            JAXRSCxfContinuationsTest.assertEquals((String)("Book description for id " + id + " is wrong"), (Object)expected, (Object)get.getResponseBodyAsString());
        }
        finally {
            get.releaseConnection();
        }
    }

    @Ignore
    private class BookWorker
    implements Runnable {
        private String address;
        private String id;
        private String expected;
        private CountDownLatch startSignal;
        private CountDownLatch doneSignal;

        public BookWorker(String address, String id, String expected, CountDownLatch startSignal, CountDownLatch doneSignal) {
            this.address = address;
            this.id = id;
            this.expected = expected;
            this.startSignal = startSignal;
            this.doneSignal = doneSignal;
        }

        @Override
        public void run() {
            try {
                this.startSignal.await();
                JAXRSCxfContinuationsTest.this.checkBook(this.address, this.id, this.expected);
                this.doneSignal.countDown();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail((String)("Book thread failed for : " + this.id));
            }
        }
    }
}

