/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.security;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;
import org.apache.cxf.systest.jaxrs.security.SecureBook;

@Path(value="/bookstorestorage/")
public class SecureBookStoreNoInterface {
    private Map<Long, Book> books = new HashMap<Long, Book>();

    public SecureBookStoreNoInterface() {
        Book book = new Book();
        book.setId(123L);
        book.setName("CXF in Action");
        this.books.put(book.getId(), book);
    }

    @POST
    @Path(value="/bookforms")
    @RolesAllowed(value={"ROLE_USER", "ROLE_ADMIN"})
    public Book getBookFromFormParams(MultivaluedMap<String, String> map, @FormParam(value="name") String name, @FormParam(value="id") long id) {
        if (name == null || id == 0L || map.getFirst((Object)"name") == null || Integer.valueOf((String)map.getFirst((Object)"id")) == 0) {
            throw new RuntimeException("FormParams are not set");
        }
        return new Book(name, id);
    }

    @POST
    @Path(value="/bookforms2")
    @RolesAllowed(value={"ROLE_USER", "ROLE_ADMIN"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Book getBookFromHttpRequestParams(@Context HttpServletRequest request) {
        Map params = CastUtils.cast((Map)request.getParameterMap());
        String name = ((String[])params.get("name"))[0];
        Long id = Long.valueOf(((String[])params.get("id"))[0]);
        if (name == null || id == 0L) {
            throw new RuntimeException("FormParams are not set");
        }
        return new Book(name, id);
    }

    @GET
    @Path(value="/thosebooks/{bookId}/{id}")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"ROLE_USER", "ROLE_ADMIN"})
    public Book getThatBook(@PathParam(value="bookId") Long id, @PathParam(value="id") String s) {
        if (s == null) {
            throw new RuntimeException();
        }
        return this.books.get(id);
    }

    @GET
    @Path(value="/thosebooks/{bookId}/")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"ROLE_USER"})
    public Book getThatBook(@PathParam(value="bookId") Long id) {
        return this.books.get(id);
    }

    @GET
    @Path(value="/thosebooks")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"ROLE_ADMIN"})
    public Book getThatBook() throws BookNotFoundFault {
        return this.books.get(123L);
    }

    @Path(value="/securebook")
    public SecureBook getSecureBook() throws BookNotFoundFault {
        return new SecureBook("CXF in Action", 123L);
    }

    @GET
    @Path(value="/thebook/{bookId}")
    @Produces(value={"application/xml"})
    @RolesAllowed(value={"ROLE_BOOK_OWNER"})
    public Book getBook(@PathParam(value="bookId") Long id) {
        return this.books.get(id);
    }
}

