/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.cxf.jaxrs.ext.Oneway;
import org.apache.cxf.jaxrs.ext.ProtocolHeaders;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookNotFoundDetails;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;
import org.apache.cxf.testutil.common.EmbeddedJMSBrokerLauncher;
import org.apache.cxf.transport.jms.JMSUtils;

@Path(value="/bookstore")
public class JMSBookStore {
    @Context
    private ProtocolHeaders headers;
    private Map<Long, Book> books = new HashMap<Long, Book>();

    public JMSBookStore() {
        this.books.put(123L, new Book("CXF JMS Rocks", 123L));
    }

    @GET
    @Path(value="/bookidarray")
    @Produces(value={"application/xml"})
    public Book getBookByURLQuery(@QueryParam(value="id") String[] ids) throws Exception {
        if (ids == null || ids.length != 3) {
            throw new WebApplicationException();
        }
        return this.doGetBook(ids[0] + ids[1] + ids[2]);
    }

    @GET
    @Path(value="/books/{bookId}/")
    @Produces(value={"application/xml"})
    public Book getBook(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    @Path(value="/booksubresource/{bookId}/")
    public Book getBookSubResource(@PathParam(value="bookId") String id) throws BookNotFoundFault {
        return this.doGetBook(id);
    }

    private Book doGetBook(String id) throws BookNotFoundFault {
        Book book = this.books.get(Long.parseLong(id));
        if (book != null) {
            return book;
        }
        BookNotFoundDetails details = new BookNotFoundDetails();
        details.setId(Long.parseLong(id));
        throw new BookNotFoundFault(details);
    }

    @POST
    @Path(value="/books")
    @Produces(value={"text/xml"})
    @Consumes(value={"application/xml"})
    public Response addBook(Book book) {
        String ct1 = this.headers.getRequestHeaderValue("Content-Type");
        String ct2 = (String)this.headers.getRequestHeader("Content-Type").get(0);
        String ct3 = (String)this.headers.getRequestHeaders().getFirst((Object)"Content-Type");
        if (!("application/xml".equals(ct1) && ct1.equals(ct2) && ct1.equals(ct3))) {
            throw new RuntimeException("Unexpected content type");
        }
        if (!"custom.value".equals(this.headers.getRequestHeaderValue("custom.protocol.header"))) {
            throw new RuntimeException("Custom header is not set");
        }
        book.setId(124L);
        this.books.put(book.getId(), book);
        return Response.ok((Object)book).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/oneway")
    @Consumes
    @Oneway
    public void onewayRequest(Book book) throws Exception {
        javax.naming.Context ctx = this.getContext();
        ConnectionFactory factory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        Destination replyToDestination = (Destination)ctx.lookup("dynamicQueues/test.jmstransport.response");
        Connection connection = null;
        try {
            connection = factory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            this.postOneWayBook(session, replyToDestination, book);
            session.close();
        }
        finally {
            try {
                connection.stop();
                connection.close();
            }
            catch (JMSException jMSException) {}
        }
    }

    private javax.naming.Context getContext() throws Exception {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        props.setProperty("java.naming.provider.url", "tcp://localhost:" + EmbeddedJMSBrokerLauncher.PORT);
        return new InitialContext(props);
    }

    private void postOneWayBook(Session session, Destination destination, Book book) throws Exception {
        MessageProducer producer = session.createProducer(destination);
        Message message = JMSUtils.createAndSetPayload((Object)this.writeBook(book), (Session)session, (String)"byte");
        producer.send(message);
        producer.close();
    }

    private byte[] writeBook(Book b) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Marshaller m = c.createMarshaller();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        m.marshal((Object)b, (OutputStream)bos);
        return bos.toByteArray();
    }
}

