/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.failover;

import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.cxf.clustering.FailoverFeature;
import org.apache.cxf.clustering.FailoverStrategy;
import org.apache.cxf.clustering.FailoverTargetSelector;
import org.apache.cxf.clustering.LoadDistributorFeature;
import org.apache.cxf.clustering.LoadDistributorTargetSelector;
import org.apache.cxf.clustering.SequentialStrategy;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.systest.jaxrs.failover.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class LoadDistributorTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        LoadDistributorTest.assertTrue((String)"server did not launch correctly", (boolean)LoadDistributorTest.launchServer(Server.class, (boolean)true));
        boolean activeReplica1Started = false;
        boolean activeReplica2Started = false;
        for (int i = 0; i < 60; ++i) {
            if (!activeReplica1Started) {
                activeReplica1Started = LoadDistributorTest.checkReplica(Server.ADDRESS2);
            }
            if (!activeReplica2Started) {
                activeReplica2Started = LoadDistributorTest.checkReplica(Server.ADDRESS3);
            }
            if (activeReplica1Started && activeReplica2Started) break;
            Thread.sleep(1000L);
        }
    }

    private static boolean checkReplica(String address) {
        try {
            Response r = WebClient.create((String)address).query("_wadl", new Object[0]).get();
            return r.getStatus() == 200;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Test
    public void testMultipleAltAddresses() throws Exception {
        FailoverFeature feature = this.getFeature(Server.ADDRESS2, Server.ADDRESS3);
        this.strategyTest(Server.ADDRESS1, feature);
    }

    @Test
    public void testSingleAltAddress() throws Exception {
        LoadDistributorFeature feature = new LoadDistributorFeature();
        ArrayList<String> alternateAddresses = new ArrayList<String>();
        alternateAddresses.add(Server.ADDRESS2);
        SequentialStrategy strategy = new SequentialStrategy();
        strategy.setAlternateAddresses(alternateAddresses);
        feature.setStrategy((FailoverStrategy)strategy);
        BookStore bookStore = this.getBookStore(Server.ADDRESS1, (FailoverFeature)feature);
        Book book = bookStore.getBook("123");
        LoadDistributorTest.assertEquals((String)"unexpected id", (long)123L, (long)book.getId());
        book = bookStore.getBook("123");
        LoadDistributorTest.assertEquals((String)"unexpected id", (long)123L, (long)book.getId());
    }

    private FailoverFeature getFeature(String ... address) {
        FailoverFeature feature = new FailoverFeature();
        ArrayList<String> alternateAddresses = new ArrayList<String>();
        for (String s : address) {
            alternateAddresses.add(s);
        }
        SequentialStrategy strategy = new SequentialStrategy();
        strategy.setAlternateAddresses(alternateAddresses);
        feature.setStrategy((FailoverStrategy)strategy);
        LoadDistributorTargetSelector selector = new LoadDistributorTargetSelector();
        selector.setFailover(false);
        feature.setTargetSelector((FailoverTargetSelector)selector);
        return feature;
    }

    protected BookStore getBookStore(String address, FailoverFeature feature) throws Exception {
        JAXRSClientFactoryBean bean = this.createBean(address, feature);
        bean.setServiceClass(BookStore.class);
        return (BookStore)bean.create(BookStore.class, new Object[0]);
    }

    protected JAXRSClientFactoryBean createBean(String address, FailoverFeature feature) {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress(address);
        ArrayList<FailoverFeature> features = new ArrayList<FailoverFeature>();
        features.add(feature);
        bean.setFeatures(features);
        return bean;
    }

    protected void strategyTest(String initialAddress, FailoverFeature feature) throws Exception {
        LoadDistributorTest.assertEquals((Object)Server.ADDRESS1, (Object)initialAddress);
        int address2Count = 0;
        int address3Count = 0;
        for (int i = 0; i < 20; ++i) {
            BookStore bookStore = this.getBookStore(initialAddress, feature);
            this.verifyStrategy(bookStore, SequentialStrategy.class);
            String bookId = "123";
            Book book = bookStore.getBook(bookId);
            LoadDistributorTest.assertNotNull((String)"expected non-null response", (Object)book);
            LoadDistributorTest.assertEquals((String)"unexpected id", (long)123L, (long)book.getId());
            String address = this.getCurrentEndpointAddress(bookStore);
            if (Server.ADDRESS2.equals(address)) {
                ++address2Count;
                continue;
            }
            if (!Server.ADDRESS3.equals(address)) continue;
            ++address3Count;
        }
        LoadDistributorTest.assertEquals((long)10L, (long)address2Count);
        LoadDistributorTest.assertEquals((long)10L, (long)address3Count);
    }

    protected String getCurrentEndpointAddress(Object client) {
        return WebClient.getConfig((Object)client).getConduitSelector().getEndpoint().getEndpointInfo().getAddress();
    }

    protected void verifyStrategy(Object proxy, Class<?> clz) {
        ConduitSelector conduitSelector = WebClient.getConfig((Object)proxy).getConduitSelector();
        if (conduitSelector instanceof FailoverTargetSelector) {
            FailoverStrategy strategy = ((FailoverTargetSelector)conduitSelector).getStrategy();
            LoadDistributorTest.assertTrue((String)"unexpected strategy", (boolean)clz.isInstance(strategy));
        } else {
            LoadDistributorTest.fail((String)("unexpected conduit selector: " + conduitSelector));
        }
    }
}

